/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.winapps;

import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.winapps.internal.WinappsToolkitInfo;

/**
 * Factory for creating components from the winapps toolkit.
 * @noextend This class is not intended to be extended by clients.
 */
public final class WinappsComponents {
	
	
	@NonNull private final static ToolkitInfo m_toolkitInformation = new WinappsToolkitInfo();

	private WinappsComponents() {
		super();
	}
	
	
	@NonNull public static ToolkitInfo getToolkitInformation() {
		return m_toolkitInformation;
	}

	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.ButtonXAML} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createXAMLButton (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.winapps.internal.impl.XAMLButton(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.ButtonInternetExplorer} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createButton (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.winapps.internal.impl.Button(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.TextXAML} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createXAMLText (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.winapps.internal.impl.XAMLText(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.TextInternetExplorer} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createText (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.winapps.internal.impl.Text(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.CheckBoxXAML} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createXAMLCheckBox (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.winapps.internal.impl.XAMLCheckBox(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.CheckBoxInternetExplorer} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createCheckBox (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.winapps.internal.impl.CheckBox(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.EditXAML} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createXAMLTextField (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.winapps.internal.impl.XAMLTextField(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.EditInternetExplorer} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createTextField (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.winapps.internal.impl.TextField(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.RadioButtonXAML} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createXAMLRadioButton (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.winapps.internal.impl.XAMLRadioButton(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.RadioButtonInternetExplorer} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createRadioButton (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.winapps.internal.impl.RadioButton(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.ListXAML} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createXAMLList (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.winapps.internal.impl.XAMLList(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.ListInternetExplorer} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createList (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.winapps.internal.impl.List(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.ComboBoxXAML} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createXAMLComboBox (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.winapps.internal.impl.XAMLComboBox(componentIdentifier);
	}
	
	/** create a new representative for a {@link com.bredexsw.guidancer.rc.dotnet.components.controltype.ComboBoxInternetExplorer} UI component.*/
	@NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createComboBox (@NonNull ComponentIdentifier componentIdentifier) {
		Validate.notNull(componentIdentifier);
		return new org.eclipse.jubula.toolkit.winapps.internal.impl.ComboBox(componentIdentifier);
	}
}