/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.winapps.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.toolkit.internal.AbstractToolkitInfo;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ComponentClass;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Property;

/**
 * Contains information about the winapps toolkit and its components
 */
public final class WinappsToolkitInfo extends AbstractToolkitInfo {

	@NonNull private Map<ComponentClass, String> m_map = new HashMap<ComponentClass, String>();

	/**
	 * Constructor
	 */
	public WinappsToolkitInfo() {
		
		
		ComponentClass newComponentClass1 = new ComponentClass("com.bredexsw.guidancer.rc.dotnet.components.controltype.ButtonXAML"); //$NON-NLS-1$
				
				
		m_map.put(newComponentClass1,"org.eclipse.jubula.rc.common.tester.ButtonTester"); //$NON-NLS-1$
			
			
		
		ComponentClass newComponentClass2 = new ComponentClass("com.bredexsw.guidancer.rc.dotnet.components.controltype.ButtonInternetExplorer"); //$NON-NLS-1$
				
				
		m_map.put(newComponentClass2,"org.eclipse.jubula.rc.common.tester.ButtonTester"); //$NON-NLS-1$
			
			
		
		ComponentClass newComponentClass3 = new ComponentClass("com.bredexsw.guidancer.rc.dotnet.components.controltype.TextXAML"); //$NON-NLS-1$
				
				
		m_map.put(newComponentClass3,"org.eclipse.jubula.rc.common.tester.LabelTester"); //$NON-NLS-1$
			
			
		
		ComponentClass newComponentClass4 = new ComponentClass("com.bredexsw.guidancer.rc.dotnet.components.controltype.TextInternetExplorer"); //$NON-NLS-1$
				
				
		m_map.put(newComponentClass4,"org.eclipse.jubula.rc.common.tester.LabelTester"); //$NON-NLS-1$
			
			
		
		ComponentClass newComponentClass5 = new ComponentClass("com.bredexsw.guidancer.rc.dotnet.components.controltype.CheckBoxXAML"); //$NON-NLS-1$
				
				
		m_map.put(newComponentClass5,"org.eclipse.jubula.rc.common.tester.ButtonTester"); //$NON-NLS-1$
			
			
		
		ComponentClass newComponentClass6 = new ComponentClass("com.bredexsw.guidancer.rc.dotnet.components.controltype.CheckBoxInternetExplorer"); //$NON-NLS-1$
				
				
		m_map.put(newComponentClass6,"org.eclipse.jubula.rc.common.tester.ButtonTester"); //$NON-NLS-1$
			
			
		
		ComponentClass newComponentClass7 = new ComponentClass("com.bredexsw.guidancer.rc.dotnet.components.controltype.EditXAML"); //$NON-NLS-1$
				
				
		m_map.put(newComponentClass7,"org.eclipse.jubula.rc.common.tester.AbstractTextComponentTester"); //$NON-NLS-1$
			
			
		
		ComponentClass newComponentClass8 = new ComponentClass("com.bredexsw.guidancer.rc.dotnet.components.controltype.EditInternetExplorer"); //$NON-NLS-1$
				
				
		m_map.put(newComponentClass8,"org.eclipse.jubula.rc.common.tester.AbstractTextComponentTester"); //$NON-NLS-1$
			
			
		
		ComponentClass newComponentClass9 = new ComponentClass("com.bredexsw.guidancer.rc.dotnet.components.controltype.RadioButtonXAML"); //$NON-NLS-1$
				
				
		m_map.put(newComponentClass9,"org.eclipse.jubula.rc.common.tester.ButtonTester"); //$NON-NLS-1$
			
			
		
		ComponentClass newComponentClass10 = new ComponentClass("com.bredexsw.guidancer.rc.dotnet.components.controltype.RadioButtonInternetExplorer"); //$NON-NLS-1$
				
				
		m_map.put(newComponentClass10,"org.eclipse.jubula.rc.common.tester.ButtonTester"); //$NON-NLS-1$
			
			
		
		ComponentClass newComponentClass11 = new ComponentClass("com.bredexsw.guidancer.rc.dotnet.components.controltype.ListXAML"); //$NON-NLS-1$
				
				
		m_map.put(newComponentClass11,"com.bredexsw.guidancer.rc.win.implclasses.ListXAMLImplClass"); //$NON-NLS-1$
			
			
		
		ComponentClass newComponentClass12 = new ComponentClass("com.bredexsw.guidancer.rc.dotnet.components.controltype.ListInternetExplorer"); //$NON-NLS-1$
				
				
		m_map.put(newComponentClass12,"com.bredexsw.guidancer.rc.win.implclasses.ListXAMLImplClass"); //$NON-NLS-1$
			
			
		
		ComponentClass newComponentClass13 = new ComponentClass("com.bredexsw.guidancer.rc.dotnet.components.controltype.ComboBoxXAML"); //$NON-NLS-1$
				
				
		m_map.put(newComponentClass13,"com.bredexsw.guidancer.rc.win.implclasses.ComboBoxImplClass"); //$NON-NLS-1$
			
			
		
		ComponentClass newComponentClass14 = new ComponentClass("com.bredexsw.guidancer.rc.dotnet.components.controltype.ComboBoxInternetExplorer"); //$NON-NLS-1$
				
				
		m_map.put(newComponentClass14,"com.bredexsw.guidancer.rc.win.implclasses.ComboBoxImplClass"); //$NON-NLS-1$
			
			
		
	}
	
	/** {@inheritDoc} */
	@NonNull public Map<ComponentClass, String> getTypeMapping() {
		return m_map;
	}
	
	/** {@inheritDoc} */
	@NonNull public String getToolkitID() {
		return "ui.toolkit.WinAppsToolkitPlugin"; //$NON-NLS-1$
	}
}