/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.monitoring;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.monitoring.IMonitoring;
import org.eclipse.jubula.autagent.monitoring.MonitoringDataStore;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.BuildMonitoringReportMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.SendMonitoringReportMessage;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildMonitoringReportCommand
implements ICommand {
    private static final Logger LOG = LoggerFactory.getLogger(BuildMonitoringReportCommand.class);
    private BuildMonitoringReportMessage m_message;
    private int m_timeout = 30000;

    public Message execute() {
        new Thread(new Runnable(){

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                IMonitoring monitoringAgent = MonitoringDataStore.getInstance().getMonitoringAgent(BuildMonitoringReportCommand.this.m_message.getAutId());
                ServerSocket serverSocket = null;
                Socket reportStreamSocket = null;
                OutputStream reportOutputStream = null;
                SendMonitoringReportMessage message = new SendMonitoringReportMessage();
                try {
                    try {
                        serverSocket = new ServerSocket(0);
                        message.setPort(serverSocket.getLocalPort());
                        AutStarter.getInstance().getCommunicator().send((Message)message);
                        serverSocket.setSoTimeout(BuildMonitoringReportCommand.this.m_timeout);
                        reportStreamSocket = serverSocket.accept();
                        reportOutputStream = reportStreamSocket.getOutputStream();
                        monitoringAgent.writeMonitoringReport(reportOutputStream);
                    }
                    catch (SocketTimeoutException ste) {
                        LOG.error("Connection timeout while waiting for client to access monitoring report stream.", (Throwable)ste);
                        if (reportOutputStream != null) {
                            try {
                                reportOutputStream.close();
                            }
                            catch (IOException e) {
                                LOG.error("Error while closing monitoring report output stream.", (Throwable)e);
                            }
                        }
                        if (reportStreamSocket != null) {
                            try {
                                reportStreamSocket.close();
                            }
                            catch (IOException e) {
                                LOG.error("Error while closing monitoring report stream socket.", (Throwable)e);
                            }
                        }
                        if (serverSocket != null) {
                            try {
                                serverSocket.close();
                            }
                            catch (IOException e) {
                                LOG.error("Error while closing monitoring report server socket.", (Throwable)e);
                            }
                        }
                    }
                    catch (IOException ioe) {
                        block50: {
                            LOG.error("I/O error occurred while streaming monitoring report.", (Throwable)ioe);
                            if (reportOutputStream == null) break block50;
                            try {
                                reportOutputStream.close();
                            }
                            catch (IOException e) {
                                LOG.error("Error while closing monitoring report output stream.", (Throwable)e);
                            }
                        }
                        if (reportStreamSocket != null) {
                            try {
                                reportStreamSocket.close();
                            }
                            catch (IOException e) {
                                LOG.error("Error while closing monitoring report stream socket.", (Throwable)e);
                            }
                        }
                        if (serverSocket != null) {
                            try {
                                serverSocket.close();
                            }
                            catch (IOException e) {
                                LOG.error("Error while closing monitoring report server socket.", (Throwable)e);
                            }
                        }
                    }
                    catch (CommunicationException ce) {
                        block51: {
                            LOG.error("Failed to send " + message.getClass().getName(), (Throwable)ce);
                            if (reportOutputStream == null) break block51;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            try {
                                reportOutputStream.close();
                            }
                            catch (IOException e) {
                                LOG.error("Error while closing monitoring report output stream.", (Throwable)e);
                            }
                        }
                        if (reportStreamSocket != null) {
                            try {
                                reportStreamSocket.close();
                            }
                            catch (IOException e) {
                                LOG.error("Error while closing monitoring report stream socket.", (Throwable)e);
                            }
                        }
                        if (serverSocket != null) {
                            try {
                                serverSocket.close();
                            }
                            catch (IOException e) {
                                LOG.error("Error while closing monitoring report server socket.", (Throwable)e);
                            }
                        }
                    }
                }
                finally {
                    if (reportOutputStream != null) {
                        try {
                            reportOutputStream.close();
                        }
                        catch (IOException e) {
                            LOG.error("Error while closing monitoring report output stream.", (Throwable)e);
                        }
                    }
                    if (reportStreamSocket != null) {
                        try {
                            reportStreamSocket.close();
                        }
                        catch (IOException e) {
                            LOG.error("Error while closing monitoring report stream socket.", (Throwable)e);
                        }
                    }
                    if (serverSocket != null) {
                        try {
                            serverSocket.close();
                        }
                        catch (IOException e) {
                            LOG.error("Error while closing monitoring report server socket.", (Throwable)e);
                        }
                    }
                }
            }
        }, "Monitoring Report Streamer").start();
        return null;
    }

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (BuildMonitoringReportMessage)message;
    }

    public void timeout() {
        LOG.error(String.valueOf(this.getClass().getName()) + ".timeout() called");
    }
}

