/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.AUTContPO;
import org.eclipse.jubula.client.core.model.ExecObjContPO;
import org.eclipse.jubula.client.core.model.IALMReportingRulePO;
import org.eclipse.jubula.client.core.model.IAUTContPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IExecObjContPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IProjectPropertiesPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.LanguageHelper;
import org.eclipse.jubula.client.core.model.ParamNodePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.model.ProjectPropertiesPO;
import org.eclipse.jubula.client.core.model.ProjectVersion;
import org.eclipse.jubula.client.core.model.SpecObjContPO;
import org.eclipse.jubula.client.core.model.TestDataCategoryPO;
import org.eclipse.jubula.client.core.persistence.PersistenceUtil;
import org.eclipse.jubula.tools.internal.exception.JBFatalException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DiscriminatorValue(value="P")
class ProjectPO
extends ParamNodePO
implements IProjectPO,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedLazy {
    private static Logger log = LoggerFactory.getLogger(ProjectPO.class);
    private ProjectPropertiesPO m_projectProperties = null;
    private AUTContPO m_autCont = null;
    private ExecObjContPO m_execObjCont = null;
    private SpecObjContPO m_specObjCont = null;
    private Integer m_clientMetaDataVersion = null;
    private ITestDataCategoryPO m_testdatacubecont;
    static final long serialVersionUID = -4365219475686348545L;
    protected WeavedAttributeValueHolderInterface _persistence_hbmAutCont_vh;
    protected WeavedAttributeValueHolderInterface _persistence_hbmExecObjCont_vh;
    protected WeavedAttributeValueHolderInterface _persistence_hbmTestDataCubeContPO_vh;
    protected WeavedAttributeValueHolderInterface _persistence_hbmSpecObjCont_vh;

    ProjectPO() {
    }

    ProjectPO(String name, Integer metadataVersion, boolean isGenerated) {
        this(metadataVersion, 1, 0, null, null, PersistenceUtil.generateGuid(), isGenerated);
        ProjectNameBP.getInstance().setName(this.getGuid(), name, false);
    }

    ProjectPO(Integer metadataVersion, Integer majorNumber, Integer minorNumber, Integer microNumber, String versionQualifier, String guid, boolean isGenerated) {
        super("dummy", guid, isGenerated);
        if (majorNumber == null && versionQualifier == null) {
            throw new JBFatalException("Project with empty qualifier and version number are not allowed", MessageIDs.E_DELETE_TESTRESULT);
        }
        this.init(metadataVersion, majorNumber, minorNumber, microNumber, versionQualifier);
    }

    private void init(Integer metadataVersion, Integer majorNumber, Integer minorNumber, Integer microNumber, String versionQualifier) {
        this.setProjectProperties(PoMaker.createProjectPropertiesPO(this.getGuid(), majorNumber, minorNumber, microNumber, versionQualifier));
        this.setAutCont(PoMaker.createAUTContPO());
        this.setTestDataCubeContPO(PoMaker.createTestDataCategoryPO());
        this.setExecObjCont(PoMaker.createExecObjContPO());
        this.setSpecObjCont(PoMaker.createSpecObjContPO());
        this.setClientMetaDataVersion(metadataVersion);
    }

    @Override
    @Transient
    public Set<IAUTMainPO> getAutMainList() {
        return Collections.unmodifiableSet(this.getHbmAutCont().getAutMainList());
    }

    @Override
    public void addAUTMain(IAUTMainPO aut) {
        this.getHbmAutCont().addAUTMain(aut);
    }

    @Override
    public void removeAUTMain(IAUTMainPO aut) {
        this.getHbmAutCont().removeAUTMain(aut);
        List<ITestSuitePO> tsList = TestSuiteBP.getListOfTestSuites();
        for (ITestSuitePO ts : tsList) {
            if (aut != ts.getAut()) continue;
            ts.setAut(null);
        }
    }

    @Override
    @Transient
    public Locale getDefaultLanguage() {
        return this.m_projectProperties.getDefaultLanguage();
    }

    @Override
    public void setDefaultLanguage(Locale defaultLanguage) {
        this.m_projectProperties.setDefaultLanguage(defaultLanguage);
    }

    @Override
    @Transient
    public String getMarkupLanguage() {
        return this.m_projectProperties.getMarkupLanguage();
    }

    @Override
    public void setMarkupLanguage(String markupLanguage) {
        this.m_projectProperties.setMarkupLanguage(markupLanguage);
    }

    @Override
    @Transient
    public ISpecObjContPO getSpecObjCont() {
        return this.getHbmSpecObjCont();
    }

    private void setSpecObjCont(ISpecObjContPO specObjCont) {
        this.setHbmSpecObjCont((SpecObjContPO)specObjCont);
        this.getHbmSpecObjCont().setParentProjectId(this.getId());
    }

    @Override
    @Transient
    public IExecObjContPO getExecObjCont() {
        return this.getHbmExecObjCont();
    }

    private void setExecObjCont(IExecObjContPO execObjCont) {
        this.setHbmExecObjCont((ExecObjContPO)execObjCont);
        this.getHbmExecObjCont().setParentProjectId(this.getId());
    }

    private void setAutCont(IAUTContPO autCont) {
        this.setHbmAutCont((AUTContPO)autCont);
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="SPECOBJ_CONT", unique=true)
    private SpecObjContPO getHbmSpecObjCont() {
        this._persistence_initialize_hbmSpecObjCont_vh();
        if (!this._persistence_hbmSpecObjCont_vh.isInstantiated()) {
            this.setHbmSpecObjCont((SpecObjContPO)this._persistence_hbmSpecObjCont_vh.getValue());
        }
        return this.m_specObjCont;
    }

    private void setHbmSpecObjCont(SpecObjContPO specObjCont) {
        this.m_specObjCont = specObjCont;
        this._persistence_initialize_hbmSpecObjCont_vh();
        this._persistence_hbmSpecObjCont_vh.setValue((Object)specObjCont);
        this._persistence_hbmSpecObjCont_vh.setIsCoordinatedWithProperty(true);
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="EXECOBJ_CONT", unique=true)
    private ExecObjContPO getHbmExecObjCont() {
        this._persistence_initialize_hbmExecObjCont_vh();
        if (!this._persistence_hbmExecObjCont_vh.isInstantiated()) {
            this.setHbmExecObjCont((ExecObjContPO)this._persistence_hbmExecObjCont_vh.getValue());
        }
        return this.m_execObjCont;
    }

    private void setHbmExecObjCont(ExecObjContPO execObjCont) {
        this.m_execObjCont = execObjCont;
        this._persistence_initialize_hbmExecObjCont_vh();
        this._persistence_hbmExecObjCont_vh.setValue((Object)execObjCont);
        this._persistence_hbmExecObjCont_vh.setIsCoordinatedWithProperty(true);
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="AUT_CONT", unique=true)
    private AUTContPO getHbmAutCont() {
        this._persistence_initialize_hbmAutCont_vh();
        if (!this._persistence_hbmAutCont_vh.isInstantiated()) {
            this.setHbmAutCont((AUTContPO)this._persistence_hbmAutCont_vh.getValue());
        }
        return this.m_autCont;
    }

    private void setHbmAutCont(AUTContPO autCont) {
        this.m_autCont = autCont;
        this._persistence_initialize_hbmAutCont_vh();
        this._persistence_hbmAutCont_vh.setValue((Object)autCont);
        this._persistence_hbmAutCont_vh.setIsCoordinatedWithProperty(true);
    }

    @Override
    @Transient
    public IAUTContPO getAutCont() {
        return this.getHbmAutCont();
    }

    public void setTestDataCubeContPO(ITestDataCategoryPO testDataCategory) {
        this.setHbmTestDataCubeContPO(testDataCategory);
        testDataCategory.setParentProjectId(this.getId());
    }

    @Override
    @Basic
    @Column(name="CONF_MAJ_VERS")
    public Integer getClientMetaDataVersion() {
        return this.m_clientMetaDataVersion;
    }

    @Override
    public void setClientMetaDataVersion(Integer metaDataVersion) {
        this.m_clientMetaDataVersion = metaDataVersion;
    }

    @Override
    @Transient
    public Set<IReusedProjectPO> getUsedProjects() {
        return Collections.unmodifiableSet(this.getProjectProperties().getUsedProjects());
    }

    @Override
    @Transient
    public Integer getMajorProjectVersion() {
        return this.getProjectProperties().getMajorNumber();
    }

    @Override
    @Transient
    public Integer getMinorProjectVersion() {
        return this.getProjectProperties().getMinorNumber();
    }

    @Override
    @Transient
    public Integer getMicroProjectVersion() {
        return this.getProjectProperties().getMicroNumber();
    }

    @Override
    @Transient
    public String getProjectVersionQualifier() {
        return this.getProjectProperties().getVersionQualifier();
    }

    @Override
    @Transient
    public boolean getIsReusable() {
        return this.getProjectProperties().getIsReusable();
    }

    @Override
    public void setIsReusable(boolean isReusable) {
        this.getProjectProperties().setIsReusable(isReusable);
    }

    @Override
    @Transient
    public boolean getIsProtected() {
        return this.getProjectProperties().getIsProtected();
    }

    @Override
    public void setIsProtected(boolean isProtected) {
        this.getProjectProperties().setIsProtected(isProtected);
    }

    @Override
    @Transient
    public List<IALMReportingRulePO> getALMReportingRules() {
        return this.getProjectProperties().getALMReportingRules();
    }

    @Override
    public void setALMReportingRules(List<IALMReportingRulePO> reportingRules) {
        this.getProjectProperties().setALMReportingRules(reportingRules);
    }

    @Override
    @Transient
    public boolean getIsTrackingActivated() {
        return this.getProjectProperties().getIsTrackingActivated();
    }

    @Override
    public void setIsTrackingActivated(boolean isTrackingActivated) {
        this.getProjectProperties().setIsTrackingActivated(isTrackingActivated);
    }

    @Override
    public void addUsedProject(IReusedProjectPO reusedProject) {
        this.getProjectProperties().addUsedProject(reusedProject);
    }

    @Override
    public void removeUsedProject(IReusedProjectPO project) {
        this.getProjectProperties().removeUsedProject(project);
    }

    @Override
    protected void setParentProjectIdForChildNode(INodePO childNode) {
        childNode.setParentProjectId(this.getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IProjectPO) {
            IProjectPO proj = (IProjectPO)obj;
            return new EqualsBuilder().append((Object)this.getGuid(), (Object)proj.getGuid()).append((Object)this.getMajorProjectVersion(), (Object)proj.getMajorProjectVersion()).append((Object)this.getMinorProjectVersion(), (Object)proj.getMinorProjectVersion()).append((Object)this.getMicroProjectVersion(), (Object)proj.getMicroProjectVersion()).append((Object)this.getProjectVersionQualifier(), (Object)proj.getProjectVersionQualifier()).isEquals();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getGuid()).append((Object)this.getMajorProjectVersion()).append((Object)this.getMinorProjectVersion()).append((Object)this.getMicroProjectVersion()).append((Object)this.getProjectVersionQualifier()).toHashCode();
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="PROJECT_PROPERTIES", unique=true)
    public ProjectPropertiesPO getProperties() {
        return this.m_projectProperties;
    }

    private void setProperties(ProjectPropertiesPO properties) {
        this.m_projectProperties = properties;
    }

    private void setProjectProperties(IProjectPropertiesPO properties) {
        this.setProperties((ProjectPropertiesPO)properties);
        if (this.getProjectProperties() != null) {
            this.getProjectProperties().setParentProjectId(this.getId());
        }
    }

    @Override
    @Transient
    public IProjectPropertiesPO getProjectProperties() {
        return this.getProperties();
    }

    @Override
    @Transient
    public LanguageHelper getLangHelper() {
        return this.getProjectProperties().getLangHelper();
    }

    @Override
    @Transient
    public String getToolkit() {
        return this.getProjectProperties().getToolkit();
    }

    @Override
    public void setToolkit(String toolkit) {
        this.getProjectProperties().setToolkit(toolkit);
    }

    @Override
    public void clearUsedProjects() {
        this.getProjectProperties().clearUsedProjects();
    }

    @Override
    @Transient
    public String getDisplayName() {
        StringBuffer sb = new StringBuffer(this.getName());
        sb.append("_").append(this.getVersionString());
        return sb.toString();
    }

    @Override
    @Transient
    public String getName() {
        return ProjectNameBP.getInstance().getName(this.getGuid());
    }

    @Override
    public void setName(String name) {
        log.debug(Messages.SetNameNotSupportedOnProjectPO);
    }

    @Override
    public void setParentProjectId(Long projectId) {
        if (this.getProjectProperties() != null) {
            this.getProjectProperties().setParentProjectId(projectId);
        }
        if (this.getHbmAutCont() != null) {
            this.getHbmAutCont().setParentProjectId(projectId);
        }
        if (this.getHbmSpecObjCont() != null) {
            this.getHbmSpecObjCont().setParentProjectId(projectId);
        }
        if (this.getHbmExecObjCont() != null) {
            this.getHbmExecObjCont().setParentProjectId(projectId);
        }
        if (this.getHbmTestDataCubeContPO() != null) {
            this.getHbmTestDataCubeContPO().setParentProjectId(projectId);
        }
    }

    @Override
    @Transient
    public String getVersionString() {
        return this.getProjectVersion().toString();
    }

    @Transient
    public Boolean isReused() {
        return true;
    }

    @Override
    @Transient
    public ITestDataCategoryPO getTestDataCubeCont() {
        return this.getHbmTestDataCubeContPO();
    }

    private void setHbmTestDataCubeContPO(ITestDataCategoryPO testDataCategory) {
        this.m_testdatacubecont = testDataCategory;
        this._persistence_initialize_hbmTestDataCubeContPO_vh();
        this._persistence_hbmTestDataCubeContPO_vh.setValue((Object)testDataCategory);
        this._persistence_hbmTestDataCubeContPO_vh.setIsCoordinatedWithProperty(true);
    }

    @OneToOne(cascade={CascadeType.ALL}, targetEntity=TestDataCategoryPO.class, fetch=FetchType.LAZY)
    @JoinColumn(name="TDC_CONT", unique=true)
    private ITestDataCategoryPO getHbmTestDataCubeContPO() {
        this._persistence_initialize_hbmTestDataCubeContPO_vh();
        if (!this._persistence_hbmTestDataCubeContPO_vh.isInstantiated()) {
            this.setHbmTestDataCubeContPO((ITestDataCategoryPO)this._persistence_hbmTestDataCubeContPO_vh.getValue());
        }
        return this.m_testdatacubecont;
    }

    @Override
    public void setTestResultCleanupInterval(int noOfDays) {
        this.getProjectProperties().setTestResultCleanupInterval(noOfDays);
    }

    @Override
    @Transient
    public Integer getTestResultCleanupInterval() {
        return this.getProjectProperties().getTestResultCleanupInterval();
    }

    @Override
    @Transient
    public ProjectVersion getProjectVersion() {
        return new ProjectVersion(this.getMajorProjectVersion(), this.getMinorProjectVersion(), this.getMicroProjectVersion(), this.getProjectVersionQualifier());
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_hbmAutCont_vh != null) {
            this._persistence_hbmAutCont_vh = (WeavedAttributeValueHolderInterface)this._persistence_hbmAutCont_vh.clone();
        }
        if (this._persistence_hbmExecObjCont_vh != null) {
            this._persistence_hbmExecObjCont_vh = (WeavedAttributeValueHolderInterface)this._persistence_hbmExecObjCont_vh.clone();
        }
        if (this._persistence_hbmTestDataCubeContPO_vh != null) {
            this._persistence_hbmTestDataCubeContPO_vh = (WeavedAttributeValueHolderInterface)this._persistence_hbmTestDataCubeContPO_vh.clone();
        }
        if (this._persistence_hbmSpecObjCont_vh != null) {
            this._persistence_hbmSpecObjCont_vh = (WeavedAttributeValueHolderInterface)this._persistence_hbmSpecObjCont_vh.clone();
        }
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ProjectPO();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "hbmAutCont") {
            return this.hbmAutCont;
        }
        if (string == "hbmExecObjCont") {
            return this.hbmExecObjCont;
        }
        if (string == "hbmTestDataCubeContPO") {
            return this.hbmTestDataCubeContPO;
        }
        if (string == "properties") {
            return this.properties;
        }
        if (string == "clientMetaDataVersion") {
            return this.clientMetaDataVersion;
        }
        if (string == "hbmSpecObjCont") {
            return this.hbmSpecObjCont;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "hbmAutCont") {
            this.hbmAutCont = (AUTContPO)object;
            return;
        }
        if (string == "hbmExecObjCont") {
            this.hbmExecObjCont = (ExecObjContPO)object;
            return;
        }
        if (string == "hbmTestDataCubeContPO") {
            this.hbmTestDataCubeContPO = (ITestDataCategoryPO)object;
            return;
        }
        if (string == "properties") {
            this.properties = (ProjectPropertiesPO)object;
            return;
        }
        if (string == "clientMetaDataVersion") {
            this.clientMetaDataVersion = (Integer)object;
            return;
        }
        if (string == "hbmSpecObjCont") {
            this.hbmSpecObjCont = (SpecObjContPO)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_hbmAutCont_vh() {
        if (this._persistence_hbmAutCont_vh == null) {
            this._persistence_hbmAutCont_vh = new ValueHolder();
            this._persistence_hbmAutCont_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_hbmAutCont_vh() {
        AUTContPO aUTContPO;
        this._persistence_initialize_hbmAutCont_vh();
        if ((this._persistence_hbmAutCont_vh.isCoordinatedWithProperty() || this._persistence_hbmAutCont_vh.isNewlyWeavedValueHolder()) && (aUTContPO = this.getHbmAutCont()) != this._persistence_hbmAutCont_vh.getValue()) {
            this.setHbmAutCont(aUTContPO);
        }
        return this._persistence_hbmAutCont_vh;
    }

    public void _persistence_set_hbmAutCont_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        Object object;
        AUTContPO aUTContPO;
        this._persistence_hbmAutCont_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated() && (aUTContPO = this.getHbmAutCont()) != (object = weavedAttributeValueHolderInterface.getValue())) {
            this.setHbmAutCont((AUTContPO)object);
        }
    }

    protected void _persistence_initialize_hbmExecObjCont_vh() {
        if (this._persistence_hbmExecObjCont_vh == null) {
            this._persistence_hbmExecObjCont_vh = new ValueHolder();
            this._persistence_hbmExecObjCont_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_hbmExecObjCont_vh() {
        ExecObjContPO execObjContPO;
        this._persistence_initialize_hbmExecObjCont_vh();
        if ((this._persistence_hbmExecObjCont_vh.isCoordinatedWithProperty() || this._persistence_hbmExecObjCont_vh.isNewlyWeavedValueHolder()) && (execObjContPO = this.getHbmExecObjCont()) != this._persistence_hbmExecObjCont_vh.getValue()) {
            this.setHbmExecObjCont(execObjContPO);
        }
        return this._persistence_hbmExecObjCont_vh;
    }

    public void _persistence_set_hbmExecObjCont_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        Object object;
        ExecObjContPO execObjContPO;
        this._persistence_hbmExecObjCont_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated() && (execObjContPO = this.getHbmExecObjCont()) != (object = weavedAttributeValueHolderInterface.getValue())) {
            this.setHbmExecObjCont((ExecObjContPO)object);
        }
    }

    protected void _persistence_initialize_hbmTestDataCubeContPO_vh() {
        if (this._persistence_hbmTestDataCubeContPO_vh == null) {
            this._persistence_hbmTestDataCubeContPO_vh = new ValueHolder();
            this._persistence_hbmTestDataCubeContPO_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_hbmTestDataCubeContPO_vh() {
        ITestDataCategoryPO iTestDataCategoryPO;
        this._persistence_initialize_hbmTestDataCubeContPO_vh();
        if ((this._persistence_hbmTestDataCubeContPO_vh.isCoordinatedWithProperty() || this._persistence_hbmTestDataCubeContPO_vh.isNewlyWeavedValueHolder()) && (iTestDataCategoryPO = this.getHbmTestDataCubeContPO()) != this._persistence_hbmTestDataCubeContPO_vh.getValue()) {
            this.setHbmTestDataCubeContPO(iTestDataCategoryPO);
        }
        return this._persistence_hbmTestDataCubeContPO_vh;
    }

    public void _persistence_set_hbmTestDataCubeContPO_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        Object object;
        ITestDataCategoryPO iTestDataCategoryPO;
        this._persistence_hbmTestDataCubeContPO_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated() && (iTestDataCategoryPO = this.getHbmTestDataCubeContPO()) != (object = weavedAttributeValueHolderInterface.getValue())) {
            this.setHbmTestDataCubeContPO((ITestDataCategoryPO)object);
        }
    }

    protected void _persistence_initialize_hbmSpecObjCont_vh() {
        if (this._persistence_hbmSpecObjCont_vh == null) {
            this._persistence_hbmSpecObjCont_vh = new ValueHolder();
            this._persistence_hbmSpecObjCont_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_hbmSpecObjCont_vh() {
        SpecObjContPO specObjContPO;
        this._persistence_initialize_hbmSpecObjCont_vh();
        if ((this._persistence_hbmSpecObjCont_vh.isCoordinatedWithProperty() || this._persistence_hbmSpecObjCont_vh.isNewlyWeavedValueHolder()) && (specObjContPO = this.getHbmSpecObjCont()) != this._persistence_hbmSpecObjCont_vh.getValue()) {
            this.setHbmSpecObjCont(specObjContPO);
        }
        return this._persistence_hbmSpecObjCont_vh;
    }

    public void _persistence_set_hbmSpecObjCont_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        Object object;
        SpecObjContPO specObjContPO;
        this._persistence_hbmSpecObjCont_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated() && (specObjContPO = this.getHbmSpecObjCont()) != (object = weavedAttributeValueHolderInterface.getValue())) {
            this.setHbmSpecObjCont((SpecObjContPO)object);
        }
    }
}

