/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.ITestDataNodePO;
import org.eclipse.jubula.client.core.model.TestDataCubePO;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.persistence.annotations.Index;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;

@Entity
@Table(name="TEST_DATA_CAT")
class TestDataCategoryPO
implements ITestDataCategoryPO,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
PersistenceWeavedRest {
    private transient Long m_id;
    private transient Integer m_version;
    private Long m_parentProjectId;
    private String m_name;
    private List<ITestDataCubePO> m_testDataChildList;
    private List<ITestDataCategoryPO> m_categoryChildList;
    private ITestDataCategoryPO m_parent;
    static final long serialVersionUID = 1902415253728673757L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;

    TestDataCategoryPO() {
        this.m_id = null;
        this.m_version = null;
        this.m_parentProjectId = null;
        this.m_name = null;
        this.m_testDataChildList = new ArrayList<ITestDataCubePO>();
        this.m_categoryChildList = new ArrayList<ITestDataCategoryPO>();
        this.m_parent = null;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, targetEntity=TestDataCubePO.class, mappedBy="parent")
    List<ITestDataCubePO> getHbmTestDataChildList() {
        return this.m_testDataChildList;
    }

    void setHbmTestDataChildList(List<ITestDataCubePO> testDataChildList) {
        this.m_testDataChildList = testDataChildList;
    }

    @Override
    @Transient
    public List<ITestDataCubePO> getTestDataChildren() {
        return Collections.unmodifiableList(this.getHbmTestDataChildList());
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, targetEntity=TestDataCategoryPO.class, mappedBy="parent")
    List<ITestDataCategoryPO> getHbmCategoryChildList() {
        return this.m_categoryChildList;
    }

    void setHbmCategoryChildList(List<ITestDataCategoryPO> categoryChildList) {
        this.m_categoryChildList = categoryChildList;
    }

    @Override
    @Transient
    public List<ITestDataCategoryPO> getCategoryChildren() {
        return Collections.unmodifiableList(this.getHbmCategoryChildList());
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    private void setId(Long id) {
        this.m_id = id;
    }

    @Override
    @Version
    @Column(name="VERSION")
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return this.getHbmParentProjectId();
    }

    @Override
    public void setParentProjectId(Long projectId) {
        this.setHbmParentProjectId(projectId);
        for (ITestDataCategoryPO category : this.getCategoryChildren()) {
            category.setParentProjectId(projectId);
        }
        for (ITestDataCubePO testData : this.getTestDataChildren()) {
            testData.setParentProjectId(projectId);
        }
    }

    @Override
    public void addCategory(ITestDataCategoryPO toAdd) {
        Assert.verify((toAdd != null ? 1 : 0) != 0);
        toAdd.setParent(this);
        this.getHbmCategoryChildList().add(toAdd);
    }

    @Override
    public void removeCategory(ITestDataCategoryPO toRemove) {
        Assert.verify((toRemove != null ? 1 : 0) != 0);
        toRemove.setParent(null);
        this.getHbmCategoryChildList().remove(toRemove);
    }

    @Override
    public void addTestData(ITestDataCubePO toAdd) {
        Assert.verify((toAdd != null ? 1 : 0) != 0);
        toAdd.setParent(this);
        this.getHbmTestDataChildList().add(toAdd);
    }

    @Override
    public void removeTestData(ITestDataCubePO toRemove) {
        Assert.verify((toRemove != null ? 1 : 0) != 0);
        toRemove.setParent(null);
        this.getHbmTestDataChildList().remove(toRemove);
    }

    @Basic
    @Column(name="PARENT_PROJ")
    @Index(name="PI_DATA_CAT_PARENT_PROJ")
    Long getHbmParentProjectId() {
        return this.m_parentProjectId;
    }

    void setHbmParentProjectId(Long projectId) {
        this.m_parentProjectId = projectId;
    }

    @Override
    @Basic
    @Column(name="NAME", length=4000)
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    @ManyToOne(targetEntity=TestDataCategoryPO.class)
    @JoinColumn(name="FK_PARENT")
    public ITestDataCategoryPO getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(ITestDataCategoryPO parent) {
        this.m_parent = parent;
    }

    @Override
    public void removeNode(ITestDataNodePO toRemove) {
        if (toRemove instanceof ITestDataCubePO) {
            this.removeTestData((ITestDataCubePO)toRemove);
        } else if (toRemove instanceof ITestDataCategoryPO) {
            this.removeCategory((ITestDataCategoryPO)toRemove);
        }
    }

    public Object _persistence_post_clone() {
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TestDataCategoryPO(persistenceObject);
    }

    public TestDataCategoryPO(PersistenceObject persistenceObject) {
    }

    public Object _persistence_get(String string) {
        if (string == "id") {
            return this.id;
        }
        if (string == "hbmCategoryChildList") {
            return this.hbmCategoryChildList;
        }
        if (string == "hbmTestDataChildList") {
            return this.hbmTestDataChildList;
        }
        if (string == "hbmParentProjectId") {
            return this.hbmParentProjectId;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "parent") {
            return this.parent;
        }
        if (string == "version") {
            return this.version;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "hbmCategoryChildList") {
            this.hbmCategoryChildList = (List)object;
            return;
        }
        if (string == "hbmTestDataChildList") {
            this.hbmTestDataChildList = (List)object;
            return;
        }
        if (string == "hbmParentProjectId") {
            this.hbmParentProjectId = (Long)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "parent") {
            this.parent = (ITestDataCategoryPO)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }
}

