/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.AbstractTextInputSupportTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITextInputComponent;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;

public class AbstractTextComponentTester
extends AbstractTextInputSupportTester {
    private ITextInputComponent getTextCompAdapter() {
        return (ITextInputComponent)this.getComponent();
    }

    private void setCaretPosition(int index) {
        if (index < 0) {
            throw new StepExecutionException("Invalid position: " + index, EventFactory.createActionError((String)"TestErrorEvent.InputFailed"));
        }
        int index2 = 0;
        String text = this.getTextCompAdapter().getText();
        if (text != null) {
            index2 = index > text.length() ? text.length() : index;
        }
        this.getTextCompAdapter().setSelection(index2);
    }

    protected void insertText(String text) {
        this.getRobot().scrollToVisible(this.getComponent().getRealComponent(), null);
        this.getRobot().type(this.getComponent().getRealComponent(), text);
    }

    public void rcReplaceText(String text) {
        this.rcSelect();
        if ("".equals(text)) {
            this.getRobot().keyStroke(ValueSets.KeyStroke.delete.rcValue());
        }
        this.insertText(text);
    }

    public void rcInputText(String text) {
        if (!this.getTextCompAdapter().hasFocus()) {
            TimeUtil.delay((long)100L);
            this.rcClick(1, 1);
        }
        this.insertText(text);
    }

    public void rcInsertText(String text, int index) {
        this.rcClick(1, 1);
        this.setCaretPosition(index);
        this.insertText(text);
    }

    public void rcInsertText(String text, String pattern, String operator, boolean after) throws StepExecutionException {
        if (text == null) {
            throw new StepExecutionException("The text to be inserted must not be null", EventFactory.createActionError());
        }
        MatchUtil.FindResult matchedText = MatchUtil.getInstance().find(this.getTextCompAdapter().getText(), pattern, operator);
        if (matchedText == null || matchedText.getStr() == null) {
            throw new StepExecutionException("The pattern '" + pattern + "' could not be found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        int index = matchedText.getPos();
        int insertPos = after ? index + matchedText.getStr().length() : index;
        this.rcInsertText(text, insertPos);
    }

    public void rcSelect() {
        this.rcClick(1, 1);
        TimeUtil.delay((long)100L);
        this.getTextCompAdapter().selectAll();
    }

    public void rcVerifyEditable(boolean editable) {
        Verifier.equals(editable, this.getTextCompAdapter().isEditable());
    }

    public void rcSelect(String pattern, String operator) throws StepExecutionException {
        this.rcClick(1, 1);
        MatchUtil.FindResult matchedText = MatchUtil.getInstance().find(this.getTextCompAdapter().getText(), pattern, operator);
        if (matchedText == null || matchedText.getStr().length() == 0) {
            throw new StepExecutionException("Invalid pattern for insertion", EventFactory.createActionError());
        }
        int index = matchedText.getPos();
        if (operator.startsWith("not")) {
            if (pattern.equals(this.getTextCompAdapter().getText())) {
                String msg = "The pattern '" + pattern + "' is equal to current text";
                throw new StepExecutionException(msg, EventFactory.createActionError((String)"TestErrorEvent.ExecutionError", (Object[])new String[]{msg}));
            }
            if (index > 0) {
                this.getTextCompAdapter().setSelection(0, index);
            } else {
                this.getTextCompAdapter().setSelection(matchedText.getStr().length(), this.getTextCompAdapter().getText().length());
            }
        } else {
            this.getTextCompAdapter().setSelection(index, index + matchedText.getStr().length());
        }
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }
}

