/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.driver;

import java.awt.AWTException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.UIManager;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.driver.IEventMatcher;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IMouseMotionTracker;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRobotEventConfirmer;
import org.eclipse.jubula.rc.common.driver.IRobotEventInterceptor;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.InterceptorOptions;
import org.eclipse.jubula.rc.common.driver.KeyTyper;
import org.eclipse.jubula.rc.common.driver.MouseMovementStrategy;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.LocalScreenshotUtil;
import org.eclipse.jubula.rc.common.util.PointUtil;
import org.eclipse.jubula.rc.javafx.components.CurrentStages;
import org.eclipse.jubula.rc.javafx.driver.ClickJavaFXEventMatcher;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.driver.KeyJavaFXEventMatcher;
import org.eclipse.jubula.rc.javafx.driver.MouseMovedEventMatcher;
import org.eclipse.jubula.rc.javafx.driver.RobotEventInterceptorJavaFXImpl;
import org.eclipse.jubula.rc.javafx.driver.RobotFactoryJavaFXImpl;
import org.eclipse.jubula.rc.javafx.driver.WindowActivationMethod;
import org.eclipse.jubula.rc.javafx.listener.ComponentHandler;
import org.eclipse.jubula.rc.javafx.util.NodeBounds;
import org.eclipse.jubula.rc.javafx.util.Rounding;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class RobotJavaFXImpl
implements IRobot {
    private static AutServerLogger log = new AutServerLogger(RobotJavaFXImpl.class);
    private static final String METAL_LAF_ID = "Metal";
    private Robot m_robot;
    private RobotEventInterceptorJavaFXImpl m_interceptor;
    private IMouseMotionTracker m_mouseMotionTracker;
    private IEventThreadQueuer m_queuer;

    public RobotJavaFXImpl(RobotFactoryJavaFXImpl factory) throws RobotException {
        try {
            this.m_robot = new Robot();
            this.m_robot.setAutoWaitForIdle(true);
            this.m_robot.setAutoDelay(0);
        }
        catch (AWTException awte) {
            log.error((Object)awte);
            this.m_robot = null;
            throw new RobotException((Throwable)awte);
        }
        catch (SecurityException se) {
            log.error((Object)se);
            this.m_robot = null;
            throw new RobotException((Throwable)se);
        }
        this.m_interceptor = factory.getRobotEventInterceptor();
        this.m_mouseMotionTracker = factory.getMouseMotionTracker();
        this.m_queuer = factory.getEventThreadQueuer();
    }

    private Point getLocation(Node comp, Point offset) throws IllegalArgumentException {
        Validate.notNull((Object)comp, (String)"component must not be null");
        Scene s = comp.getScene();
        s.getRoot().layout();
        Point2D pos = comp.localToScreen(0.0, 0.0);
        double x = pos.getX();
        double y = pos.getY();
        if (offset == null) {
            Bounds boundsInParent = comp.getBoundsInParent();
            x += boundsInParent.getWidth() / 2.0;
            y += boundsInParent.getHeight() / 2.0;
        } else {
            x += (double)offset.x;
            y += (double)offset.y;
        }
        return new Point(Rounding.round(x), Rounding.round(y));
    }

    private void clickImpl(Object graphicsComponent, Object constraints, ClickOptions clickOptions, int xPos, boolean xAbsolute, int yPos, boolean yAbsolute) throws RobotException {
        this.moveImpl(graphicsComponent, (Rectangle)constraints, xPos, xAbsolute, yPos, yAbsolute, clickOptions);
        this.clickImpl(graphicsComponent, clickOptions);
    }

    private void clickImpl(Object graphicsComp, ClickOptions clickOp) {
        int buttonMask = this.getButtonMask(clickOp.getMouseButton());
        int clickCount = clickOp.getClickCount();
        int[] modifierMask = this.getModifierMask(clickOp.getClickModifier());
        if (clickCount > 0) {
            IRobotEventConfirmer confirmer = null;
            if (clickOp.isConfirmClick()) {
                InterceptorOptions options = new InterceptorOptions(new long[]{16L});
                confirmer = this.m_interceptor.intercept(options);
            }
            try {
                this.pressModifier(modifierMask);
                RobotTiming.sleepPreClickDelay();
                int i = 0;
                while (i < clickCount) {
                    this.m_robot.mousePress(buttonMask);
                    RobotTiming.sleepPostMouseDownDelay();
                    this.m_robot.mouseRelease(buttonMask);
                    RobotTiming.sleepPostMouseUpDelay();
                    ++i;
                }
                if (confirmer != null) {
                    confirmer.waitToConfirm(null, (IEventMatcher)new ClickJavaFXEventMatcher(clickOp));
                }
            }
            finally {
                this.releaseModifier(modifierMask);
            }
        }
    }

    private void pressModifier(int[] modifierMask) {
        int i = 0;
        while (i < modifierMask.length) {
            this.keyPress(null, modifierMask[i]);
            ++i;
        }
    }

    private void releaseModifier(int[] modifierMask) {
        int i = 0;
        while (i < modifierMask.length) {
            this.keyRelease(null, modifierMask[i]);
            ++i;
        }
    }

    private int[] getModifierMask(ClickOptions.ClickModifier clickModifier) {
        int[] modifier = new int[]{};
        if (clickModifier.hasModifiers(1)) {
            modifier = ArrayUtils.add((int[])modifier, (int)KeyCode.CONTROL.impl_getCode());
        }
        if (clickModifier.hasModifiers(2)) {
            modifier = ArrayUtils.add((int[])modifier, (int)KeyCode.SHIFT.impl_getCode());
        }
        if (clickModifier.hasModifiers(4)) {
            modifier = ArrayUtils.add((int[])modifier, (int)KeyCode.ALT.impl_getCode());
        }
        if (clickModifier.hasModifiers(8)) {
            modifier = ArrayUtils.add((int[])modifier, (int)KeyCode.META.impl_getCode());
        }
        return modifier;
    }

    private boolean isMouseMoveRequired(Point p) {
        boolean result = true;
        Point point = this.getCurrentMousePosition();
        if (point != null) {
            boolean bl = result = !point.equals(p);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Last converted screen point  : " + point));
                log.debug((Object)("Required screen point        : " + p));
                log.debug((Object)("Mouse move required?         : " + result));
            }
        }
        return result;
    }

    private void moveImpl(final Object graphicsComponent, Rectangle constraints, int xPos, boolean xAbsolute, int yPos, boolean yAbsolute, ClickOptions clickOptions) throws StepExecutionException {
        Rectangle bounds = this.getComponentBounds(graphicsComponent, clickOptions);
        if (constraints != null) {
            bounds.x += constraints.x;
            bounds.y += constraints.y;
            bounds.height = constraints.height;
            bounds.width = constraints.width;
        }
        final Point p = PointUtil.calculateAwtPointToGo((int)xPos, (boolean)xAbsolute, (int)yPos, (boolean)yAbsolute, (Rectangle)bounds);
        boolean isInside = true;
        if (graphicsComponent instanceof Node) {
            isInside = EventThreadQueuerJavaFXImpl.invokeAndWait("CheckIfContains", new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return NodeBounds.checkIfContains(new Point2D((double)p.x, (double)p.y), (Node)graphicsComponent);
                }
            });
        }
        if (!isInside) {
            throw new StepExecutionException("TestErrorEvent.ClickPointInvalid", EventFactory.createActionError((String)"TestErrorEvent.ClickPointInvalid"));
        }
        if (this.isMouseMoveRequired(p)) {
            Point startpoint;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Moving mouse to: " + p));
            }
            if ((startpoint = this.m_mouseMotionTracker.getLastMousePointOnScreen()) == null) {
                Parent root;
                if (graphicsComponent instanceof Stage) {
                    Stage s = (Stage)graphicsComponent;
                    root = s.getScene().getRoot();
                    startpoint = root != null ? this.getLocation((Node)root, null) : new Point(Rounding.round(s.getWidth() / 2.0), Rounding.round(s.getHeight() / 2.0));
                } else {
                    Node node = (Node)graphicsComponent;
                    root = node.getScene().getRoot();
                    Parent c = root != null ? root : node;
                    startpoint = this.getLocation((Node)c, null);
                }
            }
            IRobotEventConfirmer confirmer = null;
            InterceptorOptions options = new InterceptorOptions(new long[]{32L});
            if (DragAndDropHelper.getInstance().isDragMode()) {
                confirmer = this.m_interceptor.intercept(options);
            }
            Point[] mouseMove = MouseMovementStrategy.getMovementPath((Point)startpoint, (Point)p, (boolean)clickOptions.getStepMovement(), (boolean)clickOptions.getFirstHorizontal());
            int i = 0;
            while (i < mouseMove.length - 1) {
                this.m_robot.mouseMove(mouseMove[i].x, mouseMove[i].y);
                this.m_robot.waitForIdle();
                ++i;
            }
            if (!DragAndDropHelper.getInstance().isDragMode()) {
                confirmer = this.m_interceptor.intercept(options);
            }
            Point endPoint = mouseMove[mouseMove.length - 1];
            this.m_robot.mouseMove(endPoint.x, endPoint.y);
            this.m_robot.waitForIdle();
            if (confirmer != null) {
                this.confirmMove(confirmer, graphicsComponent);
            }
        }
    }

    private void confirmMove(IRobotEventConfirmer confirmer, Object comp) {
        if (DragAndDropHelper.getInstance().isDragMode()) {
            confirmer.waitToConfirm(null, (IEventMatcher)new MouseMovedEventMatcher((EventType<MouseEvent>)MouseEvent.MOUSE_DRAGGED));
        } else {
            confirmer.waitToConfirm(null, (IEventMatcher)new MouseMovedEventMatcher((EventType<MouseEvent>)MouseEvent.MOUSE_MOVED));
        }
    }

    private Rectangle getComponentBounds(Object comp, ClickOptions clickOp) {
        ComponentHandler.syncStageResize();
        Rectangle bounds = null;
        if (comp instanceof Stage) {
            Stage s = (Stage)comp;
            bounds = new Rectangle(new Point(Rounding.round(s.getX()), Rounding.round(s.getY())));
            Screen screen = Screen.getPrimary();
            Rectangle2D screenBounds = screen.getBounds();
            int displayWidth = Rounding.round(screenBounds.getWidth());
            int displayHeight = Rounding.round(screenBounds.getHeight());
            if (s.isFullScreen()) {
                bounds.width = Rounding.round(displayWidth);
                bounds.height = Rounding.round(displayHeight);
            } else if (s.isMaximized()) {
                int x = Rounding.round(s.getX());
                int y = Rounding.round(s.getY());
                bounds.width = Rounding.round(s.getWidth());
                bounds.height = Rounding.round(s.getHeight());
                if (x < 0 || y < 0) {
                    bounds.x = 0;
                    bounds.y = 0;
                    if (bounds.width > displayWidth) {
                        bounds.width = displayWidth;
                    }
                    if (bounds.height > displayHeight) {
                        bounds.height = displayHeight;
                    }
                }
            } else {
                bounds.width = Rounding.round(s.getWidth());
                bounds.height = Rounding.round(s.getHeight());
            }
        } else {
            final Node node = (Node)comp;
            if (clickOp.isScrollToVisible()) {
                this.ensureComponentVisible(node);
            }
            bounds = EventThreadQueuerJavaFXImpl.invokeAndWait("Robot get node bounds", new Callable<Rectangle>(){

                @Override
                public Rectangle call() throws Exception {
                    node.getParent().requestLayout();
                    node.getParent().layout();
                    return NodeBounds.getAbsoluteBounds(node);
                }
            });
        }
        return bounds;
    }

    public void click(Object graphicsComponent, Object constraints) throws RobotException {
        this.click(graphicsComponent, constraints, ClickOptions.create());
    }

    public void click(Object graphicsComponent, Object constraints, ClickOptions clickOptions) throws RobotException {
        this.clickImpl(graphicsComponent, constraints, clickOptions, 50, false, 50, false);
    }

    private int getButtonMask(int button) {
        if (button == ValueSets.InteractionMode.primary.rcIntValue()) {
            return 16;
        }
        if (button == ValueSets.InteractionMode.tertiary.rcIntValue()) {
            return 8;
        }
        if (button == ValueSets.InteractionMode.secondary.rcIntValue()) {
            return 4;
        }
        throw new RobotException("unsupported mouse button", null);
    }

    public void clickAtCurrentPosition(Object graphicsComponent, int clickCount, int button) {
        ClickOptions clickOptions = new ClickOptions();
        clickOptions.setClickCount(clickCount);
        clickOptions.setMouseButton(button);
        this.clickImpl(graphicsComponent, clickOptions);
    }

    public void move(Object graphicsComponent, Object constraints) throws RobotException {
        this.moveImpl(graphicsComponent, (Rectangle)constraints, 50, false, 50, false, ClickOptions.create());
    }

    public void type(final Object graphicsComponent, char c) throws RobotException {
        Validate.notNull((Object)graphicsComponent, (String)"The graphic component must not be null");
        final KeyEvent event = new KeyEvent(KeyEvent.KEY_TYPED, String.valueOf(c), "", null, false, false, false, false);
        InterceptorOptions options = new InterceptorOptions(new long[]{8L});
        IRobotEventConfirmer confirmer = this.m_interceptor.intercept(options);
        this.m_queuer.invokeLater("Type character", new Runnable(){

            @Override
            public void run() {
                Scene scene = graphicsComponent instanceof Stage ? ((Stage)graphicsComponent).getScene() : ((Node)graphicsComponent).getScene();
                Node focusOwner = scene.getFocusOwner();
                Node eventTarget = focusOwner != null ? focusOwner : scene;
                Event.fireEvent((EventTarget)eventTarget, (Event)event);
            }
        });
        confirmer.waitToConfirm(graphicsComponent, (IEventMatcher)new KeyJavaFXEventMatcher((EventType<KeyEvent>)KeyEvent.KEY_TYPED));
    }

    public void type(Object graphicsComponent, String text) throws RobotException {
        if (text != null) {
            int i = 0;
            while (i < text.length()) {
                char ch = text.charAt(i);
                this.type(graphicsComponent, ch);
                ++i;
            }
        }
    }

    public void keyType(Object graphicsComponent, int keycode) {
        this.keyType(graphicsComponent, keycode, false);
    }

    public void keyType(Object graphicsComponent, int keycode, boolean isUpperCase) throws RobotException {
        try {
            InterceptorOptions options = new InterceptorOptions(new long[]{8L});
            IRobotEventConfirmer confirmer = this.m_interceptor.intercept(options);
            try {
                if (isUpperCase) {
                    this.m_robot.keyPress(16);
                }
                this.m_robot.keyPress(keycode);
                confirmer.waitToConfirm(graphicsComponent, (IEventMatcher)new KeyJavaFXEventMatcher((EventType<KeyEvent>)KeyEvent.KEY_PRESSED));
            }
            finally {
                this.m_robot.keyRelease(keycode);
                if (isUpperCase) {
                    this.m_robot.keyRelease(16);
                }
            }
            confirmer.waitToConfirm(graphicsComponent, (IEventMatcher)new KeyJavaFXEventMatcher((EventType<KeyEvent>)KeyEvent.KEY_RELEASED));
        }
        catch (IllegalArgumentException e) {
            throw new RobotException((Throwable)e);
        }
    }

    public String getSystemModifierSpec() {
        String keyStrokeSpec = ValueSets.Modifier.control.rcValue();
        if (!UIManager.getLookAndFeel().getID().equals(METAL_LAF_ID)) {
            if (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4) {
                keyStrokeSpec = ValueSets.Modifier.meta.rcValue();
            } else if (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 8) {
                keyStrokeSpec = ValueSets.Modifier.alt.rcValue();
            }
        }
        return keyStrokeSpec;
    }

    private void keyPressReleaseImpl(Object graphicsComponent, int keyCode, boolean press) {
        InterceptorOptions options = new InterceptorOptions(new long[]{8L});
        IRobotEventConfirmer confirmer = this.m_interceptor.intercept(options);
        if (press) {
            this.m_robot.keyPress(keyCode);
        } else {
            this.m_robot.keyRelease(keyCode);
        }
        confirmer.waitToConfirm(graphicsComponent, (IEventMatcher)new KeyJavaFXEventMatcher((EventType<KeyEvent>)(press ? KeyEvent.KEY_PRESSED : KeyEvent.KEY_RELEASED)));
    }

    public void keyPress(Object graphicsComponent, int keycode) throws RobotException {
        this.keyPressReleaseImpl(graphicsComponent, keycode, true);
    }

    public void keyRelease(Object graphicsComponent, int keycode) throws RobotException {
        this.keyPressReleaseImpl(graphicsComponent, keycode, false);
    }

    public void keyToggle(Object obj, int key, boolean activated) {
        this.keyPressReleaseImpl(null, key, true);
        this.keyPressReleaseImpl(null, key, false);
    }

    public void keyStroke(String keyStrokeSpec) throws RobotException {
        try {
            KeyTyper.getInstance().type(keyStrokeSpec, (IRobotEventInterceptor)this.m_interceptor, (IEventMatcher)new KeyJavaFXEventMatcher((EventType<KeyEvent>)KeyEvent.KEY_PRESSED), (IEventMatcher)new KeyJavaFXEventMatcher((EventType<KeyEvent>)KeyEvent.KEY_RELEASED));
        }
        catch (AWTException e) {
            throw new RobotException((Throwable)e);
        }
    }

    private void ensureComponentVisible(final Node component) throws RobotException {
        this.m_queuer.invokeAndWait("ensureVisible", new IRunnable(){

            public Object run() {
                Scroller scroller = new Scroller(component);
                scroller.scrollToVisible();
                return null;
            }
        });
    }

    public void scrollToVisible(Object graphicsComponent, Object constraints) throws RobotException {
        this.ensureComponentVisible((Node)graphicsComponent);
    }

    public void activateApplication(String method) throws RobotException {
        try {
            final Window window = this.getActiveWindow();
            if (window == null) {
                return;
            }
            WindowActivationMethod wam = WindowActivationMethod.createWindowActivationMethod(method, this.m_robot, this.m_queuer);
            wam.activate(window);
            Window activeWindow = (Window)this.m_queuer.invokeAndWait("getActiveWindow", new IRunnable(){

                public Object run() throws StepExecutionException {
                    if (window.isFocused()) {
                        return window;
                    }
                    return null;
                }
            });
            if (activeWindow != window) {
                throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.WindowActivationFailed", (boolean)true), EventFactory.createActionError((String)"TestErrorEvent.WindowActivationFailed"));
            }
        }
        catch (Exception exc) {
            throw new RobotException((Throwable)exc);
        }
    }

    public Point getCurrentMousePosition() {
        return MouseInfo.getPointerInfo().getLocation();
    }

    private Window getActiveWindow() {
        return (Window)this.m_queuer.invokeAndWait("getActiveWindow", new IRunnable(){

            public Object run() throws StepExecutionException {
                Stage w = CurrentStages.getfocusStage();
                if (w == null) {
                    w = CurrentStages.getfirstStage();
                    w.toFront();
                }
                return w;
            }
        });
    }

    public boolean isMouseInComponent(final Object graphicsComponent) {
        final Point currMousePos = this.getCurrentMousePosition();
        return EventThreadQueuerJavaFXImpl.invokeAndWait("isMouseInComponent", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (graphicsComponent instanceof Node) {
                    Node comp = (Node)graphicsComponent;
                    comp.getScene().getRoot().layout();
                    if (currMousePos == null) {
                        return false;
                    }
                    return NodeBounds.checkIfContains(new Point2D((double)currMousePos.x, (double)currMousePos.y), comp);
                }
                Stage comp = (Stage)graphicsComponent;
                comp.getScene().getRoot().layout();
                BoundingBox stageBounds = new BoundingBox(comp.getX(), comp.getY(), comp.getWidth(), comp.getHeight());
                return stageBounds.contains(new Point2D((double)currMousePos.x, (double)currMousePos.y));
            }
        });
    }

    public void mousePress(Object graphicsComponent, Object constraints, int button) {
        DragAndDropHelper.getInstance().setDragMode(true);
        if (graphicsComponent != null) {
            this.move(graphicsComponent, constraints);
        }
        RobotTiming.sleepPreClickDelay();
        this.m_robot.mousePress(this.getButtonMask(button));
    }

    public void mouseRelease(Object graphicsComponent, Object constraints, int button) throws RobotException {
        if (graphicsComponent != null) {
            this.move(graphicsComponent, constraints);
        }
        RobotTiming.sleepPreClickDelay();
        this.m_robot.mouseRelease(this.getButtonMask(button));
        DragAndDropHelper.getInstance().setDragMode(false);
    }

    public void click(Object graphicsComponent, Object constraints, ClickOptions clickOptions, int xPos, boolean xAbsolute, int yPos, boolean yAbsolute) throws RobotException {
        this.clickImpl(graphicsComponent, constraints, clickOptions, xPos, xAbsolute, yPos, yAbsolute);
    }

    public String getPropertyValue(Object graphicsComp, String propertyName) throws RobotException {
        String propertyValue = "";
        Validate.notNull((Object)graphicsComp, (String)"Tested component must not be null");
        try {
            Object prop = PropertyUtils.getProperty((Object)graphicsComp, (String)propertyName);
            propertyValue = String.valueOf(prop);
        }
        catch (IllegalAccessException e) {
            throw new RobotException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new RobotException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new RobotException((Throwable)e);
        }
        return propertyValue;
    }

    public BufferedImage createFullScreenCapture() {
        return LocalScreenshotUtil.createFullScreenCapture();
    }

    public RobotEventInterceptorJavaFXImpl getInterceptor() {
        return this.m_interceptor;
    }

    private class Scroller {
        private Node m_component;

        public Scroller(Node component) {
            this.m_component = component;
        }

        private void scrollObjectToVisible(Node component) {
            ArrayList<ScrollPane> panes2Scroll = new ArrayList<ScrollPane>();
            Parent p = component.getParent();
            while (p != null) {
                if (p instanceof ScrollPane) {
                    panes2Scroll.add((ScrollPane)p);
                }
                p = p.getParent();
            }
            int i = 0;
            while (i < panes2Scroll.size()) {
                ScrollPane nextPane = (ScrollPane)panes2Scroll.get(i);
                this.scrollToNode(nextPane, component);
                ++i;
            }
            Parent parent = component.getParent();
            Node scrollNode = component;
            while (!(parent == null || parent instanceof ListView || parent instanceof TableView || parent instanceof TreeView || parent instanceof ScrollPane)) {
                if (parent instanceof TreeCell) {
                    scrollNode = parent;
                }
                parent = parent.getParent();
            }
            if (parent instanceof ListView) {
                ((ListView)parent).scrollTo((Object)scrollNode);
            } else if (parent instanceof TableView) {
                ((TableView)parent).scrollTo((Object)scrollNode);
            } else if (parent instanceof TreeView && scrollNode instanceof TreeCell) {
                TreeView treeView = (TreeView)parent;
                treeView.scrollTo(treeView.getRow(((TreeCell)scrollNode).getTreeItem()));
            }
        }

        private void scrollToNode(ScrollPane sPane, Node scrollNode) {
            Parent nextParent;
            Node sPaneContent = sPane.getContent();
            if (scrollNode == sPaneContent) {
                return;
            }
            Bounds nodeInScrollPaneContent = scrollNode.getBoundsInLocal();
            Node currentNode = scrollNode;
            do {
                nextParent = currentNode.getParent();
                boolean cornerCase = false;
                if (nextParent instanceof Group) {
                    ScrollPane potentialGroupParent;
                    Parent parentLookup = nextParent.getParent();
                    while (parentLookup != null && !(parentLookup instanceof ScrollPane)) {
                        parentLookup = parentLookup.getParent();
                    }
                    if (parentLookup != null && (potentialGroupParent = (ScrollPane)parentLookup).getContent() == nextParent) {
                        cornerCase = true;
                    }
                }
                if (cornerCase) continue;
                nodeInScrollPaneContent = currentNode.localToParent(nodeInScrollPaneContent);
            } while ((currentNode = nextParent) != sPaneContent);
            double nodeX = nodeInScrollPaneContent.getMinX();
            double nodeY = nodeInScrollPaneContent.getMinY();
            double hmin = sPane.getHmin();
            double scaleH = sPane.getHmax() - hmin;
            double vmin = sPane.getVmin();
            double scaleV = sPane.getVmax() - vmin;
            Bounds viewPortBounds = sPane.getViewportBounds();
            Bounds contentBounds = sPaneContent.getBoundsInLocal();
            double actuallyScrollableHDistance = contentBounds.getWidth() - viewPortBounds.getWidth();
            double actuallyScrollableVDistance = contentBounds.getHeight() - viewPortBounds.getHeight();
            sPane.setHvalue(hmin + nodeX / actuallyScrollableHDistance * scaleH);
            sPane.setVvalue(vmin + nodeY / actuallyScrollableVDistance * scaleV);
        }

        public void scrollToVisible() {
            this.scrollObjectToVisible(this.m_component);
        }
    }
}

