/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.tester.adapter;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuItemComponent;
import org.eclipse.jubula.rc.swing.tester.adapter.AbstractComponentAdapter;
import org.eclipse.jubula.rc.swing.tester.adapter.JMenuAdapter;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class JMenuItemAdapter
extends AbstractComponentAdapter
implements IMenuItemComponent {
    private JMenuItem m_menuItem;

    public JMenuItemAdapter(Object objectToAdapt) {
        this.m_menuItem = (JMenuItem)objectToAdapt;
    }

    protected IRobot getRobot() throws RobotException {
        return this.getRobotFactory().getRobot();
    }

    public IEventThreadQueuer getEventThreadQueuer() {
        return this.getRobotFactory().getEventThreadQueuer();
    }

    public Object getRealComponent() {
        return this.m_menuItem;
    }

    public void setComponent(Object element) {
        this.m_menuItem = (JMenuItem)element;
    }

    public boolean isEnabled() {
        Boolean actual = (Boolean)this.getEventThreadQueuer().invokeAndWait("isEnabled", new IRunnable(){

            public Object run() {
                return JMenuItemAdapter.this.m_menuItem != null && JMenuItemAdapter.this.m_menuItem.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return actual;
    }

    public String getText() {
        return (String)this.getEventThreadQueuer().invokeAndWait("getText", new IRunnable(){

            public Object run() {
                return JMenuItemAdapter.this.m_menuItem.getText();
            }
        });
    }

    public boolean isShowing() {
        Boolean actual = (Boolean)this.getEventThreadQueuer().invokeAndWait("isShowing", new IRunnable(){

            public Object run() {
                return JMenuItemAdapter.this.m_menuItem != null && JMenuItemAdapter.this.m_menuItem.isShowing() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return actual;
    }

    public boolean isExisting() {
        return this.m_menuItem != null;
    }

    public boolean isSelected() {
        Boolean actual = (Boolean)this.getEventThreadQueuer().invokeAndWait("isSelected", new IRunnable(){

            public Object run() {
                return JMenuItemAdapter.this.m_menuItem != null && JMenuItemAdapter.this.m_menuItem.isSelected() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return actual;
    }

    public IMenuComponent getMenu() {
        if (this.m_menuItem instanceof JMenu) {
            return new JMenuAdapter(this.m_menuItem);
        }
        return null;
    }

    public boolean hasSubMenu() {
        return this.m_menuItem.getSubElements().length > 0;
    }

    public boolean isSeparator() {
        return this.m_menuItem == null;
    }

    public void selectMenuItem() {
        this.clickMenuItem(this.getRobot(), this.m_menuItem);
    }

    public IMenuComponent openSubMenu() {
        if (!this.m_menuItem.isEnabled()) {
            throw new StepExecutionException("menu item not enabled", EventFactory.createActionError((String)"TestErrorEvent.MenuItemNotEnabled"));
        }
        if (!(this.m_menuItem instanceof JMenu)) {
            throw new StepExecutionException("unexpected item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        JMenu menu = (JMenu)this.m_menuItem;
        this.clickMenuItem(this.getRobot(), this.m_menuItem);
        RobotTiming.sleepPostShowSubMenuItem((int)menu.getDelay());
        return this.getMenu();
    }

    private void clickMenuItem(IRobot robot, JMenuItem item) {
        if (!item.isEnabled()) {
            throw new StepExecutionException("menu item not enabled", EventFactory.createActionError((String)"TestErrorEvent.MenuItemNotEnabled"));
        }
        if (item.getParent() instanceof JPopupMenu && ((JPopupMenu)item.getParent()).getInvoker().getParent() instanceof JMenuBar) {
            robot.click((Object)item, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED).setFirstHorizontal(false));
        } else {
            robot.click((Object)item, null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
        }
    }
}

