/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.listener;

import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.ComponentNotFoundException;
import org.eclipse.jubula.rc.common.exception.ComponentNotManagedException;
import org.eclipse.jubula.rc.common.exception.NoIdentifierForComponentException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.listener.BaseAUTListener;
import org.eclipse.jubula.rc.swt.SwtAUTServer;
import org.eclipse.jubula.rc.swt.components.SwtAUTHierarchy;
import org.eclipse.jubula.rc.swt.driver.EventThreadQueuerSwtImpl;
import org.eclipse.jubula.rc.swt.listener.BaseSwtEventListener;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentHandler
extends BaseSwtEventListener
implements BaseAUTListener {
    private static Logger log = LoggerFactory.getLogger(ComponentHandler.class);
    private static SwtAUTHierarchy autHierarchy = new SwtAUTHierarchy();

    public ComponentHandler() {
        EventThreadQueuerSwtImpl etQueuer = new EventThreadQueuerSwtImpl();
        etQueuer.invokeAndWait(String.valueOf(this.getClass().getName()) + "Add active shell to AUT Hierarchy", new IRunnable(){

            public Object run() throws StepExecutionException {
                Shell activeShell = ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay().getActiveShell();
                if (activeShell != null) {
                    autHierarchy.add(activeShell);
                }
                return null;
            }
        });
    }

    public static IComponentIdentifier getIdentifier(Widget component) throws NoIdentifierForComponentException {
        try {
            return autHierarchy.getComponentIdentifier(component);
        }
        catch (ComponentNotManagedException cnme) {
            log.warn(cnme.getLocalizedMessage(), (Throwable)cnme);
            throw new NoIdentifierForComponentException("unable to create an identifier for '" + component + "'", MessageIDs.E_COMPONENT_ID_CREATION);
        }
    }

    public static IComponentIdentifier[] getAllComponentId() {
        return autHierarchy.getAllComponentId();
    }

    /*
     * Unable to fully structure code
     */
    public static Widget findComponent(final IComponentIdentifier componentIdentifier, boolean retry, int timeout) throws ComponentNotFoundException, IllegalArgumentException {
        block7: {
            start = System.currentTimeMillis();
            try {
                return ComponentHandler.autHierarchy.findComponent(componentIdentifier);
            }
            catch (ComponentNotManagedException cnme) {
                ComponentHandler.log.debug(cnme.getLocalizedMessage(), (Throwable)cnme);
                if (!retry) break block7;
                ** while (System.currentTimeMillis() - start < (long)timeout)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    Thread.sleep(100L);
                    queuer = new EventThreadQueuerSwtImpl();
                    component = (Widget)queuer.invokeAndWait("findComponent", new IRunnable(){

                        public Object run() throws StepExecutionException {
                            try {
                                return autHierarchy.findComponent(componentIdentifier);
                            }
                            catch (ComponentNotManagedException componentNotManagedException) {
                            }
                            catch (InvalidDataException invalidDataException) {}
                            return null;
                        }
                    });
                    if (component == null) continue;
                    return component;
                }
                catch (InterruptedException v0) {}
                continue;
            }
        }
        throw new ComponentNotFoundException(cnme.getMessage(), MessageIDs.E_COMPONENT_NOT_FOUND);
        catch (IllegalArgumentException iae) {
            ComponentHandler.log.error(iae.getLocalizedMessage(), (Throwable)iae);
            throw iae;
        }
        catch (InvalidDataException ide) {
            ComponentHandler.log.error(ide.getLocalizedMessage(), (Throwable)ide);
            throw new ComponentNotFoundException(ide.getMessage(), MessageIDs.E_COMPONENT_NOT_FOUND);
        }
    }

    public long[] getEventMask() {
        return new long[]{26L, 22L, 9L, 23L};
    }

    private void eventDispatched(Event event) {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                if (log.isDebugEnabled()) {
                    log.debug(event.toString());
                }
                int id = event.type;
                switch (id) {
                    case 9: 
                    case 22: 
                    case 26: {
                        if (event.widget instanceof Shell) {
                            Shell window = (Shell)event.widget;
                            autHierarchy.refreshShell(window);
                            break;
                        }
                        this.refreshComponent(event.widget);
                        break;
                    }
                    case 23: {
                        autHierarchy.componentRemoved(event.widget);
                    }
                }
                if (AUTServer.getInstance().getMode() == 2) {
                    AUTServer.getInstance().updateHighLighter();
                }
            }
            catch (Throwable t) {
                log.error("exception during ComponentHandler", t);
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    private void refreshComponent(Widget toRefresh) {
        if (toRefresh != null && !toRefresh.isDisposed()) {
            autHierarchy.refreshComponent(toRefresh);
        }
    }

    public static SwtAUTHierarchy getAutHierarchy() {
        return autHierarchy;
    }

    public void handleEvent(Event event) {
        this.eventDispatched(event);
    }
}

