/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.listener.EventLock;
import org.eclipse.jubula.rc.common.tester.AbstractMenuTester;
import org.eclipse.jubula.rc.common.tester.WidgetTester;
import org.eclipse.jubula.rc.swt.driver.DragAndDropHelperSwt;
import org.eclipse.jubula.rc.swt.driver.EventThreadQueuerSwtImpl;
import org.eclipse.jubula.rc.swt.tester.CAPUtil;
import org.eclipse.jubula.rc.swt.tester.MenuTester;
import org.eclipse.jubula.rc.swt.tester.adapter.AbstractComponentAdapter;
import org.eclipse.jubula.rc.swt.tester.adapter.ControlAdapter;
import org.eclipse.jubula.rc.swt.tester.util.EventListener;
import org.eclipse.jubula.rc.swt.tester.util.SimulatedTooltip;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class WidgetAdapter
extends AbstractComponentAdapter {
    private Widget m_component = null;

    public WidgetAdapter(Object objectToAdapt) {
        this.m_component = (Widget)objectToAdapt;
    }

    public Object getRealComponent() {
        return this.m_component;
    }

    public void rcDrop(final int xPos, final String xUnits, final int yPos, final String yUnits, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        String modifier = dndHelper.getModifier();
        final int mouseButton = dndHelper.getMouseButton();
        try {
            CAPUtil.pressOrReleaseModifiers(modifier, true);
            this.getEventThreadQueuer().invokeAndWait("startDrag", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, mouseButton);
                    CAPUtil.shakeMouse();
                    WidgetAdapter.this.clickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
                    return null;
                }
            });
            WidgetTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            this.getRobot().mouseRelease(null, null, mouseButton);
            CAPUtil.pressOrReleaseModifiers(modifier, false);
        }
    }

    public void rcDrag(int mouseButton, String modifier, int xPos, String xUnits, int yPos, String yUnits) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.clickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
    }

    protected void clickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        this.getRobot().click((Object)this.m_component, null, ClickOptions.create().setClickCount(count).setMouseButton(button), xPos, xUnits.equalsIgnoreCase(ValueSets.Unit.pixel.rcValue()), yPos, yUnits.equalsIgnoreCase(ValueSets.Unit.pixel.rcValue()));
    }

    public AbstractMenuTester showPopup(final int button) {
        final Widget component = this.m_component;
        if (SwtUtils.isMouseCursorInWidget(component)) {
            return this.showPopup(component, new Runnable(){

                public void run() {
                    RobotTiming.sleepPreShowPopupDelay();
                    WidgetAdapter.this.getRobot().clickAtCurrentPosition((Object)component, 1, button);
                }
            });
        }
        return this.showPopup(50, ValueSets.Unit.percent.rcValue(), 50, ValueSets.Unit.percent.rcValue(), button);
    }

    public AbstractMenuTester showPopup(final int xPos, final String xUnits, final int yPos, final String yUnits, final int button) throws StepExecutionException {
        final Widget component = this.m_component;
        return this.showPopup(component, new Runnable(){

            public void run() {
                RobotTiming.sleepPreShowPopupDelay();
                boolean isAbsoluteUnitsX = ValueSets.Unit.pixel.rcValue().equalsIgnoreCase(xUnits);
                boolean isAbsoluteUnitsY = ValueSets.Unit.pixel.rcValue().equalsIgnoreCase(yUnits);
                WidgetAdapter.this.getRobot().click((Object)component, null, ClickOptions.create().setClickCount(1).setMouseButton(button), xPos, isAbsoluteUnitsX, yPos, isAbsoluteUnitsY);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractMenuTester showPopup(Widget component, Runnable showPopup) throws StepExecutionException {
        EventLock lock;
        ControlAdapter.PopupShownCondition cond;
        block10: {
            cond = new ControlAdapter.PopupShownCondition();
            lock = new EventLock();
            final EventListener listener = new EventListener(lock, cond);
            final Display d = component.getDisplay();
            EventThreadQueuerSwtImpl queuer = new EventThreadQueuerSwtImpl();
            queuer.invokeAndWait("addPopupShownListeners", new IRunnable(){

                public Object run() {
                    d.addFilter(22, (Listener)listener);
                    return null;
                }
            });
            try {
                try {
                    showPopup.run();
                    EventLock eventLock = lock;
                    synchronized (eventLock) {
                        long timeout = 10000L;
                        long done = System.currentTimeMillis() + timeout;
                        while (!lock.isReleased() && timeout > 0L) {
                            lock.wait(timeout);
                            long now = System.currentTimeMillis();
                            timeout = done - now;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    queuer.invokeAndWait("removePopupShownListeners", new IRunnable(d, listener){
                        private final /* synthetic */ Display val$d;
                        private final /* synthetic */ EventListener val$listener;
                        {
                            this.val$d = display;
                            this.val$listener = eventListener;
                        }

                        public Object run() {
                            this.val$d.removeFilter(22, (Listener)this.val$listener);
                            return null;
                        }
                    });
                    break block10;
                }
            }
            catch (Throwable throwable) {
                queuer.invokeAndWait("removePopupShownListeners", new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            queuer.invokeAndWait("removePopupShownListeners", new /* invalid duplicate definition of identical inner class */);
        }
        if (!lock.isReleased()) {
            throw new StepExecutionException("popup not shown", EventFactory.createActionError((String)"TestErrorEvent.PopupNotFound"));
        }
        MenuTester contextMenu = new MenuTester();
        contextMenu.setComponent(cond.getPopup());
        contextMenu.setContextMenu(true);
        return contextMenu;
    }

    public void showToolTip(final String text, final int textSize, final int timePerWord, final int windowWidth) {
        final Rectangle bounds = (Rectangle)this.getEventThreadQueuer().invokeAndWait("showToolTip.getBounds", new IRunnable(){

            public Object run() {
                return SwtUtils.getWidgetBounds(WidgetAdapter.this.m_component);
            }
        });
        SimulatedTooltip sp = (SimulatedTooltip)this.getEventThreadQueuer().invokeAndWait("showToolTip.initToolTip", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new SimulatedTooltip(timePerWord, text, windowWidth, textSize, bounds);
            }
        });
        sp.start();
        try {
            sp.join();
        }
        catch (InterruptedException e) {
            throw new StepExecutionException((Throwable)e);
        }
    }
}

