/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the Application component from the concrete toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2014-12-16T14:48:12.940Z")
public interface Application {
    
    
        /**
         * Performs arbitrary clicks into the currently active AUT window
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP clickInActiveWindow(
            @NonNull Integer numberOfClicks,
            @NonNull InteractionMode mouseButton,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP activate(
            @NonNull AUTActivationMethod activationMethod
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP inputText(
            @NonNull String text
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP keyCombination(
            @NonNull Modifier[] modifierKeys,
            @NonNull String baseKey
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP setToggleKey(
            @NonNull Integer key,
            @NonNull Boolean activateKey
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP wait(
            @NonNull Integer millisecs
        ) throws IllegalArgumentException;
        
        @NonNull public CAP pauseTestExecution(
        ) ;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP waitForWindow(
            @NonNull String title,
            @NonNull Operator operator,
            @NonNull Integer timeoutInMs,
            @NonNull Integer delayAfterVisibility
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP waitForWindowActivation(
            @NonNull String title,
            @NonNull Operator operator,
            @NonNull Integer timeoutInMs,
            @NonNull Integer delayAfterVisibility
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP waitForWindowToClose(
            @NonNull String title,
            @NonNull Operator operator,
            @NonNull Integer timeoutInMs,
            @NonNull Integer delayAfterClosure
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP takeScreenshot(
            @NonNull String destination,
            @NonNull Integer delay,
            @NonNull String fileAccess,
            @NonNull Integer scalingFactor,
            @NonNull Boolean createDirectories
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP externalKeyCombination(
            @NonNull Modifier[] modifierKeys,
            @NonNull String baseKey
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP externalInputText(
            @NonNull String text
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP copyTextToClipboard(
            @NonNull String text
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkNumericValues(
            @NonNull String value1,
            @NonNull String comparisonMethod,
            @NonNull String value2
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP takeScreenshotOfActiveWindow(
            @NonNull String destination,
            @NonNull Integer delay,
            @NonNull String fileAccess,
            @NonNull Integer scalingFactor,
            @NonNull Boolean createDirectories,
            @NonNull Integer marginTop,
            @NonNull Integer marginRight,
            @NonNull Integer marginBottom,
            @NonNull Integer marginLeft
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkStringValues(
            @NonNull String value1,
            @NonNull String value2Operator,
            @NonNull String value2
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfWindow(
            @NonNull String title,
            @NonNull Operator operator,
            @NonNull Boolean exists
        ) throws IllegalArgumentException;
        
} 