/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the ListComponent component from the concrete toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2014-12-16T14:48:12.955Z")
public interface ListComponent extends org.eclipse.jubula.toolkit.base.components.TextComponent {
    
    
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionOfEntryByValue(
            @NonNull String text,
            @NonNull Operator operator,
            @NonNull Boolean selected
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfEntryByValue(
            @NonNull String text,
            @NonNull Operator operator,
            @NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionOfEntryByIndex(
            @NonNull String index,
            @NonNull Boolean selected
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectEntryByIndexIndices(
            @NonNull String index,
            @NonNull BinaryChoice extendSelection,
            @NonNull InteractionMode mouseButton,
            @NonNull Integer numberOfClicks
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectEntryByValueS(
            @NonNull String text,
            @NonNull Operator operator,
            @NonNull SearchType searchType,
            @NonNull BinaryChoice extendSelection,
            @NonNull InteractionMode mouseButton,
            @NonNull Integer numberOfClicks
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragEntryByValue(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull String text,
            @NonNull Operator operator,
            @NonNull SearchType searchType
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragEntryByIndex(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull Integer index
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnEntryByValue(
            @NonNull String text,
            @NonNull Operator operator,
            @NonNull SearchType searchType,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnEntryByIndex(
            @NonNull Integer index,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException;
        
} 