/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the TableComponent component from the concrete toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2014-12-16T14:48:12.962Z")
public interface TableComponent extends org.eclipse.jubula.toolkit.base.components.TextInputComponent {
    
    
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP inputTextSpecifyCell(
            @NonNull String text,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP replaceTextSpecifyCell(
            @NonNull String text,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectCell(
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull Integer numberOfClicks,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits,
            @NonNull BinaryChoice extendSelection,
            @NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP move(
            @NonNull Direction direction,
            @NonNull Integer numberOfCells,
            @NonNull Integer numberOfClicks,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits,
            @NonNull BinaryChoice extendSelection
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEditabilitySpecifyCell(
            @NonNull Boolean editable,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEditabilityOfSelectedCell(
            @NonNull Boolean editable
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEditabilityOfCellMousePosition(
            @NonNull Boolean editable
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkTextSpecifyCell(
            @NonNull String text,
            @NonNull Operator textOperator,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkTextMousePosition(
            @NonNull String text,
            @NonNull Operator operator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfValueInRow(
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType,
            @NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfValueInColumn(
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType,
            @NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectValueFromColumn(
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull Integer numberOfClicks,
            @NonNull BinaryChoice extendSelection,
            @NonNull SearchType searchType,
            @NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectValueFromRow(
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull Integer numberOfClicks,
            @NonNull BinaryChoice extendSelection,
            @NonNull SearchType searchType,
            @NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragCell(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnCell(
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragCellFromColumn(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnCellFromColumn(
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragCellFromRow(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnCellFromRow(
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionOfCheckboxInSelectedRow(
            @NonNull Boolean checked
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionOfCheckboxAtMousePosition(
            @NonNull Boolean checked
        ) throws IllegalArgumentException;
        
        @NonNull public CAP toggleCheckboxInSelectedRow(
        ) ;
        
        @NonNull public CAP toggleCheckboxAtMousePosition(
        ) ;
        
} 