/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the TreeComponent component from the concrete toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2014-12-16T14:48:12.975Z")
public interface TreeComponent extends org.eclipse.jubula.toolkit.base.components.GraphicsComponent {
    
    
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP collapseNodeByTextpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String textpath,
            @NonNull Operator operator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP collapseNodeByIndexpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String indexpath
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP expandNodeByTextpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String textpath,
            @NonNull Operator operator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP expandNodeByIndexpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String indexpath
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectNodeByTextpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Integer numberOfClicks,
            @NonNull InteractionMode mouseButton,
            @NonNull BinaryChoice extendSelection
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectNodeByIndexpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String indexpath,
            @NonNull Integer numberOfClicks,
            @NonNull InteractionMode mouseButton,
            @NonNull BinaryChoice extendSelection
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP move(
            @NonNull TreeDirection direction,
            @NonNull Integer numberOfNodes,
            @NonNull Integer numberOfClicks
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfNodeByTextpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfNodeByIndexpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String indexpath,
            @NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkTextOfSelectedNodeS(
            @NonNull String text,
            @NonNull Operator operator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkTextMousePosition(
            @NonNull String text,
            @NonNull Operator operator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragNodeByTextpath(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String treeTextpath,
            @NonNull Operator operator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnNodeByTextpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String treeTextpath,
            @NonNull Operator operator,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragNodeByIndexpath(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String treeIndexpath
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnNodeByIndexpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String treeIndexpath,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException;
        
} 