/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the TableComponent component from the concrete toolkit.
 */
@RealizedType(realizedType="guidancer.abstract.TextInputSupport")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2014-12-16T14:48:12.967Z")
public class TableComponent extends org.eclipse.jubula.toolkit.base.internal.impl.TextInputComponent implements org.eclipse.jubula.toolkit.concrete.components.TableComponent {
            public TableComponent(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP inputTextSpecifyCell(
            @NonNull String text,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcInputText"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(row), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(rowOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(column), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(columnOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP replaceTextSpecifyCell(
            @NonNull String text,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcReplaceText"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(row), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(rowOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(column), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(columnOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectCell(
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull Integer numberOfClicks,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits,
            @NonNull BinaryChoice extendSelection,
            @NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcSelectCell"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(row), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(rowOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(column), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(columnOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(numberOfClicks), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(xPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(yPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(extendSelection.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP move(
            @NonNull Direction direction,
            @NonNull Integer numberOfCells,
            @NonNull Integer numberOfClicks,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits,
            @NonNull BinaryChoice extendSelection
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcMove"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(direction, "Argument 'direction' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(direction.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(numberOfCells, "Argument 'numberOfCells' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(numberOfCells), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(numberOfClicks), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(xPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(yPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(extendSelection.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEditabilitySpecifyCell(
            @NonNull Boolean editable,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyEditable"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(editable, "Argument 'editable' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(editable), "java.lang.Boolean")); //$NON-NLS-1$
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(row), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(rowOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(column), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(columnOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEditabilityOfSelectedCell(
            @NonNull Boolean editable
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyEditableSelected"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(editable, "Argument 'editable' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(editable), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEditabilityOfCellMousePosition(
            @NonNull Boolean editable
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyEditableMousePosition"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(editable, "Argument 'editable' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(editable), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkTextSpecifyCell(
            @NonNull String text,
            @NonNull Operator textOperator,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyText"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(textOperator, "Argument 'textOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(textOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(row), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(rowOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(column), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(columnOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkTextMousePosition(
            @NonNull String text,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyTextAtMousePosition"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfValueInRow(
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType,
            @NonNull Boolean exists
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyValueInRow"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(row), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(rowOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(value), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(valueOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(exists), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfValueInColumn(
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType,
            @NonNull Boolean exists
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyValueInColumn"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(column), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(columnOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(value), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(valueOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(exists), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectValueFromColumn(
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull Integer numberOfClicks,
            @NonNull BinaryChoice extendSelection,
            @NonNull SearchType searchType,
            @NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcSelectRowByValue"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(column), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(columnOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(value), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(valueOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(numberOfClicks), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(extendSelection.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectValueFromRow(
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull Integer numberOfClicks,
            @NonNull BinaryChoice extendSelection,
            @NonNull SearchType searchType,
            @NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcSelectCellByColValue"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(row), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(rowOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(value), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(valueOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(numberOfClicks), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(extendSelection.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragCell(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcDragCell"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(row), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(rowOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(column), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(columnOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(xPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(yPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnCell(
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcDropCell"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(row), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(rowOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(column), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(columnOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(xPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(yPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(delayBeforeDropMilliseconds), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragCellFromColumn(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcDragRowByValue"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(column), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(columnOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(value), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(valueOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnCellFromColumn(
            @NonNull String column,
            @NonNull Operator columnOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcDropRowByValue"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(column), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(columnOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(value), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(valueOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(delayBeforeDropMilliseconds), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragCellFromRow(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcDragCellByColValue"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(row), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(rowOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(value), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(valueOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnCellFromRow(
            @NonNull String row,
            @NonNull Operator rowOperator,
            @NonNull String value,
            @NonNull Operator valueOperator,
            @NonNull SearchType searchType,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcDropCellByColValue"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(row), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(rowOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(value), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(valueOperator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(searchType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(delayBeforeDropMilliseconds), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionOfCheckboxInSelectedRow(
            @NonNull Boolean checked
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyCheckboxInSelectedRow"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(checked, "Argument 'checked' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(checked), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionOfCheckboxAtMousePosition(
            @NonNull Boolean checked
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyCheckboxInRowAtMousePosition"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(checked, "Argument 'checked' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(checked), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        @NonNull public CAP toggleCheckboxInSelectedRow(
        )  {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcToggleCheckboxInSelectedRow"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            return messageCap;
        }
        
        @NonNull public CAP toggleCheckboxAtMousePosition(
        )  {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcToggleCheckboxInRowAtMousePosition"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            return messageCap;
        }
        
} 