/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the TreeComponent component from the concrete toolkit.
 */
@RealizedType(realizedType="guidancer.abstract.Widget")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2014-12-16T14:48:12.978Z")
public class TreeComponent extends org.eclipse.jubula.toolkit.base.internal.impl.GraphicsComponent implements org.eclipse.jubula.toolkit.concrete.components.TreeComponent {
            public TreeComponent(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP collapseNodeByTextpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String textpath,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcCollapse"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(preAscend), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(textpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP collapseNodeByIndexpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String indexpath
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcCollapseByIndices"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(preAscend), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(indexpath), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP expandNodeByTextpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String textpath,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcExpand"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(preAscend), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(textpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP expandNodeByIndexpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String indexpath
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcExpandByIndices"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(preAscend), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(indexpath), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectNodeByTextpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Integer numberOfClicks,
            @NonNull InteractionMode mouseButton,
            @NonNull BinaryChoice extendSelection
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcSelect"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(preAscend), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(textpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(numberOfClicks), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(extendSelection.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectNodeByIndexpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String indexpath,
            @NonNull Integer numberOfClicks,
            @NonNull InteractionMode mouseButton,
            @NonNull BinaryChoice extendSelection
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcSelectByIndices"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(preAscend), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(indexpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(numberOfClicks), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(extendSelection.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP move(
            @NonNull TreeDirection direction,
            @NonNull Integer numberOfNodes,
            @NonNull Integer numberOfClicks
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcMove"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(direction, "Argument 'direction' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(direction.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(numberOfNodes, "Argument 'numberOfNodes' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(numberOfNodes), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(numberOfClicks), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfNodeByTextpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Boolean exists
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyPath"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(preAscend), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(textpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(exists), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfNodeByIndexpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String indexpath,
            @NonNull Boolean exists
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyPathByIndices"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(preAscend), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(indexpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(exists), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkTextOfSelectedNodeS(
            @NonNull String text,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifySelectedValue"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkTextMousePosition(
            @NonNull String text,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyTextAtMousePosition"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragNodeByTextpath(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String treeTextpath,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcDragByTextPath"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(preAscend), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(treeTextpath, "Argument 'treeTextpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(treeTextpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnNodeByTextpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String treeTextpath,
            @NonNull Operator operator,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcDropByTextPath"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(preAscend), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(treeTextpath, "Argument 'treeTextpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(treeTextpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(delayBeforeDropMilliseconds), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragNodeByIndexpath(
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String treeIndexpath
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcDragByIndexPath"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(preAscend), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(treeIndexpath, "Argument 'treeIndexpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(treeIndexpath), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnNodeByIndexpath(
            @NonNull SearchType pathType,
            @NonNull Integer preAscend,
            @NonNull String treeIndexpath,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcDropByIndexPath"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(pathType, "Argument 'pathType' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(pathType.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(preAscend, "Argument 'preAscend' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(preAscend), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(treeIndexpath, "Argument 'treeIndexpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(treeIndexpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(delayBeforeDropMilliseconds), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
} 