/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.gef.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the {@link org.eclipse.draw2d.FigureCanvas} component from the gef toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2014-12-16T14:48:12.759Z")
public interface FigureCanvas extends org.eclipse.jubula.toolkit.base.components.GraphicsComponent {
    
    
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkFigureExistence(
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkToolExistence(
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP clickFigure(
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Integer numberOfClicks,
            @NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP clickInFigure(
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Integer numberOfClicks,
            @NonNull InteractionMode mouseButton,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectTool(
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Integer numberOfClicks
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP clickConnection(
            @NonNull String sourceTextPath,
            @NonNull String sourceOperator,
            @NonNull String targetTextPath,
            @NonNull String targetOperator,
            @NonNull Integer numberOfClicks,
            @NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dragFigure(
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull InteractionMode mouseButton,
            @NonNull Modifier[] modifierKeys,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP dropOnFigure(
            @NonNull String textpath,
            @NonNull Operator operator,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits,
            @NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkFigureProperty(
            @NonNull String textpath,
            @NonNull Operator textOperator,
            @NonNull String propertyName,
            @NonNull String propertyValue,
            @NonNull Operator valueOperator
        ) throws IllegalArgumentException;
        
} 