/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.javafx;

import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.javafx.internal.JavafxToolkitInfo;

/**
 * Factory for creating components from the javafx toolkit.
 * @noextend This class is not intended to be extended by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.FactoryGenerator", 
           date =  "2014-12-16T14:48:12.858Z")
public final class JavafxComponents {
    
    @NonNull private final static ToolkitInfo m_toolkitInformation = new JavafxToolkitInfo();

    private JavafxComponents() {
        super();
    }
    
    @NonNull public static ToolkitInfo getToolkitInformation() {
        return m_toolkitInformation;
    }

    /** create a new representative for a {@link Stage} component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.Application createStage () {
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.Stage();
    }
    /** create a new representative for a {@link javafx.scene.control.ButtonBase} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createButtonBase (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.ButtonBase(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.Button} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createButton (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.Button(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.MenuButton} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createMenuButton (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.MenuButton(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.CheckBox} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createCheckBox (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.CheckBox(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.Hyperlink} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createHyperlink (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.Hyperlink(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.ToggleButton} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createToggleButton (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.ToggleButton(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.RadioButton} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createRadioButton (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.RadioButton(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.Label} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createLabel (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.Label(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TitledPane} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createTitledPane (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TitledPane(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.text.Text} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createText (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.Text(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TextInputControl} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createTextInputControl (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TextInputControl(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TextField} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createTextField (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TextField(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.PasswordField} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createPasswordField (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.PasswordField(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TextArea} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createTextArea (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TextArea(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TableView} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TableComponent createTableView (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TableView(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TreeView} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TreeComponent createTreeView (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TreeView(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TreeTableView} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.javafx.components.TreeTableView createTreeTableView (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TreeTableView(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.Accordion} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TabComponent createAccordion (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.Accordion(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.ChoiceBox} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createChoiceBox (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.ChoiceBox(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.ComboBox} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createComboBox (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.ComboBox(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.control.TabPane} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TabComponent createTabPane (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.TabPane(componentIdentifier);
    }
    /** create a new representative for a {@link MenuBar} component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.MenuBarComponent createMenuBar () {
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.MenuBar();
    }
    /** create a new representative for a {@link javafx.scene.control.ListView} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createListView (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.ListView(componentIdentifier);
    }
    /** create a new representative for a {@link javafx.scene.image.ImageView} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.base.components.GraphicsComponent createImageView (@NonNull ComponentIdentifier componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.javafx.internal.impl.ImageView(componentIdentifier);
    }
}