/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.swt.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the {@link org.eclipse.swt.widgets.ToolItem} component from the swt toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2014-12-16T14:48:12.776Z")
public interface ToolItem extends org.eclipse.jubula.toolkit.swt.components.Item {
    
    
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectMenuEntryByTextpath(
            @NonNull String menupath,
            @NonNull Operator operator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectMenuEntryByIndexpath(
            @NonNull String indexpath
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEnablementOfEntryByTextpath(
            @NonNull String menupath,
            @NonNull Operator operator,
            @NonNull Boolean enabled
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEnablementOfEntryByIndexpath(
            @NonNull String indexpath,
            @NonNull Boolean enabled
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfEntryByTextpath(
            @NonNull String menupath,
            @NonNull Operator operator,
            @NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfEntryByIndexpath(
            @NonNull String indexpath,
            @NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionOfEntryByTextpath(
            @NonNull String menupath,
            @NonNull Operator operator,
            @NonNull Boolean selected
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionOfEntryByIndexpath(
            @NonNull String indexpath,
            @NonNull Boolean selected
        ) throws IllegalArgumentException;
        
} 