/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.communication;

import java.net.InetAddress;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.IClientTest;
import org.eclipse.jubula.client.core.agent.AutAgentRegistration;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.events.AUTEvent;
import org.eclipse.jubula.client.core.events.AUTServerEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IObjectMappingProfilePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.internal.AutAgentConnection;
import org.eclipse.jubula.client.internal.BaseAUTConnection;
import org.eclipse.jubula.client.internal.BaseConnection;
import org.eclipse.jubula.client.internal.commands.AUTStartedCommand;
import org.eclipse.jubula.client.internal.commands.ConnectToAutResponseCommand;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.listener.ICommunicationErrorListener;
import org.eclipse.jubula.communication.internal.message.AUTStateMessage;
import org.eclipse.jubula.communication.internal.message.ConnectToAutMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.SendAUTListOfSupportedComponentsMessage;
import org.eclipse.jubula.communication.internal.message.SendCompSystemI18nMessage;
import org.eclipse.jubula.communication.internal.message.UnknownMessageException;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.constants.EnvConstants;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Profile;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AUTConnection
extends BaseAUTConnection {
    static final Logger LOG = LoggerFactory.getLogger(AUTConnection.class);
    private static AUTConnection instance = null;
    private AUTConnectionListener m_autConnectionListener = new AUTConnectionListener();

    private AUTConnection() throws ConnectionException {
        this.getCommunicator().addCommunicationErrorListener((ICommunicationErrorListener)this.m_autConnectionListener);
    }

    public static synchronized AUTConnection getInstance() throws ConnectionException {
        if (instance == null) {
            instance = new AUTConnection();
        }
        return instance;
    }

    public synchronized void reset() {
        super.reset();
        instance = null;
    }

    public boolean connectToAut(AutIdentifier autId, IProgressMonitor monitor) {
        DataEventDispatcher ded;
        block16: {
            ded = DataEventDispatcher.getInstance();
            if (!this.isConnected()) {
                block14: {
                    block15: {
                        block13: {
                            ded.fireAutServerConnectionChanged(DataEventDispatcher.ServerState.Connecting);
                            monitor.subTask(NLS.bind((String)Messages.ConnectingToAUT, (Object)autId.getExecutableName()));
                            LOG.info(Messages.EstablishingConnectionToAUT);
                            this.run();
                            this.getCommunicator().addCommunicationErrorListener((ICommunicationErrorListener)this.m_autConnectionListener);
                            ConnectToAutResponseCommand responseCommand = new ConnectToAutResponseCommand();
                            AutAgentConnection.getInstance().getCommunicator().request((Message)new ConnectToAutMessage(EnvConstants.LOCALHOST_FQDN, this.getCommunicator().getLocalPort(), autId), (ICommand)responseCommand, 10000);
                            if (responseCommand.getMessage() == null || responseCommand.getMessage().getErrorMessage() == null) break block13;
                            ded.fireAutServerConnectionChanged(DataEventDispatcher.ServerState.Disconnected);
                            monitor.done();
                            return false;
                        }
                        long startTime = System.currentTimeMillis();
                        while (!monitor.isCanceled() && !this.isConnected() && AutAgentConnection.getInstance().isConnected() && startTime + 10000L > System.currentTimeMillis()) {
                            TimeUtil.delay((long)200L);
                        }
                        if (!this.isConnected()) break block14;
                        this.setConnectedAutId(autId);
                        LOG.info(Messages.ConnectionToAUTEstablished);
                        IAUTMainPO aut = AutAgentRegistration.getAutForId(autId, GeneralStorage.getInstance().getProject());
                        if (aut != null) {
                            AUTStartedCommand response = new AUTStartedCommand();
                            response.setStateMessage(new AUTStateMessage(1));
                            this.setup(response);
                            break block15;
                        }
                        LOG.warn(Messages.ErrorOccurredActivatingObjectMapping);
                    }
                    monitor.done();
                    return true;
                }
                try {
                    LOG.error(Messages.ConnectionToAUTCouldNotBeEstablished);
                }
                catch (CommunicationException e) {
                    LOG.error(Messages.ErrorOccurredEstablishingConnectionToAUT, (Throwable)e);
                    monitor.done();
                    break block16;
                }
                catch (JBVersionException e) {
                    try {
                        LOG.error(Messages.ErrorOccurredEstablishingConnectionToAUT, (Throwable)e);
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        monitor.done();
                    }
                }
                monitor.done();
            } else {
                LOG.warn(Messages.CannotEstablishNewConnectionToAUT);
            }
        }
        ded.fireAutServerConnectionChanged(DataEventDispatcher.ServerState.Disconnected);
        return false;
    }

    public void setup(AUTStartedCommand command) throws BaseConnection.NotConnectedException, ConnectionException, CommunicationException {
        this.sendKeyboardLayoutToAut();
        this.sendResourceBundlesToAut();
        this.getAllComponentsFromAUT(command);
    }

    private void sendResourceBundlesToAut() {
        SendCompSystemI18nMessage i18nMessage = new SendCompSystemI18nMessage();
        i18nMessage.setResourceBundles(CompSystemI18n.bundlesToString());
        try {
            this.send((Message)i18nMessage);
        }
        catch (CommunicationException e) {
            LOG.error(Messages.CommunicationErrorWhileSettingResourceBundle, (Throwable)e);
        }
    }

    private void getAllComponentsFromAUT(AUTStartedCommand command) throws CommunicationException {
        LOG.info(Messages.GettingAllComponentsFromAUT);
        try {
            SendAUTListOfSupportedComponentsMessage message = new SendAUTListOfSupportedComponentsMessage();
            CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
            IAUTMainPO connectedAut = TestExecution.getInstance().getConnectedAut();
            String autToolkitId = connectedAut.getToolkit();
            List components = compSystem.getComponents(autToolkitId, true);
            components.retainAll(compSystem.getConcreteComponents());
            message.setComponents(components);
            Profile profile = new Profile();
            IObjectMappingProfilePO profilePo = connectedAut.getObjMap().getProfile();
            profile.setNameFactor(profilePo.getNameFactor());
            profile.setPathFactor(profilePo.getPathFactor());
            profile.setContextFactor(profilePo.getContextFactor());
            profile.setThreshold(profilePo.getThreshold());
            message.setProfile(profile);
            int timeoutToUse = 500000;
            this.request((Message)message, (ICommand)command, timeoutToUse);
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() <= startTime + (long)timeoutToUse && !command.wasExecuted() && this.isConnected()) {
                TimeUtil.delay((long)500L);
            }
            if (!command.wasExecuted() && this.isConnected()) {
                throw new CommunicationException(Messages.CouldNotRequestComponentsFromAUT, MessageIDs.E_COMMUNICATOR_CONNECTION);
            }
        }
        catch (UnknownMessageException ume) {
            ClientTest.instance().fireAUTServerStateChanged(new AUTServerEvent(ume.getErrorId()));
        }
    }

    private class AUTConnectionListener
    implements ICommunicationErrorListener {
        private AUTConnectionListener() {
        }

        public void connectionGained(InetAddress inetAddress, int port) {
            if (LOG.isInfoEnabled()) {
                try {
                    String logMessage = String.valueOf(Messages.ConnectedTo) + inetAddress.getHostName() + ":" + String.valueOf(port);
                    LOG.info(logMessage);
                }
                catch (SecurityException securityException) {
                    LOG.debug(Messages.SecurityViolationGettingHostNameFromIP);
                }
            }
            ClientTest.instance().fireAUTServerStateChanged(new AUTServerEvent(1));
        }

        public void shutDown() {
            if (LOG.isInfoEnabled()) {
                LOG.info(Messages.ConnectionToAUTServerClosed);
                LOG.info(Messages.ClosingConnectionToTheAutStarter);
            }
            AUTConnection.this.disconnectFromAut();
            DataEventDispatcher.getInstance().fireAutServerConnectionChanged(DataEventDispatcher.ServerState.Disconnected);
            IClientTest clientTest = ClientTest.instance();
            clientTest.fireAUTServerStateChanged(new AUTServerEvent(8));
            clientTest.fireAUTStateChanged(new AUTEvent(2));
            clientTest.fireAUTServerStateChanged(new AUTServerEvent(2));
        }

        public void sendFailed(Message message) {
            LOG.error(String.valueOf(Messages.SendingMessageFailed) + ":" + message.toString());
            LOG.error(Messages.ClosingConnectionToTheAUTServer);
            AUTConnection.this.close();
        }

        public void acceptingFailed(int port) {
            LOG.warn(String.valueOf(Messages.AcceptingFailed) + ":" + String.valueOf(port));
        }

        public void connectingFailed(InetAddress inetAddress, int port) {
            StringBuilder msg = new StringBuilder();
            msg.append(Messages.ConnectingFailed);
            msg.append("(");
            msg.append(")");
            msg.append(" ");
            msg.append(Messages.CalledAlthoughThisIsServer);
            LOG.error(msg.toString());
        }
    }
}

