/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.adapter;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.SelectionUtil;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.util.NodeBounds;
import org.eclipse.jubula.rc.javafx.util.NodeTraverseHelper;
import org.eclipse.jubula.rc.javafx.util.Rounding;

public class TreeTableOperationContext
extends AbstractTreeOperationContext<TreeTableView<?>, Object> {
    private static AutServerLogger log = new AutServerLogger(TreeTableOperationContext.class);
    private int m_column = 0;

    public TreeTableOperationContext(IEventThreadQueuer queuer, IRobot robot, TreeTableView<?> treeTable) {
        super(queuer, robot, treeTable);
        Validate.notNull((Object)treeTable.getRoot());
    }

    public void setColumn(int column) {
        this.m_column = column;
    }

    protected String convertValueToText(final Object node, int row) throws StepExecutionException {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("convertValueToText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                Object val;
                TreeItem item;
                if (node instanceof TreeItem && (item = (TreeItem)node) != null && (val = item.getValue()) != null) {
                    return val.toString();
                }
                return node.toString();
            }
        });
        return result;
    }

    public Collection<String> getNodeTextList(Object node) {
        String rendText;
        ArrayList<String> res = new ArrayList<String>();
        int rowNotUsed = 0;
        String valText = this.convertValueToText(node, rowNotUsed);
        if (valText != null) {
            res.add(valText);
        }
        if ((rendText = this.getRenderedText(node)) != null) {
            res.add(rendText);
        }
        return res;
    }

    public String getRenderedText(Object node) throws StepExecutionException {
        return this.getRenderedTextFromCell(node, 0);
    }

    public String getRenderedTextOfColumn(Object node) throws StepExecutionException {
        return this.getRenderedTextFromCell(node, this.m_column);
    }

    private String getRenderedTextFromCell(final Object node, final int col) {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("getRenderedText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (node instanceof TreeTableCell) {
                    TreeTableCell cell = (TreeTableCell)node;
                    return cell.getText();
                }
                if (node instanceof TreeItem) {
                    TreeItem item = (TreeItem)node;
                    TreeTableView treeTable = (TreeTableView)TreeTableOperationContext.this.getTree();
                    List<TreeTableCell> cells = new NodeTraverseHelper<TreeTableCell>().getInstancesOf((Parent)treeTable, TreeTableCell.class);
                    for (TreeTableCell cell : cells) {
                        TreeItem checkItem;
                        TreeTableRow ttRow = cell.getTreeTableRow();
                        if (ttRow == null || (checkItem = ttRow.getTreeItem()) == null || item == null || !checkItem.equals(item) || treeTable.getColumns().indexOf((Object)cell.getTableColumn()) != col) continue;
                        return cell.getText();
                    }
                }
                return null;
            }
        });
        return result;
    }

    public boolean isVisible(final Object node) {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isVisible", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TreeItem item = (TreeItem)node;
                if (item.isExpanded() && ((TreeTableView)TreeTableOperationContext.this.getTree()).isVisible()) {
                    return true;
                }
                return false;
            }
        });
        return result;
    }

    public Rectangle getVisibleRowBounds(final Rectangle rowBounds) {
        Rectangle result = EventThreadQueuerJavaFXImpl.invokeAndWait("getVisibleRowBounds", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                TreeTableView tree = (TreeTableView)TreeTableOperationContext.this.getTree();
                tree.layout();
                Rectangle visibleTreeBounds = new Rectangle(0, 0, Rounding.round(tree.getWidth()), Rounding.round(tree.getHeight()));
                return rowBounds.intersection(visibleTreeBounds);
            }
        });
        return result;
    }

    public boolean isExpanded(final Object node) {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isExpanded", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TreeItem item = (TreeItem)node;
                return item.isExpanded();
            }
        });
        return result;
    }

    public void scrollNodeToVisible(final Object node) {
        EventThreadQueuerJavaFXImpl.invokeAndWait("scrollNodeToVisible", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int index = ((TreeTableView)TreeTableOperationContext.this.getTree()).getRow((TreeItem)node);
                ((TreeTableView)TreeTableOperationContext.this.getTree()).scrollTo(index);
                ((TreeTableView)TreeTableOperationContext.this.getTree()).scrollToColumnIndex(TreeTableOperationContext.this.m_column);
                ((TreeTableView)TreeTableOperationContext.this.getTree()).layout();
                return null;
            }
        });
    }

    public void clickNode(Object node, ClickOptions clickOps) {
        this.scrollNodeToVisible(node);
        Rectangle rowBounds = this.getNodeBounds(node);
        Rectangle visibleRowBounds = this.getVisibleRowBounds(rowBounds);
        this.getRobot().click(this.getTree(), (Object)visibleRowBounds, clickOps);
    }

    public void expandNode(final Object node) {
        this.scrollNodeToVisible(node);
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("expandNode", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                TreeItem item = (TreeItem)node;
                TreeTableView treeTable = (TreeTableView)TreeTableOperationContext.this.getTree();
                List<TreeTableCell> cells = new NodeTraverseHelper<TreeTableCell>().getInstancesOf((Parent)treeTable, TreeTableCell.class);
                for (TreeTableCell treeTableCell : cells) {
                    TreeItem checkItem;
                    TreeTableRow ttRow = treeTableCell.getTreeTableRow();
                    if (ttRow == null || (checkItem = ttRow.getTreeItem()) == null || item == null || !checkItem.equals(item) || item.isExpanded()) continue;
                    return treeTableCell.getTreeTableRow().getDisclosureNode();
                }
                return null;
            }
        });
        if (result != null) {
            this.getRobot().click(result, null, ClickOptions.create().setClickCount(1).setMouseButton(1));
        }
        EventThreadQueuerJavaFXImpl.invokeAndWait("expandNodeCheckIfExpanded", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TreeItem item = (TreeItem)node;
                if (!((TreeTableView)TreeTableOperationContext.this.getTree()).isDisabled() && !item.isExpanded()) {
                    log.warn((Object)("Expand node fallback used for: " + item.getValue()));
                    item.setExpanded(true);
                }
                return null;
            }
        });
    }

    public void collapseNode(final Object node) {
        this.scrollNodeToVisible(node);
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("collapseNode", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                TreeItem item = (TreeItem)node;
                TreeTableView treeTable = (TreeTableView)TreeTableOperationContext.this.getTree();
                List<TreeTableCell> cells = new NodeTraverseHelper<TreeTableCell>().getInstancesOf((Parent)treeTable, TreeTableCell.class);
                for (TreeTableCell treeTableCell : cells) {
                    TreeItem checkItem;
                    TreeTableRow ttRow = treeTableCell.getTreeTableRow();
                    if (ttRow == null || (checkItem = ttRow.getTreeItem()) == null || item == null || !checkItem.equals(item) || !item.isExpanded()) continue;
                    return treeTableCell.getTreeTableRow().getDisclosureNode();
                }
                return null;
            }
        });
        if (result != null) {
            this.getRobot().click(result, null, ClickOptions.create().setClickCount(1).setMouseButton(1));
        }
        EventThreadQueuerJavaFXImpl.invokeAndWait("collapseNodeCheckIfExpanded", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TreeItem item = (TreeItem)node;
                if (!((TreeTableView)TreeTableOperationContext.this.getTree()).isDisabled() && item.isExpanded()) {
                    log.warn((Object)("Expand node fallback used for: " + item.getValue()));
                    item.setExpanded(true);
                }
                return null;
            }
        });
    }

    public Object getSelectedNode() {
        TreeItem result = (TreeItem)EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedNode", new Callable<TreeItem<?>>(){

            @Override
            public TreeItem<?> call() throws Exception {
                return (TreeItem)((TreeTableView)TreeTableOperationContext.this.getTree()).getSelectionModel().getSelectedItem();
            }
        });
        if (result != null) {
            SelectionUtil.validateSelection((Object[])new Object[]{result});
        } else {
            SelectionUtil.validateSelection((Object[])new Object[0]);
        }
        return result;
    }

    public Object[] getSelectedNodes() {
        Object[] result = EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedNodes", new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                return ((TreeTableView)TreeTableOperationContext.this.getTree()).getSelectionModel().getSelectedItems().toArray();
            }
        });
        SelectionUtil.validateSelection((Object[])result);
        return result;
    }

    public Object[] getRootNodes() {
        Object[] result = EventThreadQueuerJavaFXImpl.invokeAndWait("getRootNodes", new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                TreeTableView tree = (TreeTableView)TreeTableOperationContext.this.getTree();
                if (tree.showRootProperty().getValue().booleanValue()) {
                    return new Object[]{tree.getRoot()};
                }
                return TreeTableOperationContext.this.getChildren(tree.getRoot());
            }
        });
        return result;
    }

    public Object getParent(final Object child) {
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getParent", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((TreeItem)child).getParent();
            }
        });
        return result;
    }

    public Object getChild(final Object parent, final int index) {
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getChild", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((TreeItem)parent).getChildren().get(index);
            }
        });
        return result;
    }

    public int getNumberOfChildren(final Object parent) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getNumberOfChildren", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ((TreeItem)parent).getChildren().size();
            }
        });
    }

    public boolean isLeaf(final Object node) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("isLeaf", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (((TreeItem)node).getChildren().size() == 0) {
                    return true;
                }
                return false;
            }
        });
    }

    public Object[] getChildren(final Object parent) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getChildren", new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                return ((TreeItem)parent).getChildren().toArray();
            }
        });
    }

    public Rectangle getNodeBounds(final Object node) {
        this.scrollNodeToVisible(node);
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getNodeBounds", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                TreeTableView treeTable = (TreeTableView)TreeTableOperationContext.this.getTree();
                treeTable.layout();
                TreeItem item = (TreeItem)node;
                List<TreeTableCell> cells = new NodeTraverseHelper<TreeTableCell>().getInstancesOf((Parent)treeTable, TreeTableCell.class);
                for (TreeTableCell cell : cells) {
                    TreeItem checkItem;
                    TreeTableRow ttRow = cell.getTreeTableRow();
                    if (ttRow == null || (checkItem = ttRow.getTreeItem()) == null || item == null || !checkItem.equals(item) || treeTable.getColumns().indexOf((Object)cell.getTableColumn()) != TreeTableOperationContext.this.m_column) continue;
                    Rectangle b = NodeBounds.getAbsoluteBounds((Node)cell);
                    Rectangle treeB = NodeBounds.getAbsoluteBounds((Node)treeTable);
                    return new Rectangle(Math.abs(treeB.x - b.x), Math.abs(treeB.y - b.y), Rounding.round(b.getWidth()), Rounding.round(b.getHeight()));
                }
                return null;
            }
        });
    }

    public int getIndexOfChild(final Object parent, final Object child) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getIndexOfChild", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ((TreeItem)parent).getChildren().indexOf(child);
            }
        });
    }
}

