/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.components.AUTHierarchy;
import org.eclipse.jubula.rc.common.exception.ComponentNotManagedException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.components.FindSWTComponentBP;
import org.eclipse.jubula.rc.swt.components.SwtComponent;
import org.eclipse.jubula.rc.swt.components.SwtHierarchyContainer;
import org.eclipse.jubula.rc.swt.listener.ComponentHandler;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.objects.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwtAUTHierarchy
extends AUTHierarchy {
    private static AutServerLogger log = new AutServerLogger(SwtAUTHierarchy.class);
    private static FindSWTComponentBP findBP = new FindSWTComponentBP();
    private Map<Shell, ShellClosingListener> m_shellToListenerMap = new HashMap<Shell, ShellClosingListener>();

    public void add(Shell window) {
        if (window == null || window.isDisposed()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("adding window " + window));
        }
        if (this.getRealMap().get(window) != null) {
            return;
        }
        if (this.getHierarchyContainer((Widget)window) != null) {
            return;
        }
        SwtHierarchyContainer hierarchyWindow = new SwtHierarchyContainer(new SwtComponent((Widget)window));
        this.addToHierachyMap(hierarchyWindow);
        this.registerAsWindowListener(window);
        Composite parent = window.getParent();
        if (parent != null) {
            SwtHierarchyContainer hierarchyParent = this.getHierarchyContainer((Widget)parent);
            if (hierarchyParent == null) {
                hierarchyParent = new SwtHierarchyContainer(new SwtComponent((Widget)parent));
                this.name(hierarchyParent);
            }
            hierarchyParent.add(hierarchyWindow);
            this.name(hierarchyWindow);
            this.addToHierachyMap(hierarchyParent);
            this.addToHierarchyUp(hierarchyParent, parent);
        }
        this.addToHierarchyDown(hierarchyWindow, (Widget)window);
    }

    private void remove(Shell window) {
        if (log.isInfoEnabled()) {
            log.info((Object)("deregistering window listener from window " + window));
        }
        if (!window.isDisposed() && this.m_shellToListenerMap.containsKey(window)) {
            window.removeShellListener((ShellListener)this.m_shellToListenerMap.get(window));
        }
        this.m_shellToListenerMap.remove(window);
        if (this.getRealMap().get(window) != null) {
            SwtHierarchyContainer windowContainer = (SwtHierarchyContainer)((Object)this.getHierarchyMap().get(this.getRealMap().get(window)));
            if (windowContainer != null) {
                SwtHierarchyContainer parentContainer = windowContainer.getParent();
                if (parentContainer != null) {
                    parentContainer.remove(windowContainer);
                }
                this.removeFromHierarchy(windowContainer);
            } else {
                log.error((Object)("an unmanaged window was closed: " + window));
            }
        }
    }

    public synchronized IComponentIdentifier getComponentIdentifier(Widget component) throws ComponentNotManagedException {
        ComponentIdentifier result = new ComponentIdentifier();
        try {
            result.setComponentClassName(component.getClass().getName());
            result.setSupportedClassName(AUTServerConfiguration.getInstance().getTestableClass(component.getClass()).getName());
            List<String> hierarchy = this.getPathToRoot(component);
            result.setHierarchyNames(hierarchy);
            result.setNeighbours(this.getComponentContext(component));
            SwtHierarchyContainer container = this.getHierarchyContainer(component);
            this.setAlternativeDisplayName(container, component, (IComponentIdentifier)result);
            if (component.equals(findBP.findComponent((IComponentIdentifier)result, ComponentHandler.getAutHierarchy()))) {
                result.setEqualOriginalFound(true);
            }
            return result;
        }
        catch (IllegalArgumentException iae) {
            log.error((Object)iae);
            throw new ComponentNotManagedException("getComponentIdentifier() called for an unmanaged component " + component, MessageIDs.E_COMPONENT_NOT_MANAGED);
        }
    }

    protected List<String> getComponentContext(Object component) {
        SwtHierarchyContainer parent;
        Widget comp = (Widget)component;
        ArrayList<String> context = new ArrayList<String>();
        Widget widgetParent = SwtUtils.getWidgetParent(comp);
        if (widgetParent != null && (parent = this.getHierarchyContainer(widgetParent)) != null) {
            SwtHierarchyContainer[] comps = parent.getComponents();
            int i = 0;
            while (i < comps.length) {
                Widget child = comps[i].getComponentID().getRealComponent();
                if (!child.equals(comp)) {
                    String toAdd = String.valueOf(child.getClass().getName()) + "_" + 1;
                    while (context.contains(toAdd)) {
                        int lastCount = Integer.valueOf(toAdd.substring(toAdd.lastIndexOf("_") + 1));
                        toAdd = String.valueOf(child.getClass().getName()) + "_" + (lastCount + 1);
                    }
                    context.add(toAdd);
                }
                ++i;
            }
        }
        return context;
    }

    public synchronized IComponentIdentifier[] getAllComponentId() {
        Vector<IComponentIdentifier> result = new Vector<IComponentIdentifier>();
        Set keys = this.getHierarchyMap().keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Widget component = ((SwtComponent)((Object)iter.next())).getRealComponent();
            try {
                if (!AUTServerConfiguration.getInstance().isSupported((Object)component)) continue;
                result.add(this.getComponentIdentifier(component));
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)"hierarchy map contains null values", (Throwable)iae);
            }
            catch (ComponentNotManagedException e) {
                log.error((Object)("component '" + component.getClass().getName() + "' not found!"), (Throwable)e);
            }
        }
        return result.toArray(new IComponentIdentifier[result.size()]);
    }

    public Widget findComponent(IComponentIdentifier componentIdentifier) throws IllegalArgumentException, ComponentNotManagedException, InvalidDataException {
        final Widget comp = (Widget)findBP.findComponent(componentIdentifier, ComponentHandler.getAutHierarchy());
        if (comp != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    Shell shell = SwtUtils.getShell(comp);
                    try {
                        Shell activeShell;
                        if (shell != null && shell.isVisible() && (activeShell = shell.getDisplay().getActiveShell()) != shell && !SwtUtils.isDropdownListShell(activeShell)) {
                            shell.setActive();
                        }
                    }
                    catch (SWTException sWTException) {}
                }
            });
            return comp;
        }
        throw new ComponentNotManagedException("unmanaged component with identifier: '" + componentIdentifier.toString() + "'.", MessageIDs.E_COMPONENT_NOT_MANAGED);
    }

    private List<String> getPathToRoot(Widget component) throws IllegalArgumentException, ComponentNotManagedException {
        if (log.isInfoEnabled()) {
            log.info((Object)("pathToRoot called for " + component));
        }
        Validate.notNull((Object)component, (String)"The component must not be null");
        ArrayList<String> hierarchy = new ArrayList<String>();
        SwtHierarchyContainer autContainer = this.getHierarchyContainer(component);
        if (autContainer != null) {
            hierarchy.add(autContainer.getName());
            SwtHierarchyContainer parent = autContainer.getParent();
            while (parent != null) {
                hierarchy.add(0, parent.getName());
                parent = parent.getParent();
            }
        } else {
            log.error((Object)("component '" + component + "' is not managed by this hierarchy"));
            throw new ComponentNotManagedException("unmanaged component " + component.toString(), MessageIDs.E_COMPONENT_NOT_MANAGED);
        }
        return hierarchy;
    }

    public void refreshShell(Shell shell) {
        if (this.m_shellToListenerMap.containsKey(shell) || this.getRealMap().containsKey(shell)) {
            this.remove(shell);
        }
        this.add(shell);
    }

    public synchronized void refreshComponent(Widget toRefresh) {
        SwtHierarchyContainer currentHierarchyContainer = this.getHierarchyContainer(toRefresh);
        if (currentHierarchyContainer == null) {
            this.componentAdded(toRefresh);
        } else if (toRefresh != currentHierarchyContainer.getComponentID().getRealComponent()) {
            this.componentRemoved(toRefresh);
            this.componentAdded(toRefresh);
        } else {
            SwtHierarchyContainer[] childContainers = currentHierarchyContainer.getComponents();
            int i = 0;
            while (i < childContainers.length) {
                this.removeFromHierarchy(childContainers[i]);
                ++i;
            }
            this.addToHierarchyDown(currentHierarchyContainer, toRefresh);
        }
    }

    public synchronized void refreshComponentName(Widget toRefresh) {
        this.rename(this.getHierarchyContainer(toRefresh));
    }

    private boolean isInstanceofControlAndNotVisible(Widget widget) {
        if (widget instanceof Control) {
            try {
                Control c = (Control)widget;
                return !c.isVisible();
            }
            catch (SWTException sWTException) {}
        }
        return false;
    }

    private boolean isShellVisible(Shell shell) {
        try {
            return shell.isVisible();
        }
        catch (SWTException sWTException) {
            return false;
        }
    }

    public synchronized void componentAdded(Widget toAdd) {
        if (toAdd == null || toAdd.isDisposed()) {
            return;
        }
        if (this.isInstanceofControlAndNotVisible(toAdd)) {
            return;
        }
        if (toAdd instanceof Shell) {
            this.add((Shell)toAdd);
        }
        if (this.getHierarchyContainer(toAdd) != null) {
            return;
        }
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            Widget container = SwtUtils.getWidgetParent(toAdd);
            this.pruneHierarchy(container);
            if (container == null || container.isDisposed()) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("component '" + toAdd + "' added to '" + container + "'"));
            }
            SwtHierarchyContainer hierarchyContainer = null;
            hierarchyContainer = toAdd instanceof Shell ? this.getHierarchyContainer(toAdd) : this.getHierarchyContainer(container);
            if (hierarchyContainer == null) {
                log.info((Object)("component added to unmanaged container '" + container + "'; adding the container."));
                this.componentAdded(container);
                hierarchyContainer = this.getHierarchyContainer(container);
                if (hierarchyContainer == null) {
                    log.info((Object)("addition of container '" + container + "' failed. This may be because the " + "container is not visible."));
                }
            }
            if (hierarchyContainer != null && this.getHierarchyContainer(toAdd) == null) {
                SwtHierarchyContainer hierarchyChild = new SwtHierarchyContainer(new SwtComponent(toAdd));
                this.addToHierachyMap(hierarchyChild);
                hierarchyContainer.add(hierarchyChild);
                toAdd.addDisposeListener((DisposeListener)new ComponentDisposingListener());
                this.name(hierarchyChild);
                this.addToHierarchyDown(hierarchyChild, toAdd);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    private void pruneHierarchy(Widget container) {
        Widget currentWidget = container;
        while (currentWidget != null) {
            this.pruneChildren(currentWidget);
            currentWidget = SwtUtils.getWidgetParent(currentWidget);
        }
    }

    private void pruneChildren(Widget container) {
        SwtHierarchyContainer hierarchyContainer = this.getHierarchyContainer(container);
        if (hierarchyContainer != null) {
            SwtHierarchyContainer[] childContainers = hierarchyContainer.getComponents();
            int i = 0;
            while (i < childContainers.length) {
                Widget child = childContainers[i].getComponentID().getRealComponent();
                if (child.isDisposed() || this.isInstanceofControlAndNotVisible(child)) {
                    this.componentRemoved(child);
                }
                ++i;
            }
        }
    }

    public synchronized void componentRemoved(Widget toRemove) {
        if (toRemove instanceof Shell) {
            this.remove((Shell)toRemove);
            return;
        }
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            Object componentToRemove;
            if (log.isDebugEnabled()) {
                log.debug((Object)("removing component '" + toRemove + "'"));
            }
            if ((componentToRemove = this.getRealMap().get(toRemove)) != null) {
                SwtHierarchyContainer hierarchyContainer = (SwtHierarchyContainer)((Object)this.getHierarchyMap().remove(componentToRemove));
                this.removeFromHierarchy(hierarchyContainer);
            } else {
                log.debug((Object)("an unmanaged component was removed: " + toRemove));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    private void registerAsWindowListener(Shell window) {
        if (log.isInfoEnabled()) {
            log.info((Object)("registering window listener to shell " + window));
        }
        if (this.isListening(window)) {
            return;
        }
        ShellClosingListener listener = new ShellClosingListener();
        this.m_shellToListenerMap.put(window, listener);
        window.addShellListener((ShellListener)listener);
        window.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SwtAUTHierarchy.this.remove((Shell)e.widget);
            }
        });
    }

    private boolean isListening(Shell window) {
        return this.m_shellToListenerMap.containsKey(window);
    }

    private synchronized void addToHierarchyUp(SwtHierarchyContainer hierarchyContainer, Composite container) {
        SwtHierarchyContainer hierarchyParent;
        Composite parent;
        if (log.isInfoEnabled()) {
            log.info((Object)("addToHierarchyUp: " + (Object)((Object)hierarchyContainer) + "," + container));
        }
        if ((parent = container.getParent()) != null && (hierarchyParent = this.getHierarchyContainer((Widget)container)) == null) {
            hierarchyParent = new SwtHierarchyContainer(new SwtComponent((Widget)parent));
            hierarchyParent.add(hierarchyContainer);
            this.name(hierarchyParent);
            this.addToHierachyMap(hierarchyParent);
            this.addToHierarchyUp(hierarchyParent, parent);
        }
    }

    private synchronized void addToHierarchyDown(SwtHierarchyContainer hierarchyContainer, Widget container) {
        Widget hierarchyComponent = hierarchyContainer.getComponentID().getRealComponent();
        if (container == null || container.isDisposed() || hierarchyComponent == null || hierarchyComponent.isDisposed()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("addToHierarchyDown: " + (Object)((Object)hierarchyContainer) + "," + container));
        }
        this.name(hierarchyContainer);
        Collection<Widget> collection = this.getComponents(container);
        for (Widget comp : collection) {
            if (this.getHierarchyContainer(comp) != null) {
                return;
            }
            this.componentAdded(comp);
        }
    }

    private void removeFromHierarchy(SwtHierarchyContainer container) {
        SwtComponent autCompID;
        Widget autComp;
        if (container == null) {
            return;
        }
        SwtHierarchyContainer parentContainer = container.getParent();
        if (parentContainer != null) {
            parentContainer.remove(container);
        }
        if ((autComp = (autCompID = container.getComponentID()).getRealComponent()) == null) {
            log.error((Object)("invalid component for removal:" + autCompID.toString()));
        }
        this.removeFromHierachyMap(container);
        if (!autComp.isDisposed()) {
            Collection<Widget> childs = this.getComponents(autComp);
            Iterator<Widget> iter = childs.iterator();
            while (iter.hasNext()) {
                this.removeFromHierarchy(this.getHierarchyContainer(iter.next()));
            }
        }
    }

    public SwtHierarchyContainer getHierarchyContainer(Widget component) throws IllegalArgumentException {
        Validate.notNull((Object)component, (String)"The component must not be null");
        SwtHierarchyContainer result = null;
        try {
            SwtComponent compID = (SwtComponent)((Object)this.getRealMap().get(component));
            if (compID != null) {
                result = (SwtHierarchyContainer)((Object)this.getHierarchyMap().get((Object)compID));
            }
        }
        catch (ClassCastException cce) {
            log.error((Object)cce);
        }
        catch (NullPointerException npe) {
            log.error((Object)npe);
        }
        return result;
    }

    private synchronized void name(SwtHierarchyContainer hierarchyContainer) {
        if (hierarchyContainer != null) {
            Widget component = hierarchyContainer.getComponentID().getRealComponent();
            SwtHierarchyContainer hierarchyParent = null;
            Widget parent = SwtUtils.getWidgetParent(component);
            if (parent != null && (hierarchyParent = this.getHierarchyContainer(parent)) != null) {
                hierarchyContainer.setParent(hierarchyParent);
            }
            if (StringUtils.isEmpty((String)hierarchyContainer.getName())) {
                this.rename(hierarchyContainer);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void rename(SwtHierarchyContainer hierarchyContainer) {
        block5: {
            block6: {
                if (hierarchyContainer == null) break block5;
                component = hierarchyContainer.getComponentID().getRealComponent();
                compName = FindSWTComponentBP.getComponentName(component);
                hierarchyParent = hierarchyContainer.getParent();
                count = 1;
                originalName = null;
                newName = null;
                rcpCompId = component.getData("TEST_RCP_COMP_NAME");
                newNameGenerated = false;
                if (compName != null) {
                    newName = compName.toString();
                    originalName = compName.toString();
                } else if (rcpCompId != null) {
                    newName = rcpCompId.toString();
                    originalName = rcpCompId.toString();
                }
                if (newName != null) ** GOTO lbl26
                newNameGenerated = true;
                while (!this.isUniqueName(hierarchyParent, component, newName)) {
                    newName = this.createName(component, count);
                    ++count;
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    newName = this.createName(originalName, count);
                    ++count;
lbl26:
                    // 2 sources

                    ** while (!this.isUniqueName((SwtHierarchyContainer)hierarchyParent, (Widget)component, (String)newName))
                }
            }
            hierarchyContainer.setName(newName, newNameGenerated);
        }
    }

    private boolean isUniqueName(SwtHierarchyContainer parent, Widget widget, String name) {
        if (name == null) {
            return false;
        }
        if (parent == null) {
            return true;
        }
        SwtHierarchyContainer[] compIDs = parent.getComponents();
        int length = compIDs.length;
        int index = 0;
        while (index < length) {
            Widget childWidget = compIDs[index].getComponentID().getRealComponent();
            if (childWidget != null && !childWidget.isDisposed()) {
                String childWidgetName = FindSWTComponentBP.getComponentName(childWidget);
                if (childWidget != widget && name.equals(childWidgetName)) {
                    return false;
                }
            }
            ++index;
        }
        index = 0;
        while (index < length) {
            if (name.equals(compIDs[index].getName())) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private Collection<Widget> getComponents(Widget component) {
        LinkedList<Widget> children = new LinkedList<Widget>();
        if (component instanceof Composite) {
            Composite cont = (Composite)component;
            children.addAll(Arrays.asList(cont.getChildren()));
        }
        children.addAll(Arrays.asList(SwtUtils.getMappableItems(component)));
        return children;
    }

    private class ComponentDisposingListener
    implements DisposeListener {
        private ComponentDisposingListener() {
        }

        public void widgetDisposed(DisposeEvent event) {
            SwtAUTHierarchy.this.componentRemoved(event.widget);
        }
    }

    private class ShellClosingListener
    extends ShellAdapter {
        private ShellClosingListener() {
        }

        public void shellClosed(ShellEvent event) {
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(AUTServer.getInstance().getClass().getClassLoader());
            try {
                Shell window = (Shell)event.widget;
                SwtAUTHierarchy.this.remove(window);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        }

        public void shellDeactivated(ShellEvent e) {
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(AUTServer.getInstance().getClass().getClassLoader());
            try {
                Shell window = (Shell)e.widget;
                if (!SwtAUTHierarchy.this.isShellVisible(window)) {
                    SwtAUTHierarchy.this.remove(window);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        }

        public void shellActivated(ShellEvent e) {
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(AUTServer.getInstance().getClass().getClassLoader());
            try {
                Shell window = (Shell)e.widget;
                if (SwtAUTHierarchy.this.isShellVisible(window) && SwtAUTHierarchy.this.getHierarchyContainer((Widget)window) == null) {
                    SwtAUTHierarchy.this.add(window);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        }
    }
}

