/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.driver;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.swt.SWT;

public class KeyCodeConverter {
    private static Map<String, Integer> converterTable = null;

    static {
        converterTable = new HashMap<String, Integer>();
        converterTable.put(ValueSets.Modifier.none.rcValue(), new Integer(-1));
        converterTable.put(ValueSets.Modifier.shift.rcValue(), new Integer(131072));
        converterTable.put(ValueSets.Modifier.control.rcValue(), new Integer(262144));
        converterTable.put(ValueSets.Modifier.alt.rcValue(), new Integer(65536));
        converterTable.put(ValueSets.Modifier.meta.rcValue(), new Integer(0x400000));
        converterTable.put(ValueSets.Modifier.cmd.rcValue(), new Integer(0x400000));
        converterTable.put(ValueSets.Modifier.mod.rcValue(), new Integer(SWT.MOD1));
    }

    private KeyCodeConverter() {
    }

    public static int getKeyCode(String key) {
        if (key == null) {
            throw new RobotException("Key is null!", EventFactory.createConfigErrorEvent());
        }
        Integer keyCode = converterTable.get(key.toLowerCase());
        if (keyCode == null) {
            throw new RobotException("No KeyCode found for key '" + key + "'", EventFactory.createConfigErrorEvent());
        }
        return keyCode;
    }
}

