/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.tree;

import java.awt.Rectangle;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.swt.tester.CAPUtil;
import org.eclipse.jubula.rc.swt.tester.tree.TreeOperationContext;
import org.eclipse.jubula.rc.swt.utils.SwtPointUtil;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TableTreeOperationContext
extends TreeOperationContext {
    private int m_column;

    public TableTreeOperationContext(IEventThreadQueuer queuer, IRobot robot, Tree tree, int column) {
        super(queuer, robot, tree);
        this.m_column = column;
    }

    public TableTreeOperationContext(IEventThreadQueuer queuer, IRobot robot, Tree tree) {
        this(queuer, robot, tree, 0);
    }

    public void clickNode(final TreeItem node, ClickOptions clickOps) {
        this.scrollNodeToVisible(node);
        org.eclipse.swt.graphics.Rectangle visibleItemBounds = (org.eclipse.swt.graphics.Rectangle)this.getQueuer().invokeAndWait("getVisibleNodeBounds " + node, new IRunnable(){

            public Object run() {
                Rectangle nodeBounds = SwtPointUtil.toAwtRectangle(SwtUtils.getRelativeBounds(node, TableTreeOperationContext.this.m_column));
                return SwtPointUtil.toSwtRectangle(TableTreeOperationContext.this.getVisibleRowBounds(nodeBounds));
            }
        });
        this.getRobot().click(this.getTree(), (Object)visibleItemBounds, clickOps.setScrollToVisible(false));
    }

    public String getNodeTextAtColumn(final TreeItem node) {
        int userIndex = IndexConverter.toUserIndex((int)this.m_column);
        String nodeText = (String)this.getQueuer().invokeAndWait("getNodeText: " + node + " at column: " + userIndex, new IRunnable(){

            public Object run() {
                return CAPUtil.getWidgetText((Widget)node, "TEST_TESTABLE_TEXT_" + TableTreeOperationContext.this.m_column, node.getText(TableTreeOperationContext.this.m_column));
            }
        });
        return nodeText;
    }

    public String getRenderedText(TreeItem node) throws StepExecutionException {
        return this.getNodeTextAtColumn(node);
    }

    public void scrollNodeToVisible(TreeItem node) {
        super.scrollNodeToVisible(node);
        this.getQueuer().invokeAndWait("showColumn: " + node, new IRunnable(){

            public Object run() {
                ((Tree)TableTreeOperationContext.this.getTree()).showColumn(((Tree)TableTreeOperationContext.this.getTree()).getColumn(TableTreeOperationContext.this.m_column));
                return null;
            }
        });
        final Rectangle nodeBoundsRelativeToParent = this.getNodeBounds(node);
        final Tree tree = (Tree)this.getTree();
        this.getQueuer().invokeAndWait("getNodeBoundsRelativeToParent", new IRunnable(){

            public Object run() {
                Point cellOriginRelativeToParent = tree.getDisplay().map((Control)tree, (Control)tree.getParent(), new Point(nodeBoundsRelativeToParent.x, nodeBoundsRelativeToParent.y));
                nodeBoundsRelativeToParent.x = cellOriginRelativeToParent.x;
                nodeBoundsRelativeToParent.y = cellOriginRelativeToParent.y;
                return null;
            }
        });
        Control parent = (Control)this.getQueuer().invokeAndWait("getParent", new IRunnable(){

            public Object run() {
                tree.getParent();
                return null;
            }
        });
        this.getRobot().scrollToVisible((Object)parent, (Object)SwtPointUtil.toSwtRectangle(nodeBoundsRelativeToParent));
    }

    public Rectangle getNodeBounds(final TreeItem node) {
        org.eclipse.swt.graphics.Rectangle r = (org.eclipse.swt.graphics.Rectangle)this.getQueuer().invokeAndWait("getNodeBounds: " + node, new IRunnable(){

            public Object run() {
                Tree tree = (Tree)TableTreeOperationContext.this.getTree();
                org.eclipse.swt.graphics.Rectangle bounds = SwtUtils.getBounds(node, TableTreeOperationContext.this.m_column);
                Point relativeLocation = tree.toControl(bounds.x, bounds.y);
                bounds.x = relativeLocation.x;
                bounds.y = relativeLocation.y;
                return bounds;
            }
        });
        Rectangle nodeBounds = new Rectangle(r.x, r.y, r.width, r.height);
        return nodeBounds;
    }
}

