/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.tree;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.SelectionUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.rc.swt.tester.CAPUtil;
import org.eclipse.jubula.rc.swt.utils.SwtPointUtil;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeOperationContext
extends AbstractTreeOperationContext<Tree, TreeItem> {
    private static AutServerLogger log = new AutServerLogger(TreeOperationContext.class);

    public TreeOperationContext(IEventThreadQueuer queuer, IRobot robot, Tree tree) {
        super(queuer, robot, (Object)tree);
    }

    protected String convertValueToText(TreeItem node, int row) throws StepExecutionException {
        return this.getRenderedText(node);
    }

    public String getRenderedText(final TreeItem node) throws StepExecutionException {
        return (String)this.getQueuer().invokeAndWait("getText", new IRunnable(){

            public Object run() {
                return CAPUtil.getWidgetText((Widget)node, node.getText());
            }
        });
    }

    public boolean isVisible(final TreeItem node) {
        Boolean visible = (Boolean)this.getQueuer().invokeAndWait("isVisible", new IRunnable(){

            public Object run() {
                TreeItem item = node;
                boolean vis = true;
                while (item != null && item.getParentItem() != null) {
                    vis = item.getParentItem().getExpanded();
                    item = item.getParentItem();
                }
                return vis ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return visible;
    }

    public Rectangle getVisibleRowBounds(Rectangle rowBounds) {
        org.eclipse.swt.graphics.Rectangle r = (org.eclipse.swt.graphics.Rectangle)this.getQueuer().invokeAndWait("getVisibleRowBounds: " + rowBounds, new IRunnable(){

            public Object run() {
                Tree tree = (Tree)TreeOperationContext.this.getTree();
                org.eclipse.swt.graphics.Rectangle visibleBounds = tree.getClientArea();
                return visibleBounds;
            }
        });
        Rectangle visibleTreeBounds = new Rectangle(r.x, r.y, r.width, r.height);
        Rectangle visibleRowBounds = visibleTreeBounds.intersection(rowBounds);
        return visibleRowBounds;
    }

    public void collapseNode(final TreeItem node) {
        final Tree tree = (Tree)this.getTree();
        boolean doAction = this.isExpanded(node);
        if (doAction) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Collapsing node: " + node));
            }
            this.getQueuer().invokeAndWait("collapse", new IRunnable(){

                public Object run() throws StepExecutionException {
                    Event collapseEvent = new Event();
                    collapseEvent.time = (int)System.currentTimeMillis();
                    collapseEvent.type = 18;
                    collapseEvent.widget = tree;
                    collapseEvent.item = node;
                    tree.notifyListeners(18, collapseEvent);
                    node.setExpanded(false);
                    tree.update();
                    return null;
                }
            });
        }
    }

    public void expandNode(final TreeItem node) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            final Tree tree = (Tree)this.getTree();
            boolean doAction = !this.isExpanded(node);
            Thread.currentThread().setContextClassLoader(tree.getClass().getClassLoader());
            this.getQueuer().invokeAndWait("Scroll Tree item: " + node + " to visible", new IRunnable(){

                public Object run() {
                    tree.showItem(node);
                    return null;
                }
            });
            Rectangle nodeBounds = this.getNodeBounds(node);
            Rectangle visibleNodeBounds = this.getVisibleRowBounds(nodeBounds);
            org.eclipse.swt.graphics.Rectangle swtVisibleNodeBounds = new org.eclipse.swt.graphics.Rectangle(visibleNodeBounds.x, visibleNodeBounds.y, visibleNodeBounds.width, visibleNodeBounds.height);
            this.getRobot().move((Object)tree, (Object)swtVisibleNodeBounds);
            if (doAction) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Expanding node: " + node));
                    log.debug((Object)("Node bounds   : " + visibleNodeBounds));
                }
                this.getQueuer().invokeAndWait("expand", new IRunnable(){

                    public Object run() throws StepExecutionException {
                        Event expandEvent = new Event();
                        expandEvent.time = (int)System.currentTimeMillis();
                        expandEvent.type = 17;
                        expandEvent.widget = tree;
                        expandEvent.item = node;
                        tree.notifyListeners(17, expandEvent);
                        node.setExpanded(true);
                        tree.update();
                        return null;
                    }
                });
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public TreeItem[] getRootNodes() {
        return (TreeItem[])this.getQueuer().invokeAndWait("getRootNode", new IRunnable(){

            public Object run() {
                return ((Tree)TreeOperationContext.this.getTree()).getItems();
            }
        });
    }

    public boolean isExpanded(final TreeItem node) {
        return (Boolean)this.getQueuer().invokeAndWait("isExpanded: " + node, new IRunnable(){

            public Object run() {
                return node.getExpanded() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public void clickNode(final TreeItem node, ClickOptions clickOps) {
        this.scrollNodeToVisible(node);
        SwtUtils.waitForDisplayIdle(node.getDisplay());
        org.eclipse.swt.graphics.Rectangle visibleRowBounds = (org.eclipse.swt.graphics.Rectangle)this.getQueuer().invokeAndWait("getVisibleNodeBounds " + node, new IRunnable(){

            public Object run() {
                Rectangle nodeBounds = TreeOperationContext.this.getNodeBounds(node);
                return SwtPointUtil.toSwtRectangle(TreeOperationContext.this.getVisibleRowBounds(nodeBounds));
            }
        });
        this.getRobot().click(this.getTree(), (Object)visibleRowBounds, clickOps.setScrollToVisible(false));
    }

    public void toggleNodeCheckbox(final TreeItem node) {
        this.scrollNodeToVisible(node);
        this.getQueuer().invokeAndWait("selectNodeCheckbox", new IRunnable(){

            public Object run() {
                Tree tree = (Tree)TreeOperationContext.this.getTree();
                boolean toggledValue = !node.getChecked();
                node.setChecked(toggledValue);
                Event toggleEvent = new Event();
                toggleEvent.type = 13;
                toggleEvent.detail = 32;
                toggleEvent.widget = tree;
                toggleEvent.item = node;
                toggleEvent.button = 524288;
                toggleEvent.count = 1;
                toggleEvent.display = node.getDisplay();
                tree.notifyListeners(13, toggleEvent);
                return null;
            }
        });
    }

    public void verifyCheckboxSelection(final TreeItem node, boolean checked) {
        this.scrollNodeToVisible(node);
        Boolean checkSelected = (Boolean)this.getQueuer().invokeAndWait("verifyCheckboxSelection", new IRunnable(){

            public Object run() {
                return new Boolean(node.getChecked());
            }
        });
        Verifier.equals((boolean)checked, (boolean)checkSelected);
    }

    public void scrollNodeToVisible(final TreeItem node) {
        this.getQueuer().invokeAndWait("showItem: " + node, new IRunnable(){

            public Object run() {
                ((Tree)TreeOperationContext.this.getTree()).showItem(node);
                return null;
            }
        });
        final Rectangle nodeBoundsRelativeToParent = this.getNodeBounds(node);
        final Tree tree = (Tree)this.getTree();
        this.getQueuer().invokeAndWait("getNodeBoundsRelativeToParent", new IRunnable(){

            public Object run() {
                Point cellOriginRelativeToParent = tree.getDisplay().map((Control)tree, (Control)tree.getParent(), new Point(nodeBoundsRelativeToParent.x, nodeBoundsRelativeToParent.y));
                nodeBoundsRelativeToParent.x = cellOriginRelativeToParent.x;
                nodeBoundsRelativeToParent.y = cellOriginRelativeToParent.y;
                return null;
            }
        });
        Control parent = (Control)this.getQueuer().invokeAndWait("getParent", new IRunnable(){

            public Object run() {
                tree.getParent();
                return null;
            }
        });
        this.getRobot().scrollToVisible((Object)parent, (Object)SwtPointUtil.toSwtRectangle(nodeBoundsRelativeToParent));
    }

    public TreeItem getChild(final TreeItem parent, final int index) {
        if (parent == null) {
            TreeItem[] rootNodes = this.getRootNodes();
            if (index < 0 || index >= rootNodes.length) {
                return null;
            }
            return rootNodes[index];
        }
        return (TreeItem)this.getQueuer().invokeAndWait("getChild: " + parent + "; With index: " + index, new IRunnable(){

            public Object run() {
                try {
                    return parent.getItem(index);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
        });
    }

    public TreeItem getParent(final TreeItem child) {
        return (TreeItem)this.getQueuer().invokeAndWait("getParent: " + child, new IRunnable(){

            public Object run() {
                return child.getParentItem();
            }
        });
    }

    public TreeItem getSelectedNode() {
        return this.getSelectedNodes()[0];
    }

    public TreeItem[] getSelectedNodes() {
        return (TreeItem[])this.getQueuer().invokeAndWait("getSelectedNodes", new IRunnable(){

            public Object run() {
                Object[] selectedItems = ((Tree)TreeOperationContext.this.getTree()).getSelection();
                SelectionUtil.validateSelection((Object[])selectedItems);
                return selectedItems;
            }
        });
    }

    public TreeItem[] getChildren(final TreeItem parent) {
        if (parent == null) {
            return this.getRootNodes();
        }
        return (TreeItem[])this.getQueuer().invokeAndWait("getChildren: " + parent, new IRunnable(){

            public Object run() {
                return parent.getItems();
            }
        });
    }

    public int getNumberOfChildren(final TreeItem parent) {
        if (parent == null) {
            return this.getRootNodes().length;
        }
        return (Integer)this.getQueuer().invokeAndWait("getChildren: " + parent, new IRunnable(){

            public Object run() {
                return new Integer(parent.getItemCount());
            }
        });
    }

    public Collection<String> getNodeTextList(final TreeItem node) {
        final ArrayList<String> res = new ArrayList<String>();
        this.getQueuer().invokeAndWait("getNodeText: " + node, new IRunnable(){

            public Object run() {
                int colCount = ((Tree)TreeOperationContext.this.getTree()).getColumnCount();
                int i = 0;
                while (i < colCount) {
                    String textAtColumn = CAPUtil.getWidgetText((Widget)node, "TEST_TESTABLE_TEXT_" + i, node.getText(i));
                    if (textAtColumn != null) {
                        res.add(textAtColumn);
                    }
                    ++i;
                }
                String text = CAPUtil.getWidgetText((Widget)node, node.getText());
                if (text != null) {
                    res.add(text);
                }
                return null;
            }
        });
        return res;
    }

    public Rectangle getNodeBounds(final TreeItem node) {
        org.eclipse.swt.graphics.Rectangle r = (org.eclipse.swt.graphics.Rectangle)this.getQueuer().invokeAndWait("getNodeBounds: " + node, new IRunnable(){

            public Object run() {
                Tree tree = (Tree)TreeOperationContext.this.getTree();
                org.eclipse.swt.graphics.Rectangle bounds = SwtUtils.getRelativeWidgetBounds((Widget)node, (Control)tree);
                return bounds;
            }
        });
        Rectangle nodeBounds = new Rectangle(r.x, r.y, r.width, r.height);
        return nodeBounds;
    }

    public int getIndexOfChild(final TreeItem parent, final TreeItem child) {
        if (parent != null) {
            return (Integer)this.getQueuer().invokeAndWait("getIndexOfChild", new IRunnable(){

                public Object run() throws StepExecutionException {
                    return new Integer(parent.indexOf(child));
                }
            });
        }
        TreeItem[] rootNodes = this.getRootNodes();
        int i = 0;
        while (i < rootNodes.length) {
            if (rootNodes[i] == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isLeaf(TreeItem node) {
        return this.getNumberOfChildren(node) == 0;
    }
}

