/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the TextInputComponent component from the concrete toolkit.
 */
@RealizedType(realizedType="guidancer.abstract.TextInputSupport")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2015-02-02T11:04:29.131Z")
public class TextInputComponent extends org.eclipse.jubula.toolkit.base.internal.impl.TextInputComponent implements org.eclipse.jubula.toolkit.concrete.components.TextInputComponent {
            public TextInputComponent(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param index 
         *        the index
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP insertTextAfterIndex(
            @NonNull String text,
            @NonNull Integer index
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcInsertText"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(index), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param pattern 
         *        the pattern to use
         * @param operator 
         *        the operator used for comparison
         * @param insertAfterPattern 
         *        insert after pattern
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP insertTextBeforeAfterPattern(
            @NonNull String text,
            @NonNull String pattern,
            @NonNull Operator operator,
            @NonNull Boolean insertAfterPattern
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcInsertText"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(pattern, "Argument 'pattern' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(pattern), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(insertAfterPattern, "Argument 'insertAfterPattern' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(insertAfterPattern), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        @NonNull public CAP selectAll(
        )  {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcSelect"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            return messageCap;
        }
        
        /**
         * 
         * @param pattern 
         *        the pattern to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectPattern(
            @NonNull String pattern,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcSelect"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(pattern, "Argument 'pattern' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(pattern), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
} 