/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.gef;

import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.gef.internal.GefToolkitInfo;

/**
 * Factory for creating components from the gef toolkit.
 * @noextend This class is not intended to be extended by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.FactoryGenerator", 
           date =  "2015-02-02T11:04:28.904Z")
public final class GefComponents {
    
    @NonNull private final static ToolkitInfo m_toolkitInformation = new GefToolkitInfo();

    private GefComponents() {
        super();
    }
    
    @NonNull public static ToolkitInfo getToolkitInformation() {
        return m_toolkitInformation;
    }

    /** create a new representative for a {@link org.eclipse.draw2d.FigureCanvas} UI component.*/
    @NonNull public static org.eclipse.jubula.toolkit.gef.components.FigureCanvas createFigureCanvas (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.gef.components.FigureCanvas> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.gef.internal.impl.FigureCanvas(componentIdentifier);
    }
}