/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.autrun;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.app.autrun.i18n.Messages;
import org.eclipse.jubula.autagent.commands.IStartAut;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.IsAliveThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutRunner {
    private static final String RESPONSE_OK = "Response.OK";
    private static final String AGENT_CONNECTION_THREAD_NAME = "AUT Agent Connection";
    private static final Logger LOG = LoggerFactory.getLogger(AutRunner.class);
    private Map<String, String> m_autConfiguration;
    private IStartAut m_startAut;
    private InetSocketAddress m_agentAddr;

    public AutRunner(String autToolkit, AutIdentifier autIdentifier, InetSocketAddress agentAddr, Map<String, String> autConfiguration) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String className = "org.eclipse.jubula.autagent.commands.Start" + autToolkit + "AutServerCommand";
        Class<?> autServerClass = Class.forName(className);
        this.m_agentAddr = agentAddr;
        this.m_autConfiguration = new HashMap<String, String>(autConfiguration);
        this.m_autConfiguration.put("com.bredexsw.guidancer.aut.register.autAgentHost", agentAddr.getHostName());
        this.m_autConfiguration.put("com.bredexsw.guidancer.aut.register.autAgentPort", String.valueOf(agentAddr.getPort()));
        this.m_autConfiguration.put("com.bredexsw.guidancer.aut.register.autName", autIdentifier.getExecutableName());
        this.m_startAut = (IStartAut)autServerClass.newInstance();
    }

    public void run() throws IOException, ConnectException {
        if (this.m_agentAddr.getAddress() == null) {
            LOG.error(Messages.errorAutAgentHost);
            throw new ConnectException(Messages.errorAutAgentHost);
        }
        Socket agentSocket = new Socket(this.m_agentAddr.getAddress(), this.m_agentAddr.getPort());
        PrintWriter writer = new PrintWriter(agentSocket.getOutputStream(), true);
        BufferedReader reader = new BufferedReader(new InputStreamReader(agentSocket.getInputStream()));
        reader.readLine();
        writer.println("ClientType.autrun");
        writer.println(this.m_autConfiguration.get("com.bredexsw.guidancer.aut.register.autName"));
        AgentConnectionWatcher agentConnectionThread = new AgentConnectionWatcher(AGENT_CONNECTION_THREAD_NAME, writer, agentSocket, reader);
        agentConnectionThread.setDaemon(true);
        agentConnectionThread.start();
        this.m_startAut.startAut(this.m_autConfiguration);
    }

    private final class AgentConnectionWatcher
    extends Thread {
        private final PrintWriter m_writer;
        private final Socket m_agentSocket;
        private final BufferedReader m_reader;

        private AgentConnectionWatcher(String name, PrintWriter writer, Socket agentSocket, BufferedReader reader) {
            super(name);
            this.m_writer = writer;
            this.m_agentSocket = agentSocket;
            this.m_reader = reader;
        }

        @Override
        public void run() {
            try {
                String line = this.m_reader.readLine();
                if (line != null && line.equals("Req.PrepareForRestart")) {
                    IsAliveThread restartThread = new IsAliveThread(){

                        public void run() {
                            block12: {
                                AgentConnectionWatcher.this.m_writer.println(AutRunner.RESPONSE_OK);
                                try {
                                    try {
                                        String restartReq = AgentConnectionWatcher.this.m_reader.readLine();
                                        if ("Req.Restart".equals(restartReq)) {
                                            AutRunner.this.run();
                                        }
                                    }
                                    catch (IOException e) {
                                        LOG.error(Messages.restartAutFailed, (Throwable)e);
                                        try {
                                            AgentConnectionWatcher.this.m_agentSocket.close();
                                        }
                                        catch (IOException iOException) {}
                                        break block12;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        AgentConnectionWatcher.this.m_agentSocket.close();
                                    }
                                    catch (IOException iOException) {}
                                    throw throwable;
                                }
                                try {
                                    AgentConnectionWatcher.this.m_agentSocket.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    };
                    restartThread.setDaemon(false);
                    restartThread.start();
                }
            }
            catch (IOException e) {
                LOG.error(Messages.restartAutFailed, (Throwable)e);
            }
        }
    }
}

