/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.core.utils;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.alm.mylyn.core.Activator;
import org.eclipse.jubula.client.alm.mylyn.core.bp.CommentReporter;
import org.eclipse.jubula.client.alm.mylyn.core.exceptions.InvalidALMAttributeException;
import org.eclipse.jubula.client.alm.mylyn.core.i18n.Messages;
import org.eclipse.jubula.client.alm.mylyn.core.model.ALMChange;
import org.eclipse.jubula.client.alm.mylyn.core.model.CommentEntry;
import org.eclipse.jubula.client.alm.mylyn.core.model.FieldUpdate;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.SimpleStringConverter;
import org.eclipse.jubula.client.core.utils.VariableToken;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.ITaskDataManager;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ALMAccess {
    private static final Logger LOG = LoggerFactory.getLogger(ALMAccess.class);
    private static final String VARIABLE_DATE_POSTFIX = "date";
    private static final String VARIABLE_URL_POSTFIX = "url";
    private static final String VARIABLE_SUMMARY_PREFIX = "summary";
    private static final String VARIABLE_NODE_PREFIX = "node";

    private ALMAccess() {
    }

    public static TaskRepository getRepositoryByLabel(String repoLabel) {
        List<TaskRepository> allRepositories = ALMAccess.getAllRepositories();
        for (TaskRepository repo : allRepositories) {
            if (!repo.getRepositoryLabel().equals(repoLabel)) continue;
            return repo;
        }
        return null;
    }

    public static List<TaskRepository> getAllRepositories() {
        IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
        return repositoryManager.getAllRepositories();
    }

    private static ITask getTaskByID(TaskRepository repo, String taskId, IProgressMonitor monitor) throws CoreException {
        IRepositoryModel repositoryModel;
        ITask task = null;
        if (ALMAccess.validRepository(repo) && (task = (repositoryModel = TasksUi.getRepositoryModel()).getTask(repo, taskId)) == null) {
            task = repositoryModel.createTask(repo, taskId);
        }
        return task;
    }

    private static boolean validRepository(TaskRepository repo) {
        return repo != null && !repo.isOffline();
    }

    public static boolean createComment(String repoLabel, String taskId, List<CommentEntry> comments, IProgressMonitor monitor) {
        boolean succeeded = false;
        TaskRepository repo = ALMAccess.getRepositoryByLabel(repoLabel);
        try {
            TaskData taskData = ALMAccess.getTaskDataByID(repo, taskId, monitor);
            if (taskData == null) {
                return succeeded;
            }
            ITask task = ALMAccess.getTaskByID(repo, taskData.getTaskId(), monitor);
            if (task != null) {
                ITaskDataManager taskDataManager = TasksUi.getTaskDataManager();
                ITaskDataWorkingCopy taskWorkingCopy = taskDataManager.createWorkingCopy(task, taskData);
                TaskDataModel taskModel = new TaskDataModel(repo, task, taskWorkingCopy);
                String connectorKind = repo.getConnectorKind();
                AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)connectorKind);
                AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
                TaskAttribute rootData = taskModel.getTaskData().getRoot();
                CONNECTOR handle = ALMAccess.determineConnectorHandling(connectorKind);
                TaskAttribute change = null;
                switch (handle) {
                    case HP_ALM: {
                        change = ALMAccess.hpAlmCommentHandling(comments, rootData);
                        break;
                    }
                    default: {
                        change = ALMAccess.defaultCommentHandling(comments, rootData);
                    }
                }
                if (change == null) {
                    return succeeded;
                }
                taskModel.attributeChanged(change);
                RepositoryResponse response = taskDataHandler.postTaskData(taskModel.getTaskRepository(), taskModel.getTaskData(), taskModel.getChangedOldAttributes(), monitor);
                succeeded = RepositoryResponse.ResponseKind.TASK_UPDATED.equals((Object)response.getReposonseKind());
            }
        }
        catch (CoreException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return succeeded;
    }

    public static IStatus updateFields(String repoLabel, String taskId, List<FieldUpdate> fieldUpdates, IProgressMonitor monitor) {
        Status status = new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", "Unknown error.");
        TaskRepository repo = ALMAccess.getRepositoryByLabel(repoLabel);
        try {
            TaskData taskData = ALMAccess.getTaskDataByID(repo, taskId, monitor);
            if (taskData == null) {
                return status;
            }
            ITask task = ALMAccess.getTaskByID(repo, taskData.getTaskId(), monitor);
            if (task != null) {
                ITaskDataManager taskDataManager = TasksUi.getTaskDataManager();
                ITaskDataWorkingCopy taskWorkingCopy = taskDataManager.createWorkingCopy(task, taskData);
                TaskDataModel taskModel = new TaskDataModel(repo, task, taskWorkingCopy);
                String connectorKind = repo.getConnectorKind();
                AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)connectorKind);
                AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
                TaskAttribute rootData = taskModel.getTaskData().getRoot();
                CONNECTOR handle = ALMAccess.determineConnectorHandling(connectorKind);
                List<TaskAttribute> changes = null;
                switch (handle) {
                    default: 
                }
                changes = ALMAccess.defaultFieldUpdateHandling(fieldUpdates, rootData);
                if (changes.isEmpty()) {
                    return status;
                }
                for (TaskAttribute change : changes) {
                    taskModel.attributeChanged(change);
                }
                RepositoryResponse response = taskDataHandler.postTaskData(taskModel.getTaskRepository(), taskModel.getTaskData(), taskModel.getChangedOldAttributes(), monitor);
                status = RepositoryResponse.ResponseKind.TASK_UPDATED.equals((Object)response.getReposonseKind()) ? new Status(0, "org.eclipse.jubula.client.alm.mylyn.core", "Task has been updated.") : new Status(2, "org.eclipse.jubula.client.alm.mylyn.core", "Task has not been updated successfully.");
            }
        }
        catch (InvalidALMAttributeException e) {
            status = new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", e.getMessage());
        }
        catch (CouldNotResolveException couldNotResolveException) {
            status = new Status(8, "org.eclipse.jubula.client.alm.mylyn.core", "Could not resolve variable");
        }
        catch (CoreException e) {
            status = new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", e.getLocalizedMessage());
        }
        catch (IllegalArgumentException e) {
            LOG.error("IllegalArgumentException occured", (Throwable)e);
            status = new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", e.getLocalizedMessage(), (Throwable)e);
        }
        return status;
    }

    private static List<TaskAttribute> defaultFieldUpdateHandling(List<FieldUpdate> fieldUpdates, TaskAttribute rootAttr) throws InvalidALMAttributeException, CouldNotResolveException {
        ArrayList<TaskAttribute> changes = new ArrayList<TaskAttribute>();
        boolean failed = false;
        for (FieldUpdate u : fieldUpdates) {
            Map<String, Object> attributesToChange = u.getAttributesToChange();
            for (String key : attributesToChange.keySet()) {
                if (StringUtils.isBlank((String)key)) {
                    throw new InvalidALMAttributeException(NLS.bind((String)Messages.InvalidAttributeID, (Object)""));
                }
                TaskAttribute fieldUpdate = rootAttr.getAttribute(key);
                if (fieldUpdate == null) {
                    throw new InvalidALMAttributeException(NLS.bind((String)Messages.InvalidAttributeID, (Object)key));
                }
                if (fieldUpdate.getMetaData().isReadOnly()) {
                    throw new InvalidALMAttributeException(NLS.bind((String)Messages.ReadOnlyAttributeID, (Object)key));
                }
                Object value = attributesToChange.get(key);
                if (value instanceof String) {
                    try {
                        value = ALMAccess.getVariableValues((String)value, u);
                    }
                    catch (CouldNotResolveException couldNotResolveException) {
                        failed = true;
                    }
                    Map options = fieldUpdate.getOptions();
                    if (options != null && !options.isEmpty() && !options.containsKey(value)) {
                        throw new InvalidALMAttributeException(NLS.bind((String)Messages.InvalidValue, (Object)value, (Object)key));
                    }
                    fieldUpdate.setValue((String)value);
                } else {
                    fieldUpdate.setValue(value.toString());
                }
                changes.add(fieldUpdate);
            }
        }
        if (failed) {
            throw new CouldNotResolveException();
        }
        return changes;
    }

    private static String getVariableValues(String value, FieldUpdate fieldUpdate) throws CouldNotResolveException {
        boolean isFailing = false;
        if (StringUtils.isNotBlank((String)value)) {
            SimpleStringConverter converter = new SimpleStringConverter(value);
            if (converter.containsErrors()) {
                CommentReporter.getInstance().getConsole().writeErrorLine(NLS.bind((String)Messages.ParsingReportingRuledFailed, (Object)value));
                throw new CouldNotResolveException(NLS.bind((String)Messages.ParsingReportingRuledFailed, (Object)value));
            }
            List liste = converter.getTokens();
            String result = "";
            for (IParamValueToken iParamValueToken : liste) {
                if (iParamValueToken instanceof VariableToken) {
                    try {
                        result = String.valueOf(result) + ALMAccess.getBeanString(fieldUpdate, (VariableToken)iParamValueToken);
                    }
                    catch (CouldNotResolveException couldNotResolveException) {
                        isFailing = true;
                    }
                    continue;
                }
                result = String.valueOf(result) + iParamValueToken.getGuiString();
            }
            if (isFailing) {
                throw new CouldNotResolveException();
            }
            return result;
        }
        return value;
    }

    private static TaskData getTaskDataByID(TaskRepository repo, String taskId, IProgressMonitor monitor) throws CoreException {
        TaskData taskData = null;
        if (ALMAccess.validRepository(repo)) {
            AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)repo.getConnectorKind());
            taskData = connector.getTaskData(repo, taskId, monitor);
        }
        return taskData;
    }

    private static TaskAttribute hpAlmCommentHandling(List<CommentEntry> comments, TaskAttribute attr) {
        Properties almProps = Activator.getDefault().getAlmAccessProperties();
        String hpTaskKindKeyPrefix = String.valueOf(CONNECTOR.HP_ALM.toString()) + "." + "task.common.kind";
        String req = String.valueOf(hpTaskKindKeyPrefix) + ".REQUIREMENT";
        String hpTaskKindReq = almProps.getProperty(req);
        String def = String.valueOf(hpTaskKindKeyPrefix) + ".DEFECT";
        String hpTaskKindDefect = almProps.getProperty(def);
        String taskKindValue = attr.getMappedAttribute("task.common.kind").getValue();
        String attrName = null;
        if (hpTaskKindReq.equals(taskKindValue)) {
            attrName = almProps.getProperty(String.valueOf(req) + ".comment");
        } else if (hpTaskKindDefect.equals(taskKindValue)) {
            attrName = almProps.getProperty(String.valueOf(def) + ".comment");
        }
        if (attrName != null) {
            TaskAttribute commentAttribute = attr.getMappedAttribute(attrName);
            String oldComment = commentAttribute.getValue();
            String newComment = "";
            for (ALMChange aLMChange : comments) {
                newComment = String.valueOf(aLMChange.toString()) + "<br>" + aLMChange.getDashboardURL() + "<br>" + newComment;
            }
            commentAttribute.setValue(String.valueOf(newComment) + oldComment);
            return commentAttribute;
        }
        return null;
    }

    private static TaskAttribute defaultCommentHandling(List<CommentEntry> comments, TaskAttribute attr) {
        TaskAttribute newComment = attr.createMappedAttribute("task.common.comment.new");
        String comment = "";
        for (CommentEntry c : comments) {
            comment = String.valueOf(comment) + "\n" + c.toString() + "\n" + c.getDashboardURL() + "\n" + "\n";
        }
        newComment.setValue(comment);
        return newComment;
    }

    private static CONNECTOR determineConnectorHandling(String connectorKind) {
        String hpAlmConnectorKind = Activator.getDefault().getAlmAccessProperties().getProperty(CONNECTOR.HP_ALM.toString());
        if (hpAlmConnectorKind.equals(connectorKind)) {
            return CONNECTOR.HP_ALM;
        }
        return CONNECTOR.DEFAULT;
    }

    public static IStatus testConnection(String repoLabel) {
        TaskRepository repository = ALMAccess.getRepositoryByLabel(repoLabel);
        if (repository == null) {
            return new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", NLS.bind((String)Messages.TaskRepositoryNotFound, (Object)repoLabel));
        }
        if (repository.isOffline()) {
            return new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", NLS.bind((String)Messages.TaskRepositoryOffline, (Object)repoLabel));
        }
        boolean savePassword = repository.getSavePassword(AuthenticationType.REPOSITORY);
        if (!savePassword) {
            return new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", NLS.bind((String)Messages.TaskRepositoryNoCredentialsStored, (Object)repoLabel));
        }
        AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)repository.getConnectorKind());
        if (connector == null) {
            return new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", NLS.bind((String)Messages.TaskRepositoryNoConnectorFound, (Object)repoLabel));
        }
        try {
            connector.updateRepositoryConfiguration(repository, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", e.getLocalizedMessage().replace("\n\n", " "));
        }
        IStatus repoStatus = repository.getStatus();
        if (repoStatus != null) {
            return repoStatus;
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getBeanString(FieldUpdate fieldUpdate, VariableToken variable) throws CouldNotResolveException {
        String returnValue = variable.getVariableString();
        if (StringUtils.contains((String)returnValue, (char)'_')) {
            String[] strings = StringUtils.split((String)returnValue, (String)"_", (int)2);
            try {
                if (strings[0].equalsIgnoreCase(VARIABLE_NODE_PREFIX)) {
                    returnValue = strings[1].equalsIgnoreCase(VARIABLE_URL_POSTFIX) ? fieldUpdate.getDashboardURL() : (strings[1].equalsIgnoreCase(VARIABLE_DATE_POSTFIX) ? ALMAccess.formatDate(fieldUpdate.getNode().getTimeStamp()) : BeanUtils.getProperty((Object)fieldUpdate.getNode(), (String)strings[1]));
                }
                if (!strings[0].equalsIgnoreCase(VARIABLE_SUMMARY_PREFIX)) return returnValue;
                if (!strings[1].equalsIgnoreCase(VARIABLE_DATE_POSTFIX)) return BeanUtils.getProperty((Object)fieldUpdate.getSummary(), (String)strings[1]);
                return ALMAccess.formatDate(fieldUpdate.getSummary().getTestsuiteDate());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                CommentReporter.getInstance().getConsole().writeErrorLine(NLS.bind((String)Messages.UnresolvableVariable, (Object)variable.getGuiString()));
                throw new CouldNotResolveException(variable.getGuiString());
            }
        }
        returnValue = variable.getGuiString();
        CommentReporter.getInstance().getConsole().writeErrorLine(NLS.bind((String)Messages.UnresolvableVariable, (Object)variable.getGuiString()));
        throw new CouldNotResolveException(variable.getGuiString());
    }

    private static String formatDate(Date date) {
        return new SimpleDateFormat("dd.MM.yyyy").format(date);
    }

    public static class ALMDefaultTaskMapping
    extends TaskMapping {
        private Map<String, String> m_values = new HashMap<String, String>();

        public String getDescription() {
            return this.m_values.get("task.common.description");
        }

        public String getSummary() {
            return this.m_values.get("task.common.summary");
        }

        public String getProduct() {
            return this.m_values.get("task.common.product");
        }

        public String getTaskKind() {
            return this.m_values.get("task.common.kind");
        }
    }

    public static enum CONNECTOR {
        DEFAULT,
        HP_ALM;

    }

    public static class CouldNotResolveException
    extends Exception {
        public CouldNotResolveException() {
        }

        public CouldNotResolveException(String message) {
            super(message);
        }
    }
}

