/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.IClientTest;
import org.eclipse.jubula.client.core.agent.AutAgentRegistration;
import org.eclipse.jubula.client.core.agent.AutRegistrationEvent;
import org.eclipse.jubula.client.core.agent.IAutRegistrationListener;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ExternalTestDataBP;
import org.eclipse.jubula.client.core.businessprocess.ITestExecutionEventListener;
import org.eclipse.jubula.client.core.businessprocess.TDVariableStore;
import org.eclipse.jubula.client.core.businessprocess.TestExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.TestResultBP;
import org.eclipse.jubula.client.core.commands.DisplayManualTestStepResponseCommand;
import org.eclipse.jubula.client.core.commands.EndTestExecutionResponseCommand;
import org.eclipse.jubula.client.core.commands.TakeScreenshotResponseCommand;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.core.constants.TestExecutionConstants;
import org.eclipse.jubula.client.core.events.AUTEvent;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IEventStackModificationListener;
import org.eclipse.jubula.client.core.model.IExecStackModificationListener;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.LogicComponentNotManagedException;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.client.core.model.ResultTreeBuilder;
import org.eclipse.jubula.client.core.model.ResultTreeTracker;
import org.eclipse.jubula.client.core.model.TestResult;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.rc.commands.AbstractPostExecutionCommand;
import org.eclipse.jubula.client.core.rc.commands.IPostExecutionCommand;
import org.eclipse.jubula.client.core.utils.ExecObject;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.core.utils.Traverser;
import org.eclipse.jubula.client.internal.AutAgentConnection;
import org.eclipse.jubula.client.internal.BaseConnection;
import org.eclipse.jubula.client.internal.commands.CAPTestResponseCommand;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.CAPTestMessage;
import org.eclipse.jubula.communication.internal.message.CAPTestResponseMessage;
import org.eclipse.jubula.communication.internal.message.DisplayManualTestStepMessage;
import org.eclipse.jubula.communication.internal.message.EndTestExecutionMessage;
import org.eclipse.jubula.communication.internal.message.InitTestExecutionMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.communication.internal.message.NullMessage;
import org.eclipse.jubula.communication.internal.message.PrepareForShutdownMessage;
import org.eclipse.jubula.communication.internal.message.ResetMonitoringDataMessage;
import org.eclipse.jubula.communication.internal.message.RestartAutMessage;
import org.eclipse.jubula.communication.internal.message.TakeScreenshotMessage;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.objects.event.TestErrorEvent;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.ExternalCommandExecutor;
import org.eclipse.jubula.tools.internal.utils.IsAliveThread;
import org.eclipse.jubula.tools.internal.utils.StringParsing;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExecution {
    public static final String COMP_SYSTEM_TIMEOUT = "CompSystem.Timeout";
    protected static final int EXIT_CODE_NORUN_OK = 100;
    protected static final int EXIT_CODE_OK = 0;
    private static final Logger LOG = LoggerFactory.getLogger(TestExecution.class);
    private static final String LAST_ACTION_RETURN = "TEST_LAR";
    private static final String CURRENT_DATASET_NUMBER = "TEST_CDN";
    private static TestExecution instance = null;
    private int m_requestTimeout = 600000;
    private int m_stepSpeed = 0;
    private boolean m_paused = false;
    private boolean m_skipError = false;
    private boolean m_stopped = false;
    private boolean m_autoScreenshot = true;
    private ITestJobPO m_startedTestJob;
    private ITestSuitePO m_startedTestSuite;
    private ICapPO m_currentCap;
    private Locale m_executionLanguage;
    private Traverser m_trav;
    private StepCounter m_stepCounter;
    private ResultTreeTracker m_resultTreeTracker;
    private CompNamesBP m_compNamesBP = new CompNamesBP();
    private ExternalTestDataBP m_externalTestDataBP;
    private PostExecCommandFactory m_postExecCmdFactory;
    private TDVariableStore m_varStore = new TDVariableStore();
    private Map<String, Long> m_timerStore;
    private int m_expectedNumberOfSteps;

    private TestExecution() {
        this.m_postExecCmdFactory = new PostExecCommandFactory();
        this.setTimerStore(new HashMap<String, Long>());
        this.m_externalTestDataBP = new ExternalTestDataBP();
        ClientTest.instance().addTestExecutionEventListener(new ITestExecutionEventListener(){

            @Override
            public void endTestExecution() {
                TestExecution.this.m_externalTestDataBP.clearExternalData();
            }

            @Override
            public void stateChanged(TestExecutionEvent event) {
            }
        });
    }

    public static synchronized TestExecution getInstance() {
        if (instance == null) {
            instance = new TestExecution();
        }
        return instance;
    }

    public void executeTestSuite(ITestSuitePO testSuite, Locale locale, AutIdentifier autId, boolean autoScreenshot, Map<String, String> externalVars, ITestResultSummaryPO summary, IProgressMonitor monitor, String noRunOptMode) {
        this.m_stopped = false;
        this.m_autoScreenshot = autoScreenshot;
        this.setPaused(false);
        Validate.notNull((Object)testSuite, (String)Messages.TestsuiteMustNotBeNull);
        this.m_executionLanguage = locale;
        monitor.subTask(NLS.bind((String)Messages.PreparingTestSuiteExecution, (Object)testSuite.getName()));
        this.m_externalTestDataBP.clearExternalData();
        if (TestExecution.shouldExecutionStop(noRunOptMode, TestExecutionConstants.RunSteps.PTE)) {
            monitor.setCanceled(true);
            return;
        }
        try {
            if (AUTConnection.getInstance().connectToAut(autId, (IProgressMonitor)new SubProgressMonitor(monitor, 0))) {
                if (TestExecution.shouldExecutionStop(noRunOptMode, TestExecutionConstants.RunSteps.CA)) {
                    this.endTestExecution();
                    return;
                }
                summary.setAutHostname(AUTConnection.getInstance().getCommunicator().getConnection().getAddress().getCanonicalHostName());
                summary.setAutAgentName(AutAgentConnection.getInstance().getCommunicator().getHostName());
                monitor.subTask(Messages.StartingTestSuite_resolvingPredefinedVariables);
                this.m_varStore.storeEnvironmentVariables();
                this.storePredefinedVariables(this.m_varStore, testSuite);
                this.storeExternallyDefinedVariables(this.m_varStore, externalVars);
                if (TestExecution.shouldExecutionStop(noRunOptMode, TestExecutionConstants.RunSteps.RPV)) {
                    this.endTestExecution();
                    return;
                }
                this.startTestSuite(testSuite, locale, monitor, noRunOptMode);
                final AtomicBoolean testSuiteFinished = new AtomicBoolean();
                ClientTest.instance().addTestExecutionEventListener(new ITestExecutionEventListener(){

                    @Override
                    public void endTestExecution() {
                        try {
                            AUTConnection.getInstance().close();
                        }
                        catch (ConnectionException connectionException) {}
                        ClientTest.instance().removeTestExecutionEventListener(this);
                        testSuiteFinished.set(true);
                    }

                    @Override
                    public void stateChanged(TestExecutionEvent event) {
                    }
                });
                while (!testSuiteFinished.get()) {
                    TimeUtil.delay((long)250L);
                }
            } else {
                this.handleNoConnectionToAUT(testSuite, autId);
            }
        }
        catch (ConnectionException e) {
            LOG.error(String.valueOf(Messages.UnableToConnectToAUT) + ".", (Throwable)e);
        }
    }

    private void storeExternallyDefinedVariables(TDVariableStore varStore, Map<String, String> externalVars) {
        if (externalVars != null) {
            for (String key : externalVars.keySet()) {
                varStore.store(key, externalVars.get(key));
            }
        }
    }

    private void handleNoConnectionToAUT(ITestSuitePO testSuite, AutIdentifier autId) {
        String autName = autId.getExecutableName();
        if (TestExecution.isAutNameSet(autName)) {
            autName = NLS.bind((String)Messages.ErrorDetailNO_AUT_ID_FOR_REF_TS_FOUND, (Object)testSuite.getName());
        }
        ClientTest.instance().fireTestExecutionChanged(new TestExecutionEvent(TestExecutionEvent.State.TEST_EXEC_FAILED, (Exception)((Object)new JBException(String.valueOf(Messages.CouldNotConnectToAUT) + autName, MessageIDs.E_NO_AUT_CONNECTION_ERROR))));
    }

    public static boolean isAutNameSet(String autName) {
        return String.valueOf(autName).equals("null");
    }

    private void storePredefinedVariables(TDVariableStore varStore, ITestSuitePO testSuite) {
        varStore.store("TEST_LANGUAGE", this.m_executionLanguage.toString());
        varStore.store("TEST_TESTSUITE", testSuite.getName());
        varStore.store("TEST_USERNAME", System.getProperty("user.name"));
        varStore.store("TEST_DBUSERNAME", Persistor.instance().getCurrentDBUser());
        try {
            AutAgentConnection serverConn = AutAgentConnection.getInstance();
            varStore.store("TEST_AUTAGENT", serverConn.getCommunicator().getHostName());
            varStore.store("TEST_PORTNUMBER", String.valueOf(serverConn.getCommunicator().getPort()));
        }
        catch (ConnectionException connectionException) {}
        varStore.store("TEST_AUT", testSuite.getAut().getName());
        Map<String, String> autConfigMap = this.getConnectedAUTsConfigMap();
        if (autConfigMap != null) {
            varStore.store("TEST_AUTCONFIG", MapUtils.getString(autConfigMap, (Object)"CONFIG_NAME", (String)"autrun"));
        } else {
            varStore.store("TEST_AUTCONFIG", "autrun");
        }
        varStore.store("TEST_CLIENTVERSION", (String)Platform.getBundle((String)"org.eclipse.jubula.client.core").getHeaders().get("Bundle-Version"));
    }

    protected Map<String, String> getConnectedAUTsConfigMap() {
        if (TestExecution.getInstance().getConnectedAutId() != null) {
            String autID = this.getConnectedAutId().getExecutableName();
            return ClientTest.instance().requestAutConfigMapFromAgent(autID);
        }
        return null;
    }

    private void startTestSuite(ITestSuitePO testSuite, Locale locale, IProgressMonitor monitor, String noRunOptMode) {
        Validate.notNull((Object)testSuite, (String)"No testsuite available");
        ICapPO firstCap = null;
        this.m_expectedNumberOfSteps = 0;
        this.m_trav = new Traverser(testSuite, locale);
        try {
            monitor.subTask(Messages.StartingTestSuite_resolvingTestStepsToExecute);
            monitor.subTask(Messages.StartingTestSuite_buildingTestExecutionTree);
            Traverser copier = new Traverser(testSuite, locale);
            ResultTreeBuilder resultTreeBuilder = new ResultTreeBuilder(copier);
            copier.addExecStackModificationListener(resultTreeBuilder);
            ICapPO iterNode = copier.next();
            while (iterNode != null) {
                iterNode = copier.next();
                ++this.m_expectedNumberOfSteps;
            }
            Map<String, String> autConfigMap = this.getConnectedAUTsConfigMap();
            this.resetMonitoringData(autConfigMap, monitor);
            if (TestExecution.shouldExecutionStop(noRunOptMode, TestExecutionConstants.RunSteps.BT)) {
                this.endTestExecution();
                return;
            }
            TestResultBP.getInstance().setResultTestModel(new TestResult(resultTreeBuilder.getRootNode(), autConfigMap));
            this.initTestExecutionMessage(autConfigMap, monitor);
            this.m_resultTreeTracker = new ResultTreeTracker(resultTreeBuilder.getRootNode(), this.m_externalTestDataBP);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
            subMonitor.beginTask(NLS.bind((String)Messages.StartWorkingWithTestSuite, (Object)testSuite.getName()), this.m_expectedNumberOfSteps);
            this.m_stepCounter = new StepCounter((IProgressMonitor)subMonitor);
            this.addTestExecutionListener();
            this.setStepSpeed(testSuite.getStepDelay());
            ClientTest.instance().fireTestExecutionChanged(new TestExecutionEvent(TestExecutionEvent.State.TEST_EXEC_RESULT_TREE_READY));
            monitor.subTask(NLS.bind((String)Messages.StartingTestSuite, (Object)testSuite.getName()));
            firstCap = this.m_trav.next();
        }
        catch (JBException e) {
            LOG.error(Messages.IncompleteTestdata, (Throwable)e);
            this.fireError((Exception)((Object)e));
        }
        if (firstCap != null) {
            ClientTest.instance().fireTestExecutionChanged(new TestExecutionEvent(TestExecutionEvent.State.TEST_EXEC_START));
            this.processCap(firstCap);
        } else {
            this.endTestExecution();
        }
    }

    private void addTestExecutionListener() {
        this.m_trav.addExecStackModificationListener(this.m_resultTreeTracker);
        this.m_trav.addEventStackModificationListener(this.m_stepCounter);
        this.m_trav.addExecStackModificationListener(this.m_stepCounter);
    }

    private String getAutToolkit() {
        String autToolKit = "";
        IAUTMainPO connectedAut = this.getConnectedAut();
        if (connectedAut != null) {
            autToolKit = connectedAut.getToolkit();
        }
        return autToolKit;
    }

    private void processCap(ICapPO cap) {
        ICapPO currCap = cap;
        MessageCap messageCap = null;
        if (currCap == null) {
            this.endTestExecution();
            return;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.valueOf(Messages.TestStep) + ":" + " " + currCap.getName());
                LOG.debug(String.valueOf(Messages.Component) + ":" + " " + currCap.getComponentName());
            }
            messageCap = this.buildMessageCap(currCap, false);
            if (!this.m_stopped) {
                CAPTestMessage capTestMessage = new CAPTestMessage(messageCap);
                TimeUtil.delay((long)this.m_stepSpeed);
                while (this.isPaused()) {
                    this.testConnection();
                    TimeUtil.delay((long)100L);
                }
                if (!this.m_stopped) {
                    CAPTestResponseMessage clientResponse = this.clientExecutionHandling(currCap, capTestMessage);
                    if (!this.m_stopped) {
                        if (clientResponse != null) {
                            CAPTestResponseCommand responseCommand = new CAPTestResponseCommand();
                            responseCommand.setMessage((Message)clientResponse);
                            responseCommand.setMessageCap(messageCap);
                            responseCommand.execute();
                        } else {
                            int timeOut = this.calculateRequestTimeout(messageCap);
                            AUTConnection.getInstance().request((Message)capTestMessage, (ICommand)new CAPTestResponseCommand(), timeOut);
                        }
                    }
                } else {
                    this.endTestExecution();
                }
            }
        }
        catch (BaseConnection.NotConnectedException bnce) {
            LOG.error(Messages.AUTConnectionFails, (Throwable)bnce);
        }
        catch (CommunicationException bce) {
            LOG.error(Messages.CommunicationWithAUTFails, (Throwable)bce);
            this.fireError((Exception)((Object)bce));
        }
        catch (LogicComponentNotManagedException blcnme) {
            LOG.error(blcnme.getMessage(), (Throwable)((Object)blcnme));
            this.fireComponentError();
        }
        catch (InvalidDataException invalidDataException) {}
    }

    private int calculateRequestTimeout(MessageCap messageCap) {
        int showTextTimeout;
        ArrayList<Integer> timeOuts = new ArrayList<Integer>();
        IParamDescriptionPO desc1 = this.m_currentCap.getParameterForUniqueId(COMP_SYSTEM_TIMEOUT);
        timeOuts.add(this.m_currentCap.getParameterList().indexOf(desc1));
        desc1 = this.m_currentCap.getParameterForUniqueId("CompSystem.TimeMillSec");
        timeOuts.add(this.m_currentCap.getParameterList().indexOf(desc1));
        int timeout = 0;
        Iterator iterator = timeOuts.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (index <= -1) continue;
            MessageParam param = (MessageParam)messageCap.getMessageParams().get(index);
            String paramTimeOut = param.getValue();
            timeout += Integer.parseInt(paramTimeOut);
        }
        boolean isShowText = messageCap.getMethod().equals("rcShowText");
        if (isShowText && (showTextTimeout = this.calculateShowTextTimeout(messageCap)) != -1) {
            timeout += showTextTimeout;
        }
        return this.m_requestTimeout + timeout;
    }

    private CAPTestResponseMessage clientExecutionHandling(ICapPO cap, CAPTestMessage capTestMessage) {
        String postExecCommandClass;
        IPostExecutionCommand command;
        TestErrorEvent errorEvent;
        Action action = cap.getMetaAction();
        if (!action.isClientAction()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.valueOf(Messages.ExecutingClientAction) + ":" + " " + action.getPostExecutionCommand());
        }
        if ((errorEvent = this.executePostExecCommand(command = this.m_postExecCmdFactory.createCommand(postExecCommandClass = action.getPostExecutionCommand()))) != null) {
            CAPTestResponseMessage response = new CAPTestResponseMessage();
            response.setTestErrorEvent(errorEvent);
            response.setMessageCap(capTestMessage.getMessageCap());
            return response;
        }
        return null;
    }

    private int calculateShowTextTimeout(MessageCap messageCap) {
        MessageParam textParam = (MessageParam)messageCap.getMessageParams().get(0);
        MessageParam timePerWordParam = (MessageParam)messageCap.getMessageParams().get(2);
        try {
            int numWords = StringParsing.countWords((String)textParam.getValue());
            return Integer.parseInt(timePerWordParam.getValue()) * numWords;
        }
        catch (NumberFormatException e) {
            LOG.warn(String.valueOf(Messages.ErrorParsingTimeoutParameter) + "." + " " + Messages.UsingDefaultValue + ".", (Throwable)e);
            return -1;
        }
    }

    private MessageCap buildMessageCap(ICapPO cap, boolean runIncomplete) throws InvalidDataException, LogicComponentNotManagedException {
        String logicalName = null;
        try {
            MessageCap messageCap = new MessageCap();
            CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
            this.m_currentCap = cap;
            ITestSuitePO ts = (ITestSuitePO)this.m_trav.getRoot();
            IAUTMainPO aut = ts.getAut();
            Component comp = compSystem.findComponent(cap.getComponentType());
            if (!StringUtils.isEmpty((String)cap.getComponentName())) {
                logicalName = this.m_compNamesBP.findCompName(this.m_trav.getExecStackAsNodeList(), cap, cap.getComponentName(), ComponentNamesBP.getInstance()).getCompName();
            }
            messageCap.setResolvedLogicalName(logicalName);
            IComponentIdentifier technicalName = null;
            technicalName = this.getTechnicalName(logicalName, aut, comp);
            if (comp.isConcrete() && ((ConcreteComponent)comp).hasDefaultMapping()) {
                messageCap.sethasDefaultMapping(true);
            }
            if (technicalName == null) {
                throw new LogicComponentNotManagedException("", MessageIDs.E_COMPONENT_NOT_MANAGED);
            }
            Action action = comp.findAction(cap.getActionName());
            messageCap.setMethod(action.getMethod());
            messageCap.setPostExecutionCommand(action.getPostExecutionCommand());
            messageCap.setCi(technicalName);
            if (cap.getParameterList() != null) {
                messageCap = this.configureMessageCap(cap, messageCap, action, runIncomplete);
            }
            return messageCap;
        }
        catch (LogicComponentNotManagedException blcnme) {
            StringBuilder msg = new StringBuilder();
            msg.append(Messages.NoEntryFor);
            msg.append(" ");
            msg.append(cap.getComponentName());
            msg.append("(");
            msg.append("=");
            msg.append(Messages.ProfessionalName);
            msg.append(")");
            msg.append(" ");
            msg.append("/");
            msg.append(" ");
            msg.append("(");
            msg.append("=");
            msg.append(Messages.TechnicalName);
            msg.append(")");
            LOG.error(msg.toString(), (Throwable)((Object)blcnme));
            throw blcnme;
        }
        catch (InvalidDataException e) {
            if (runIncomplete) {
                throw e;
            }
            return null;
        }
    }

    private IComponentIdentifier getTechnicalName(String logicalName, IAUTMainPO aut, Component comp) {
        IComponentIdentifier technicalName;
        IObjectMappingPO om = aut.getObjMap();
        try {
            technicalName = om.getTechnicalName(logicalName);
        }
        catch (LogicComponentNotManagedException logicComponentNotManagedException) {
            technicalName = null;
        }
        if (technicalName == null && comp instanceof ConcreteComponent) {
            ConcreteComponent cc = (ConcreteComponent)comp;
            String toolkit = aut.getToolkit();
            if (cc.hasDefaultMapping() && cc.getComponentClass() != null) {
                return ToolkitSupportBP.getIdentifierOfMostAbstractRealizingComponentInToolkit((String)toolkit, (ConcreteComponent)cc);
            }
        }
        return technicalName;
    }

    private MessageCap configureMessageCap(ICapPO cap, MessageCap messageCap, Action action, boolean runIncomplete) throws InvalidDataException {
        ITDManager tdManager = null;
        try {
            tdManager = this.m_externalTestDataBP.getExternalCheckedTDManager(cap);
        }
        catch (JBException gde) {
            this.fireError((Exception)((Object)gde));
        }
        if (tdManager != null) {
            for (IParamDescriptionPO desc : cap.getParameterList()) {
                if (this.m_stopped) {
                    return messageCap;
                }
                MessageParam messageParam = this.createMessageParam(desc, action);
                messageCap.addMessageParam(messageParam);
                ITestDataPO date = tdManager.getCell(0, desc);
                StringBuilder msg = new StringBuilder();
                msg.append(Messages.NoTestdataAvailableForCAP);
                msg.append(":");
                msg.append(" ");
                msg.append(cap.getName());
                msg.append(",");
                msg.append(" ");
                msg.append(Messages.Parameter);
                msg.append(":");
                msg.append(" ");
                msg.append(desc.getName());
                msg.append(",");
                msg.append(" ");
                msg.append(Messages.AndDatasetNumberZero);
                Validate.notNull((Object)date, (String)msg.toString());
                String value = null;
                try {
                    int dsNumber = this.m_trav.getDataSetNumber();
                    this.m_varStore.store(CURRENT_DATASET_NUMBER, String.valueOf(dsNumber + 1));
                    ModelParamValueConverter conv = new ModelParamValueConverter(date.getValue(this.getLocale()), (IParameterInterfacePO)cap, this.getLocale(), desc);
                    ArrayList<ExecObject> stackList = new ArrayList<ExecObject>(this.m_trav.getExecStackAsList());
                    value = conv.getExecutionString(stackList, this.getLocale());
                }
                catch (InvalidDataException e) {
                    if (!runIncomplete) {
                        StringBuilder msgbuild = new StringBuilder();
                        msgbuild.append(Messages.NoValueAvailableForParameter);
                        msgbuild.append(":");
                        msgbuild.append(" ");
                        msgbuild.append(desc.getName());
                        msgbuild.append(" ");
                        msgbuild.append(Messages.InNode);
                        msgbuild.append(":");
                        msgbuild.append(" ");
                        msgbuild.append(cap.getName());
                        LOG.error(msgbuild.toString(), (Throwable)e);
                        this.fireError((Exception)((Object)e));
                    }
                    throw e;
                }
                messageParam.setValue(value);
            }
        }
        return messageCap;
    }

    private MessageParam createMessageParam(IParamDescriptionPO desc, Action action) {
        Param xmlParam = action.findParam(desc.getUniqueId());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.valueOf(Messages.Param) + ":" + " " + xmlParam.getName());
        }
        MessageParam messageParam = new MessageParam();
        messageParam.setType(xmlParam.getType());
        return messageParam;
    }

    public void processServerResponse(final CAPTestResponseMessage msg) {
        IsAliveThread t = new IsAliveThread("Execute Test Step"){

            public void run() {
                boolean testOk;
                ICapPO nextCap = null;
                TestExecution.this.processPostExecution(msg);
                TestResultNode resultNode = TestExecution.this.m_resultTreeTracker.getEndNode();
                MessageCap mc = msg.getMessageCap();
                resultNode.setComponentName(ComponentNamesBP.getInstance().getName(mc.getResolvedLogicalName(), GeneralStorage.getInstance().getProject().getId()));
                IComponentIdentifier ci = mc.getCi();
                resultNode.setOmHeuristicEquivalence(ci.getMatchPercentage());
                resultNode.setNoOfSimilarComponents(ci.getNumberOfOtherMatchingComponents());
                boolean bl = testOk = !msg.hasTestErrorEvent();
                if (msg.getState() == 31) {
                    TestExecution.this.pauseExecution(PauseMode.PAUSE);
                }
                if (testOk) {
                    resultNode.setResult(TestExecution.this.m_trav.getSuccessResult(), null);
                } else {
                    TestErrorEvent event = msg.getTestErrorEvent();
                    if (TestExecution.this.m_trav.getEventHandlerReentry(event.getId()).equals(ReentryProperty.RETRY)) {
                        resultNode.setResult(7, event);
                    } else {
                        TestExecution.this.m_stepCounter.incrementNumberOfFailedSteps();
                        resultNode.setResult(2, event);
                        if (TestExecution.this.m_autoScreenshot) {
                            TestExecution.this.addScreenshot(resultNode);
                        }
                        if (ClientTest.instance().isPauseTestExecutionOnError()) {
                            TestExecution.this.pauseExecution(PauseMode.PAUSE);
                        }
                    }
                }
                while (TestExecution.this.isPaused()) {
                    TestExecution.this.testConnection();
                    TimeUtil.delay((long)100L);
                }
                if (!TestExecution.this.m_stopped) {
                    try {
                        nextCap = testOk || TestExecution.this.m_skipError ? TestExecution.this.m_trav.next() : TestExecution.this.m_trav.next(msg.getTestErrorEvent().getId());
                        TestExecution.this.m_skipError = false;
                    }
                    catch (JBException e) {
                        LOG.error(Messages.IncompleteTestdata, (Throwable)e);
                        TestExecution.this.fireError((Exception)((Object)e));
                    }
                    if (nextCap != null) {
                        TestExecution.this.processCap(nextCap);
                    } else {
                        if (LOG.isInfoEnabled()) {
                            LOG.info(Messages.TestsuiteFinished);
                        }
                        TestExecution.this.endTestExecution();
                    }
                }
            }
        };
        t.start();
    }

    private void addScreenshot(TestResultNode resultNode) {
        block4: {
            TakeScreenshotResponseCommand command = new TakeScreenshotResponseCommand(resultNode);
            TakeScreenshotMessage message = new TakeScreenshotMessage();
            try {
                AUTConnection.getInstance().request((Message)message, command, 10000);
            }
            catch (BaseConnection.NotConnectedException nce) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(nce.getLocalizedMessage(), (Throwable)nce);
                }
            }
            catch (CommunicationException ce) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error(ce.getLocalizedMessage(), (Throwable)ce);
            }
        }
    }

    private void processPostExecution(CAPTestResponseMessage msg) {
        this.m_varStore.store(LAST_ACTION_RETURN, msg.getReturnValue());
        String cmdClassName = msg.getMessageCap().getPostExecutionCommand();
        if (cmdClassName != null && cmdClassName.length() > 0 && !this.m_currentCap.getMetaAction().isClientAction()) {
            TestErrorEvent errorEvent = this.executePostExecCommand(this.m_postExecCmdFactory.createCommand(cmdClassName));
            if (msg.getTestErrorEvent() == null && errorEvent != null) {
                msg.setTestErrorEvent(errorEvent);
            }
        }
    }

    private TestErrorEvent executePostExecCommand(IPostExecutionCommand cmd) {
        if (cmd instanceof AbstractPostExecutionCommand) {
            AbstractPostExecutionCommand aCmd = (AbstractPostExecutionCommand)cmd;
            aCmd.setCurrentCap(this.m_currentCap);
            aCmd.setExternalTestDataBP(this.m_externalTestDataBP);
            aCmd.setLocale(this.getLocale());
            aCmd.setTraverser(this.m_trav);
        }
        try {
            return cmd.execute();
        }
        catch (JBException e) {
            LOG.error(NLS.bind((String)Messages.ErrorExecutingCommand, (Object)cmd.getClass().getName(), (Object)e.getLocalizedMessage()));
            this.fireError((Exception)((Object)e));
            return null;
        }
    }

    protected void testConnection() {
        try {
            AUTConnection.getInstance().send((Message)new NullMessage());
        }
        catch (CommunicationException communicationException) {
            this.fireError((Exception)((Object)new JBException(MessageIDs.getMessage((Integer)MessageIDs.E_INTERRUPTED_CONNECTION), MessageIDs.E_INTERRUPTED_CONNECTION)));
        }
    }

    private void initTestExecutionMessage(Map<String, String> autConfigMap, IProgressMonitor monitor) {
        try {
            InitTestExecutionMessage msg = new InitTestExecutionMessage();
            if (autConfigMap != null) {
                monitor.subTask(Messages.StartingTestSuite_activatingAUT);
                msg.setDefaultActivationMethod(IAUTConfigPO.ActivationMethod.getRCString(autConfigMap.get("ACTIVATION_METHOD")));
                AUTConnection.getInstance().send((Message)msg);
            }
        }
        catch (CommunicationException exc) {
            this.fireError((Exception)((Object)exc));
        }
    }

    private void fireError(Exception e) {
        ClientTest.instance().fireTestExecutionChanged(new TestExecutionEvent(TestExecutionEvent.State.TEST_EXEC_FAILED, e));
        this.endTestExecution();
    }

    private void fireComponentError() {
        ClientTest.instance().fireTestExecutionChanged(new TestExecutionEvent(TestExecutionEvent.State.TEST_EXEC_COMPONENT_FAILED));
        this.endTestExecution();
    }

    public void setStepSpeed(int stepSpeed) {
        this.m_stepSpeed = stepSpeed > 0 ? stepSpeed : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExecution() {
        TestExecution testExecution = this;
        synchronized (testExecution) {
            if (!this.m_stopped) {
                this.m_stopped = true;
                this.setPaused(false);
                this.m_timerStore.clear();
                try {
                    AUTConnection.getInstance().getCommunicator().interruptAllTimeouts();
                }
                catch (ConnectionException e) {
                    this.fireError((Exception)((Object)e));
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info(Messages.TestsuiteIsStopped);
                }
                ClientTest.instance().fireEndTestExecution();
                try {
                    AUTConnection.getInstance().close();
                }
                catch (ConnectionException connectionException) {}
            }
        }
    }

    private void resetMonitoringData(Map<String, String> autConfigMap, IProgressMonitor monitor) {
        boolean reset;
        String resetString;
        if (autConfigMap != null && (resetString = autConfigMap.get("RESET_AGENT")) != null && (reset = Boolean.valueOf(resetString).booleanValue())) {
            try {
                monitor.subTask(Messages.StartingTestSuite_resettingMonitoringData);
                ResetMonitoringDataMessage message = new ResetMonitoringDataMessage(AUTConnection.getInstance().getConnectedAutId().getExecutableName());
                AutAgentConnection.getInstance().send((Message)message);
            }
            catch (BaseConnection.NotConnectedException nce) {
                LOG.error(nce.getLocalizedMessage(), (Throwable)nce);
            }
            catch (CommunicationException ce) {
                LOG.error(ce.getLocalizedMessage(), (Throwable)ce);
            }
        }
    }

    public void endTestExecution() {
        EndTestExecutionResponseCommand command = new EndTestExecutionResponseCommand();
        EndTestExecutionMessage message = new EndTestExecutionMessage();
        try {
            AUTConnection.getInstance().request((Message)message, command, 10000);
        }
        catch (BaseConnection.NotConnectedException nce) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(nce.getLocalizedMessage(), (Throwable)nce);
            }
            this.stopExecution();
        }
        catch (CommunicationException ce) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(ce.getLocalizedMessage(), (Throwable)ce);
            }
            this.stopExecution();
        }
    }

    public void pauseExecution(PauseMode pm) {
        switch (pm) {
            case PAUSE: {
                if (this.isPaused()) break;
                this.pauseExecution(PauseMode.TOGGLE);
                break;
            }
            case UNPAUSE: {
                if (!this.isPaused()) break;
                this.pauseExecution(PauseMode.TOGGLE);
                break;
            }
            case TOGGLE: {
                this.setPaused(!this.isPaused());
                if (this.isPaused()) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info(Messages.TestsuiteIsPaused);
                    }
                    ClientTest.instance().fireTestExecutionChanged(new TestExecutionEvent(TestExecutionEvent.State.TEST_EXEC_PAUSED));
                    break;
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info(Messages.TestexecutionHasResumed);
                }
                ClientTest.instance().fireTestExecutionChanged(new TestExecutionEvent(TestExecutionEvent.State.TEST_EXEC_START));
                break;
            }
            case CONTINUE_WITHOUT_EH: {
                this.m_skipError = true;
                this.pauseExecution(PauseMode.UNPAUSE);
                break;
            }
        }
    }

    public void timeout() {
        this.m_resultTreeTracker.getEndNode().setResult(9, null);
        this.fireError((Exception)((Object)new JBException(MessageIDs.getMessage((Integer)MessageIDs.E_TIMEOUT_CONNECTION), MessageIDs.E_TIMEOUT_CONNECTION)));
    }

    public ICapPO getActualCap() {
        return this.m_currentCap;
    }

    public Locale getLocale() {
        return this.m_executionLanguage;
    }

    public Traverser getTrav() {
        return this.m_trav;
    }

    protected boolean isPaused() {
        return this.m_paused;
    }

    public AutIdentifier getConnectedAutId() {
        try {
            return AUTConnection.getInstance().getConnectedAutId();
        }
        catch (ConnectionException connectionException) {
            return null;
        }
    }

    public IAUTMainPO getConnectedAut() {
        return AutAgentRegistration.getAutForId(this.getConnectedAutId(), GeneralStorage.getInstance().getProject());
    }

    public ITestSuitePO getStartedTestSuite() {
        return this.m_startedTestSuite;
    }

    public ITestJobPO getStartedTestJob() {
        return this.m_startedTestJob;
    }

    public void setStartedTestJob(ITestJobPO startedTestJob) {
        this.m_startedTestJob = startedTestJob;
    }

    public void setStartedTestSuite(ITestSuitePO startedTestSuite) {
        this.m_startedTestSuite = startedTestSuite;
    }

    public TDVariableStore getVariableStore() {
        return this.m_varStore;
    }

    public int getNumberOfTestedSteps() {
        return this.m_stepCounter.getTotalSteps();
    }

    public int getExpectedNumberOfSteps() {
        return this.m_expectedNumberOfSteps;
    }

    public int getNumberOfEventHandlerSteps() {
        return this.m_stepCounter.getEventHandlerSteps();
    }

    public int getNumberOfRetriedSteps() {
        return this.m_stepCounter.getRetriedSteps();
    }

    public int getNumberOfFailedSteps() {
        return this.m_stepCounter.getFailedSteps();
    }

    public void setTimerStore(Map<String, Long> timerStore) {
        this.m_timerStore = timerStore;
    }

    public Map<String, Long> getTimerStore() {
        return this.m_timerStore;
    }

    private void setPaused(boolean paused) {
        this.m_paused = paused;
    }

    public static boolean shouldExecutionStop(String noRunMode, TestExecutionConstants.RunSteps step) {
        if (StringUtils.isEmpty((String)noRunMode)) {
            return false;
        }
        return noRunMode.equals(step.getStepValue());
    }

    private static class AUTTerminationListener
    implements IAutRegistrationListener {
        private boolean m_autTerminated = false;
        private AutIdentifier m_autId = null;
        private AtomicBoolean m_hasAutRestarted = new AtomicBoolean(false);

        public AUTTerminationListener(AutIdentifier autID) {
            this.m_autId = autID;
        }

        @Override
        public void handleAutRegistration(AutRegistrationEvent event) {
            if (this.m_autId.equals((Object)event.getAutId())) {
                if (event.getStatus() == AutRegistrationEvent.RegistrationStatus.Deregister) {
                    this.setAutTerminated(true);
                }
                if (this.hasAutTerminated() && event.getStatus() == AutRegistrationEvent.RegistrationStatus.Register) {
                    this.hasAutRestarted().set(true);
                }
            }
        }

        public AtomicBoolean hasAutRestarted() {
            return this.m_hasAutRestarted;
        }

        public boolean hasAutTerminated() {
            return this.m_autTerminated;
        }

        private void setAutTerminated(boolean autTerminated) {
            this.m_autTerminated = autTerminated;
        }
    }

    public abstract class AbstractRestartCmd
    extends AbstractPostExecutionCommand {
        protected static final int NO_TIMEOUT__FORCE_RESTART = 0;

        @Override
        public final TestErrorEvent execute() throws JBException {
            AutIdentifier autId = TestExecution.this.getConnectedAutId();
            AUTTerminationListener registrationListener = new AUTTerminationListener(autId);
            try {
                TimeUtil.delay((long)2000L);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(Messages.RequestingAUTAgentToCloseAUTConnection);
                }
                AUTConnection.getInstance().getCommunicator().getConnectionManager().remove(AUTConnection.getInstance().getCommunicator().getConnection());
                AUTConnection.getInstance().reset();
                AUTConnection.getInstance().close();
                boolean wasInterrupted = Thread.interrupted();
                AutAgentRegistration.getInstance().addListener(registrationListener);
                IClientTest clientTest = ClientTest.instance();
                clientTest.fireAUTStateChanged(new AUTEvent(9));
                int initialTerminationTimeout = this.getTerminationTimeout();
                int terminationTimeout = initialTerminationTimeout + 5000;
                long startTime = System.currentTimeMillis();
                long endTime = 0L;
                AutAgentConnection.getInstance().send((Message)new RestartAutMessage(autId, terminationTimeout));
                while (!registrationListener.hasAutRestarted().get()) {
                    try {
                        if (endTime == 0L && registrationListener.hasAutTerminated()) {
                            endTime = System.currentTimeMillis();
                        }
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        wasInterrupted = true;
                    }
                }
                AUTConnection.getInstance().connectToAut(autId, (IProgressMonitor)new NullProgressMonitor());
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
                TestExecution.this.initTestExecutionMessage(TestExecution.this.getConnectedAUTsConfigMap(), (IProgressMonitor)new NullProgressMonitor());
                long terminationDuration = endTime - startTime;
                if (initialTerminationTimeout > 0 && terminationDuration > (long)terminationTimeout) {
                    TestErrorEvent testErrorEvent = EventFactory.createActionError((String)"TestErrorEvent.TimeoutExpired");
                    return testErrorEvent;
                }
                return null;
            }
            finally {
                AutAgentRegistration.getInstance().removeListener(registrationListener);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(Messages.ContinueTestExecution);
                }
                if (!TestExecution.this.m_stopped) {
                    ClientTest.instance().fireTestExecutionChanged(new TestExecutionEvent(TestExecutionEvent.State.TEST_EXEC_RESTART));
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(Messages.CantContinueTSIsStopped);
                }
            }
        }

        protected abstract int getTerminationTimeout() throws JBException;
    }

    public abstract class AbstractTimerCmd
    extends AbstractPostExecutionCommand {
        protected String getTimerName() throws JBException {
            return this.getValueForParam("CompSystem.TimerName");
        }
    }

    public class CommandExecutorCmd
    extends AbstractPostExecutionCommand {
        @Override
        public TestErrorEvent execute() throws JBException {
            IParamDescriptionPO desc = TestExecution.this.m_currentCap.getParameterForUniqueId("CompSystem.RunLocal");
            try {
                ITDManager tdManager = TestExecution.this.m_externalTestDataBP.getExternalCheckedTDManager(TestExecution.this.m_currentCap);
                ITestDataPO date = tdManager.getCell(0, desc);
                String runLocal = this.getValueForParam(date, TestExecution.this.m_currentCap, desc);
                if (Boolean.valueOf(runLocal).booleanValue()) {
                    desc = TestExecution.this.m_currentCap.getParameterForUniqueId("CompSystem.Command");
                    date = tdManager.getCell(0, desc);
                    String cmd = this.getValueForParam(date, TestExecution.this.m_currentCap, desc);
                    desc = TestExecution.this.m_currentCap.getParameterForUniqueId(TestExecution.COMP_SYSTEM_TIMEOUT);
                    date = tdManager.getCell(0, desc);
                    int timeout = Integer.parseInt(this.getValueForParam(date, TestExecution.this.m_currentCap, desc));
                    desc = TestExecution.this.m_currentCap.getParameterForUniqueId("CompSystem.ExpectedExitCode");
                    date = tdManager.getCell(0, desc);
                    int expectedExitCode = Integer.parseInt(this.getValueForParam(date, TestExecution.this.m_currentCap, desc));
                    File dataDir = ExternalTestDataBP.getDataDir();
                    ExternalCommandExecutor.MonitorTask mt = new ExternalCommandExecutor().executeCommand(dataDir, cmd, timeout);
                    if (!mt.wasCmdValid()) {
                        return EventFactory.createActionError((String)"TestErrorEvent.NoSuchCommand");
                    }
                    if (mt.hasTimeoutOccurred()) {
                        return EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout");
                    }
                    int actualExitValue = mt.getExitCode();
                    if (actualExitValue != expectedExitCode) {
                        return EventFactory.createVerifyFailed((String)String.valueOf(expectedExitCode), (String)String.valueOf(actualExitValue));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new JBException("IllegalArgumentException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            catch (InvalidDataException e) {
                throw new JBException("InvalidDataException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            return null;
        }
    }

    public class ManualTestStepCmd
    extends AbstractPostExecutionCommand {
        private String m_comment = null;
        private boolean m_status = false;

        @Override
        public TestErrorEvent execute() throws JBException {
            try {
                String actionToPerform = this.getValueForParam("CompSystem.ActionToPerfom");
                String expectedBehavior = this.getValueForParam("CompSystem.ExpectedBehavior");
                int timeout = Integer.parseInt(this.getValueForParam(TestExecution.COMP_SYSTEM_TIMEOUT));
                DisplayManualTestStepMessage message = new DisplayManualTestStepMessage(actionToPerform, expectedBehavior, timeout);
                DisplayManualTestStepResponseCommand command = new DisplayManualTestStepResponseCommand(this);
                AutAgentConnection.getInstance().request((Message)message, (ICommand)command, timeout);
                int waited = 0;
                while (command.getMessage() == null && waited <= timeout) {
                    try {
                        Thread.sleep(200L);
                        waited += 200;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (waited > timeout) {
                    return EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout");
                }
                if (!this.m_status) {
                    return EventFactory.createVerifyFailed((String)String.valueOf(expectedBehavior), (String)String.valueOf(this.m_comment));
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                throw new JBException("IllegalArgumentException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            catch (InvalidDataException e) {
                throw new JBException("InvalidDataException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
        }

        public void setComment(String comment) {
            this.m_comment = comment;
        }

        public String getComment() {
            return this.m_comment;
        }

        public void setStatus(boolean status) {
            this.m_status = status;
        }

        public boolean isStatus() {
            return this.m_status;
        }
    }

    public static enum PauseMode {
        TOGGLE,
        PAUSE,
        UNPAUSE,
        CONTINUE_WITHOUT_EH;

    }

    private class PostExecCommandFactory {
        private Map<String, IPostExecutionCommand> m_commandCache = new HashMap<String, IPostExecutionCommand>();

        private PostExecCommandFactory() {
        }

        public IPostExecutionCommand createCommand(String commandClassName) {
            Class<?> cmdClazz = null;
            IPostExecutionCommand cmdInstance = this.m_commandCache.get(commandClassName);
            if (cmdInstance != null) {
                return cmdInstance;
            }
            try {
                cmdClazz = Class.forName(commandClassName);
            }
            catch (ClassNotFoundException e) {
                LOG.error("ClassNotFoundException", (Throwable)e);
                TestExecution.this.fireError(e);
            }
            Constructor<?> constructor = null;
            try {
                constructor = cmdClazz.getConstructor(new Class[0]);
                cmdInstance = constructor.newInstance(new Object[0]);
            }
            catch (SecurityException e) {
                LOG.error("SecurityException", (Throwable)e);
                TestExecution.this.fireError(e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    constructor = cmdClazz.getConstructor(TestExecution.this.getClass());
                    cmdInstance = constructor.newInstance(TestExecution.this);
                }
                catch (SecurityException e1) {
                    LOG.error("SecurityException", (Throwable)e1);
                    TestExecution.this.fireError(e1);
                }
                catch (NoSuchMethodException e1) {
                    LOG.error("NoSuchMethodException", (Throwable)e1);
                    TestExecution.this.fireError(e1);
                }
                catch (IllegalArgumentException e1) {
                    LOG.error("IllegalArgumentException", (Throwable)e1);
                    TestExecution.this.fireError(e1);
                }
                catch (InstantiationException e1) {
                    LOG.error("InstantiationException", (Throwable)e1);
                    TestExecution.this.fireError(e1);
                }
                catch (IllegalAccessException e1) {
                    LOG.error("IllegalAccessException", (Throwable)e1);
                    TestExecution.this.fireError(e1);
                }
                catch (InvocationTargetException e1) {
                    LOG.error("InvocationTargetException", (Throwable)e1);
                    TestExecution.this.fireError(e1);
                }
            }
            catch (IllegalArgumentException e) {
                LOG.error("IllegalArgumentException", (Throwable)e);
                TestExecution.this.fireError(e);
            }
            catch (InstantiationException e) {
                LOG.error("InstantiationException", (Throwable)e);
                TestExecution.this.fireError(e);
            }
            catch (IllegalAccessException e) {
                LOG.error("IllegalAccessException", (Throwable)e);
                TestExecution.this.fireError(e);
            }
            catch (InvocationTargetException e) {
                LOG.error("InvocationTargetException", (Throwable)e);
                TestExecution.this.fireError(e);
            }
            IPostExecutionCommand cmd = cmdInstance;
            this.m_commandCache.put(commandClassName, cmd);
            return cmd;
        }
    }

    public class PrepareForShutdownCmd
    implements IPostExecutionCommand {
        @Override
        public TestErrorEvent execute() throws JBException {
            AUTConnection.getInstance().getCommunicator().send((Message)new PrepareForShutdownMessage(false, TestExecution.this.m_stepSpeed));
            return null;
        }
    }

    public class ReadTimerCmd
    extends AbstractTimerCmd {
        @Override
        public TestErrorEvent execute() throws JBException {
            try {
                String timerName = this.getTimerName();
                String variableName = this.getValueForParam("CompSystem.VariableToStoreTimeDeltaSinceTimerStart");
                Long timerTimeInMillisecs = TestExecution.this.getTimerStore().get(timerName);
                if (timerTimeInMillisecs == null) {
                    return EventFactory.createActionError((String)"TestErrorEvent.TimerNotFound");
                }
                Long curTimeInMillisecs = new Long(System.currentTimeMillis());
                Long timeDelta = curTimeInMillisecs - timerTimeInMillisecs;
                TestExecution.this.m_varStore.store(variableName, timeDelta.toString());
            }
            catch (IllegalArgumentException e) {
                throw new JBException("IllegalArgumentException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            catch (InvalidDataException e) {
                throw new JBException("InvalidDataException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            return null;
        }
    }

    public class RestartCmd
    extends AbstractRestartCmd {
        @Override
        protected int getTerminationTimeout() {
            return 0;
        }
    }

    public class StartTimerCmd
    extends AbstractTimerCmd {
        @Override
        public TestErrorEvent execute() throws JBException {
            try {
                String timerName = this.getTimerName();
                String variableName = this.getValueForParam("CompSystem.VariableToStoreAbsoluteStartTime");
                Long curTimeInMillisecs = new Long(System.currentTimeMillis());
                TestExecution.this.getTimerStore().put(timerName, curTimeInMillisecs);
                TestExecution.this.m_varStore.store(variableName, curTimeInMillisecs.toString());
            }
            catch (IllegalArgumentException e) {
                throw new JBException("IllegalArgumentException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            catch (InvalidDataException e) {
                throw new JBException("InvalidDataException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            return null;
        }
    }

    private static class StepCounter
    implements IExecStackModificationListener,
    IEventStackModificationListener {
        private int m_totalSteps = 0;
        private int m_eventHandlerSteps = 0;
        private int m_retriedSteps = 0;
        private int m_failedSteps = 0;
        private int m_currentEventStackDepth = 0;
        private IProgressMonitor m_monitor;

        public StepCounter(IProgressMonitor monitor) {
            this.m_monitor = monitor;
        }

        @Override
        public void nextCap(ICapPO cap) {
            if (this.m_currentEventStackDepth > 0) {
                ++this.m_eventHandlerSteps;
            } else {
                this.m_monitor.worked(1);
            }
            ++this.m_totalSteps;
        }

        @Override
        public void nextDataSetIteration() {
        }

        @Override
        public void retryCap(ICapPO cap) {
            if (this.m_currentEventStackDepth <= 0) {
                ++this.m_retriedSteps;
            } else {
                ++this.m_eventHandlerSteps;
            }
            ++this.m_totalSteps;
        }

        @Override
        public void stackDecremented() {
        }

        @Override
        public void stackIncremented(INodePO node) {
        }

        @Override
        public void eventStackDecremented() {
            --this.m_currentEventStackDepth;
        }

        @Override
        public void eventStackIncremented() {
            ++this.m_currentEventStackDepth;
        }

        public int getTotalSteps() {
            return this.m_totalSteps;
        }

        public int getEventHandlerSteps() {
            return this.m_eventHandlerSteps;
        }

        public int getRetriedSteps() {
            return this.m_retriedSteps;
        }

        public int getFailedSteps() {
            return this.m_failedSteps;
        }

        public void incrementNumberOfFailedSteps() {
            ++this.m_failedSteps;
        }
    }

    public class SyncShutdownAndRestartCmd
    extends AbstractRestartCmd {
        @Override
        protected int getTerminationTimeout() throws JBException {
            String timeout = this.getValueForParam(TestExecution.COMP_SYSTEM_TIMEOUT);
            int parseInt = 0;
            try {
                parseInt = Integer.parseInt(timeout);
            }
            catch (NumberFormatException nfe) {
                LOG.error(nfe.getLocalizedMessage(), (Throwable)nfe);
            }
            return parseInt;
        }
    }

    public class VariableStorerCmd
    extends AbstractPostExecutionCommand {
        @Override
        public TestErrorEvent execute() throws JBException {
            IParamDescriptionPO desc = TestExecution.this.m_currentCap.getParameterList().get(0);
            try {
                ITDManager tdManager = TestExecution.this.m_externalTestDataBP.getExternalCheckedTDManager(TestExecution.this.m_currentCap);
                ITestDataPO date = tdManager.getCell(0, desc);
                String varName = this.getValueForParam(date, TestExecution.this.m_currentCap, desc);
                TestExecution.this.m_varStore.store(varName, TestExecution.this.m_varStore.getValue(TestExecution.LAST_ACTION_RETURN));
                return null;
            }
            catch (IllegalArgumentException e) {
                throw new JBException("IllegalArgumentException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
            catch (InvalidDataException e) {
                throw new JBException("InvalidDataException", (Throwable)e, MessageIDs.E_STEP_EXEC);
            }
        }
    }
}

