/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;

public class ObjectMappingManager {
    private Map<IAUTMainPO, Map<IComponentIdentifier, String>> m_objectMappings = new HashMap<IAUTMainPO, Map<IComponentIdentifier, String>>();

    public void saveMappings() throws PMException, ProjectDeletedException, IncompatibleTypeException {
        try {
            for (IAUTMainPO aut : this.m_objectMappings.keySet()) {
                if (aut == null) continue;
                EditSupport editSupport = new EditSupport(aut, null);
                editSupport.reinitializeEditSupport();
                editSupport.lockWorkVersion();
                IAUTMainPO workVersion = (IAUTMainPO)editSupport.getWorkVersion();
                IObjectMappingPO objMap = workVersion.getObjMap();
                Map<IComponentIdentifier, String> autObjectMapping = this.m_objectMappings.get(aut);
                if (autObjectMapping != null) {
                    for (IComponentIdentifier ci : autObjectMapping.keySet()) {
                        objMap.addObjectMappingAssoziation(autObjectMapping.get(ci), ci);
                    }
                }
                editSupport.saveWorkVersion();
                DataEventDispatcher.getInstance().fireDataChangedListener(objMap, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.all);
            }
        }
        catch (PersistenceException e) {
            PersistenceManager.handleDBExceptionForMasterSession(null, e);
        }
    }

    public String addMapping(IAUTMainPO aut, IComponentIdentifier componentIdentifier, String componentNameGuid) {
        Map<IComponentIdentifier, String> autObjectMap = this.m_objectMappings.get(aut);
        if (autObjectMap == null) {
            autObjectMap = new HashMap<IComponentIdentifier, String>();
            this.m_objectMappings.put(aut, autObjectMap);
        }
        if (!autObjectMap.containsKey(componentIdentifier)) {
            autObjectMap.put(componentIdentifier, componentNameGuid);
        }
        return autObjectMap.get(componentIdentifier);
    }

    public void clear() {
        this.m_objectMappings.clear();
    }
}

