/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.result;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.collections.ListUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.UINodeBP;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.CentralTestDataEditor;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.open.AbstractOpenHandler;
import org.eclipse.jubula.client.ui.rcp.views.AbstractJBTreeView;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class BasicSearchResult
implements ISearchResult {
    private List m_resultList = ListUtils.EMPTY_LIST;
    private ISearchQuery m_query;

    public BasicSearchResult(ISearchQuery query) {
        this.setQuery(query);
    }

    public void setQuery(ISearchQuery query) {
        this.m_query = query;
    }

    public ISearchQuery getQuery() {
        return this.m_query;
    }

    public void setResultList(List resultList) {
        this.m_resultList = resultList;
    }

    public List getResultList() {
        return this.m_resultList;
    }

    public void addListener(ISearchResultListener l) {
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getTooltip() {
        return "";
    }

    public void removeListener(ISearchResultListener l) {
    }

    public String getLabel() {
        return this.getQuery().getLabel();
    }

    public static interface ISearchResultElementAction<DATATYPE> {
        public void jumpTo(DATATYPE var1);

        public void openView(String var1);
    }

    public static class NodeSearchResultElementAction
    implements ISearchResultElementAction<Long> {
        @Override
        public void openView(String viewId) {
            Plugin.showView(viewId);
        }

        @Override
        public void jumpTo(Long id) {
            IEditorPart openEditor;
            AbstractJBTreeView jbtv = MultipleTCBTracker.getInstance().getMainTCB();
            if (jbtv == null) {
                jbtv = (AbstractJBTreeView)Plugin.showView("org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser");
            } else {
                Plugin.activate((IWorkbenchPart)jbtv);
            }
            TreeViewer tv = jbtv.getTreeViewer();
            EntityManager em = jbtv.getEntityManager();
            INodePO node = UINodeBP.selectNodeInTree(id, tv, em);
            if (node == null && (node = UINodeBP.selectNodeInTree(id, tv = (jbtv = (AbstractJBTreeView)Plugin.showView("org.eclipse.jubula.client.ui.rcp.views.TestSuiteBrowser")).getTreeViewer(), em)) == null) {
                node = (INodePO)em.find(NodeMaker.getNodePOClass(), (Object)id);
            }
            INodePO specNode = null;
            if (node instanceof IExecTestCasePO || node instanceof IRefTestSuitePO || node instanceof ICapPO || node instanceof IEventExecTestCasePO) {
                specNode = node.getParentNode();
            }
            if (node instanceof ISpecTestCasePO || node instanceof ITestSuitePO || node instanceof ITestJobPO) {
                specNode = node;
            }
            if ((openEditor = AbstractOpenHandler.openEditor((IPersistentObject)specNode)) instanceof AbstractJBEditor) {
                AbstractJBEditor jbEditor = (AbstractJBEditor)openEditor;
                jbEditor.setSelection((ISelection)new StructuredSelection((Object)node));
            }
        }
    }

    public static class ObjectMappingSearchResultElementAction
    implements ISearchResultElementAction<Long> {
        @Override
        public void openView(String viewId) {
        }

        @Override
        public void jumpTo(Long id) {
            for (IAUTMainPO aut : GeneralStorage.getInstance().getProject().getAutMainList()) {
                for (IObjectMappingAssoziationPO assoc : aut.getObjMap().getMappings()) {
                    ObjectMappingMultiPageEditor omEditor;
                    IObjectMappingAssoziationPO editorAssoc;
                    if (!id.equals(assoc.getId())) continue;
                    IEditorPart editor = AbstractOpenHandler.openEditor((IPersistentObject)aut);
                    if (editor instanceof ObjectMappingMultiPageEditor && (editorAssoc = this.getAssocForId((omEditor = (ObjectMappingMultiPageEditor)editor).getAut(), id)) != null) {
                        TreeViewer[] treeViewerArray = omEditor.getTreeViewers();
                        int n = treeViewerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeViewer viewer = treeViewerArray[n2];
                            viewer.reveal((Object)editorAssoc);
                            viewer.setSelection((ISelection)new StructuredSelection((Object)editorAssoc));
                            ++n2;
                        }
                    }
                    return;
                }
            }
        }

        private IObjectMappingAssoziationPO getAssocForId(IAUTMainPO aut, Long id) {
            for (IObjectMappingAssoziationPO editorAssoc : aut.getObjMap().getMappings()) {
                if (!id.equals(editorAssoc.getId())) continue;
                return editorAssoc;
            }
            return null;
        }
    }

    public static class SearchResultElement<DATATYPE> {
        private String m_name;
        private DATATYPE m_data;
        private Image m_image;
        private ISearchResultElementAction<DATATYPE> m_action;
        private String m_comment;
        private String m_viewId;

        public SearchResultElement(String name, DATATYPE data, Image image, ISearchResultElementAction<DATATYPE> action, String comment) {
            this(name, data, image, action, comment, null);
        }

        public SearchResultElement(String name, DATATYPE data, Image image, ISearchResultElementAction<DATATYPE> action, String comment, String viewId) {
            this.m_name = name;
            this.m_data = data;
            this.m_image = image;
            this.m_action = action;
            this.m_comment = comment;
            this.m_viewId = viewId;
        }

        public SearchResultElement(String name, DATATYPE data, Image image, ISearchResultElementAction<DATATYPE> action) {
            this(name, data, image, action, null);
        }

        public String getName() {
            return this.m_name;
        }

        public DATATYPE getData() {
            return this.m_data;
        }

        public Image getImage() {
            return this.m_image;
        }

        public String getComment() {
            return this.m_comment;
        }

        public void jumpToResult() {
            if (this.getViewId() != null) {
                this.m_action.openView(this.getViewId());
            }
            this.m_action.jumpTo(this.getData());
        }

        private String getViewId() {
            return this.m_viewId;
        }
    }

    public static class TestDataCubeSearchResultElementAction
    implements ISearchResultElementAction<Long> {
        @Override
        public void openView(String viewId) {
            Plugin.showView(viewId);
        }

        @Override
        public void jumpTo(Long id) {
            IProjectPO activeProject = GeneralStorage.getInstance().getProject();
            ITestDataCubePO[] iTestDataCubePOArray = TestDataCubeBP.getAllTestDataCubesFor((IProjectPO)activeProject);
            int n = iTestDataCubePOArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITestDataCubePO testdatacube = iTestDataCubePOArray[n2];
                if (id.equals(testdatacube.getId())) {
                    IEditorPart editor = AbstractOpenHandler.openEditor((IPersistentObject)activeProject.getTestDataCubeCont());
                    if (editor instanceof CentralTestDataEditor) {
                        CentralTestDataEditor ctdEditor = (CentralTestDataEditor)editor;
                        ctdEditor.getTreeViewer().setSelection((ISelection)new StructuredSelection(ctdEditor.getEditorHelper().getEditSupport().getSession().find(testdatacube.getClass(), (Object)id)));
                    }
                    return;
                }
                ++n2;
            }
        }
    }
}

