/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester;

import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.AbstractApplicationTester;
import org.eclipse.jubula.rc.common.util.KeyStrokeUtil;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.rc.javafx.components.CurrentStages;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.driver.RobotJavaFXImpl;
import org.eclipse.jubula.rc.javafx.listener.ComponentHandler;
import org.eclipse.jubula.rc.javafx.util.Rounding;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;

public class JavaFXApplicationTester
extends AbstractApplicationTester {
    private static AutServerLogger log = new AutServerLogger(JavaFXApplicationTester.class);

    public JavaFXApplicationTester() {
        RobotJavaFXImpl robot = (RobotJavaFXImpl)this.getRobot();
        Stage focusStage = CurrentStages.getfocusStage();
        robot.getInterceptor().addSceneGraph((ReadOnlyObjectProperty<? extends Window>)focusStage.getScene().windowProperty());
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }

    public Rectangle getActiveWindowBounds() {
        Stage window = CurrentStages.getfocusStage();
        Rectangle rec = new Rectangle(Rounding.round(window.getX()), Rounding.round(window.getY()), Rounding.round(window.getWidth()), Rounding.round(window.getHeight()));
        return rec;
    }

    protected IRobot getRobot() {
        return AUTServer.getInstance().getRobot();
    }

    public void rcKeyStroke(String modifierSpec, String keySpec) {
        if (keySpec == null || keySpec.trim().length() == 0) {
            throw new StepExecutionException("The base key of the key stroke must not be null or empty", EventFactory.createActionError());
        }
        String key = keySpec.trim().toUpperCase();
        String mod = KeyStrokeUtil.getModifierString((String)modifierSpec);
        if (mod.length() > 0) {
            this.getRobot().keyStroke(String.valueOf(mod.toString()) + " " + key);
        } else {
            int code = this.getKeyCode(key);
            if (code != -1) {
                this.rcKeyType(code);
            } else {
                this.getRobot().keyStroke(key);
            }
        }
    }

    protected Object getFocusOwner() {
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getFocusOwner", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Stage s = (Stage)JavaFXApplicationTester.this.getActiveWindow();
                return s.getScene().getFocusOwner();
            }
        });
        return result;
    }

    protected int getEventCode(int key) {
        int event = 0;
        switch (key) {
            case 1: {
                event = 144;
                break;
            }
            case 2: {
                event = 20;
                break;
            }
            case 3: {
                event = 145;
                break;
            }
        }
        return event;
    }

    protected Object getActiveWindow() {
        return CurrentStages.getfocusStage();
    }

    public int getKeyCode(String keyCodeName) throws StepExecutionException {
        int code;
        block5: {
            code = -1;
            String codeName = "VK_" + keyCodeName;
            try {
                code = KeyEvent.class.getField(codeName).getInt(KeyEvent.class);
            }
            catch (IllegalArgumentException e) {
                throw new StepExecutionException(e.getMessage(), EventFactory.createActionError());
            }
            catch (SecurityException e) {
                throw new StepExecutionException(e.getMessage(), EventFactory.createActionError());
            }
            catch (IllegalAccessException e) {
                throw new StepExecutionException(e.getMessage(), EventFactory.createActionError());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (!log.isInfoEnabled()) break block5;
                log.info((Object)("The key expression '" + keyCodeName + "' is not a key code, typed as key stroke instead"));
            }
        }
        return code;
    }

    public void rcCheckExistenceOfWindow(String title, String operator, boolean exists) {
        Verifier.equals((boolean)exists, (boolean)this.isStageInHierarchy(title, operator));
    }

    private boolean isStageInHierarchy(final String title, final String operator) {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isWindowInHierarchy", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Stage stage = JavaFXApplicationTester.this.getStageByTitle(title, operator);
                if (stage != null) {
                    return true;
                }
                return false;
            }
        });
        return result;
    }

    private Stage getStageByTitle(final String title, final String operator) {
        Stage result = EventThreadQueuerJavaFXImpl.invokeAndWait("getStageByTitle", new Callable<Stage>(){

            @Override
            public Stage call() throws Exception {
                List<Stage> stages = ComponentHandler.getAssignableFrom(Stage.class);
                for (Stage stage : stages) {
                    if (!MatchUtil.getInstance().match(stage.getTitle(), title, operator)) continue;
                    return stage;
                }
                return null;
            }
        });
        return result;
    }

    public void rcWaitForWindow(String title, String operator, int pTimeout, int delay) {
        final Stage s = this.getStageByTitle(title, operator);
        if (s == null) {
            log.error((Object)("no Window found! In rcWaitForWindowActivation. Title: " + title + "operator: " + operator));
            throw new StepExecutionException("no Window found!", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        final CountDownLatch signal = new CountDownLatch(1);
        EventHandler<WindowEvent> showHandler = new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                signal.countDown();
            }
        };
        boolean isShowing = EventThreadQueuerJavaFXImpl.invokeAndWait("rcWaitForWindow", new Callable<Boolean>((EventHandler)showHandler){
            private final /* synthetic */ EventHandler val$showHandler;
            {
                this.val$showHandler = eventHandler;
            }

            @Override
            public Boolean call() throws Exception {
                if (!s.isShowing()) {
                    s.addEventFilter(WindowEvent.WINDOW_SHOWN, this.val$showHandler);
                    return false;
                }
                return true;
            }
        });
        if (!isShowing) {
            try {
                try {
                    signal.await(pTimeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    throw new StepExecutionException("Interrupted while waiting for window!", EventFactory.createActionError((String)"TestErrorEvent.ExecutionError"));
                }
            }
            finally {
                s.removeEventFilter(WindowEvent.WINDOW_SHOWN, (EventHandler)showHandler);
            }
            boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("rcWaitForWindowConfirm", new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return s.isShowing();
                }
            });
            if (!result) {
                throw new StepExecutionException("window did not open", EventFactory.createActionError((String)"TestErrorEvent.TimeoutExpired"));
            }
        }
        TimeUtil.delay((long)delay);
    }

    public void rcWaitForWindowActivation(String title, String operator, int pTimeout, int delay) {
        final Stage s = this.getStageByTitle(title, operator);
        if (s == null) {
            log.error((Object)("no Window found! In rcWaitForWindowActivation. Title: " + title + "operator: " + operator));
            throw new StepExecutionException("no Window found!", EventFactory.createActionError((String)"TestErrorEvent.ExecutionError"));
        }
        final CountDownLatch signal = new CountDownLatch(1);
        ChangeListener<Boolean> focusListener = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    signal.countDown();
                }
            }
        };
        boolean isFocused = EventThreadQueuerJavaFXImpl.invokeAndWait("rcWaitForWindowActivation", new Callable<Boolean>((ChangeListener)focusListener){
            private final /* synthetic */ ChangeListener val$focusListener;
            {
                this.val$focusListener = changeListener;
            }

            @Override
            public Boolean call() throws Exception {
                if (!s.isFocused()) {
                    s.focusedProperty().addListener(this.val$focusListener);
                    return false;
                }
                return true;
            }
        });
        if (isFocused) {
            try {
                try {
                    signal.await(pTimeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    throw new StepExecutionException("Interrupted while waiting for window activation!", EventFactory.createActionError((String)"TestErrorEvent.ExecutionError"));
                }
            }
            finally {
                s.focusedProperty().removeListener((ChangeListener)focusListener);
            }
            boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("rcWaitForWindowActivationConfirm", new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return s.isFocused();
                }
            });
            if (!result) {
                throw new StepExecutionException("window was not activated", EventFactory.createActionError((String)"TestErrorEvent.TimeoutExpired"));
            }
        }
        TimeUtil.delay((long)delay);
    }

    public void rcWaitForWindowToClose(final String title, final String operator, int pTimeout, int delay) {
        final Stage s = this.getStageByTitle(title, operator);
        if (s == null) {
            return;
        }
        final CountDownLatch signal = new CountDownLatch(1);
        EventHandler<WindowEvent> closeHandler = new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                signal.countDown();
            }
        };
        boolean isClosing = EventThreadQueuerJavaFXImpl.invokeAndWait("rcWaitForWindowToClose", new Callable<Boolean>((EventHandler)closeHandler){
            private final /* synthetic */ EventHandler val$closeHandler;
            {
                this.val$closeHandler = eventHandler;
            }

            @Override
            public Boolean call() throws Exception {
                s.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, this.val$closeHandler);
                return false;
            }
        });
        if (isClosing) {
            try {
                try {
                    signal.await(pTimeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    throw new StepExecutionException("Interrupted while waiting for window closing!", EventFactory.createActionError((String)"TestErrorEvent.ExecutionError"));
                }
            }
            finally {
                s.removeEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, (EventHandler)closeHandler);
            }
            boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("rcWaitForWindowToCloseConfirm", new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    Stage tmpS = JavaFXApplicationTester.this.getStageByTitle(title, operator);
                    if (tmpS == null) {
                        return true;
                    }
                    return false;
                }
            });
            if (!result) {
                throw new StepExecutionException("window was not closed", EventFactory.createActionError((String)"TestErrorEvent.TimeoutExpired"));
            }
        }
        TimeUtil.delay((long)delay);
    }

    public void rcSyncShutdownAndRestart(int timeout) {
        StepExecutionException.throwUnsupportedAction();
    }

    public void rcPrepareForShutdown() {
        StepExecutionException.throwUnsupportedAction();
    }
}

