/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.html.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the {@link html.forms.Anchor} component from the html toolkit.
 */
@RealizedType(realizedType="guidancer.abstract.TextVerifiable")
@TesterClass(testerClass="com.bredexsw.jubula.rc.html.web.implclasses.forms.AnchorImplClass")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2015-03-25T11:22:43.470Z")
public class Anchor extends org.eclipse.jubula.toolkit.base.internal.impl.TextComponent implements org.eclipse.jubula.toolkit.html.components.Anchor {
            public Anchor(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkURL(
            @NonNull String text,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyURL"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
} 