/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.html.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the Locator component from the html toolkit.
 */
@TesterClass(testerClass="com.bredexsw.jubula.rc.html.web.implclasses.LocatorImplClass")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2015-03-25T11:22:43.478Z")
public class Locator implements org.eclipse.jubula.toolkit.html.components.Locator {
            public Locator() {
                super();
            }
    
    protected IComponentIdentifier getPseudoComponentIdentifier() {
        org.eclipse.jubula.tools.internal.objects.ComponentIdentifier pseudoIdentifier =
            new org.eclipse.jubula.tools.internal.objects.ComponentIdentifier();
        pseudoIdentifier.setComponentClassName("html.generic.Locator"); //$NON-NLS-1$
        return pseudoIdentifier;
    }
    
        /**
         * 
         * @param xPath 
         *        the XPath to use
         * @param comparisonMethod 
         *        the comparison method
         * @param count 
         *        the expected count
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkXPathCount(
            @NonNull String xPath,
            @NonNull String comparisonMethod,
            @NonNull Integer count
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcCheckXPathCount"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(xPath, "Argument 'xPath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(xPath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(comparisonMethod, "Argument 'comparisonMethod' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(comparisonMethod), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(count, "Argument 'count' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(count), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param cSSPath 
         *        the CSS path to use
         * @param comparisonMethod 
         *        the comparison method
         * @param count 
         *        the expected count
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkCSSPathCount(
            @NonNull String cSSPath,
            @NonNull String comparisonMethod,
            @NonNull Integer count
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcCheckCSSPathCount"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(cSSPath, "Argument 'cSSPath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(cSSPath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(comparisonMethod, "Argument 'comparisonMethod' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(comparisonMethod), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(count, "Argument 'count' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(count), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param locator 
         *        the locator to use
         * @param operator 
         *        the operator used for comparison
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkText(
            @NonNull String locator,
            @NonNull Operator operator,
            @NonNull String text
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcCheckText"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(locator, "Argument 'locator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(locator), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param locator 
         *        the locator to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP click(
            @NonNull String locator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcClick"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(locator, "Argument 'locator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(locator), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param locator 
         *        the locator to use
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP waitForComponent(
            @NonNull String locator,
            @NonNull Integer timeoutInMs,
            @NonNull Integer delayAfterVisibility
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcWaitForComponent"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(locator, "Argument 'locator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(locator), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(timeoutInMs), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(delayAfterVisibility, "Argument 'delayAfterVisibility' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(delayAfterVisibility), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
} 