/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.api.ui.handlers;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.api.ui.utils.OMExport;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.LogicComponentNotManagedException;
import org.eclipse.jubula.client.core.utils.ObjectMappingUtil;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.toolkit.client.api.ui.internal.OMClassGenerator;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.objects.ComponentIdentifier;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportObjectMappingHandler
extends AbstractHandler {
    private Map<String, String> m_map = new TreeMap<String, String>();
    private IComponentNameMapper m_compMapper;
    private OMClassGenerator m_omClassGenerator = new OMClassGenerator();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeImpl(ExecutionEvent event) {
        this.m_map.clear();
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(activePart instanceof ObjectMappingMultiPageEditor)) return null;
        ObjectMappingMultiPageEditor omEditor = (ObjectMappingMultiPageEditor)activePart;
        IAUTMainPO aut = omEditor.getAut();
        int exportType = this.determineExportType();
        if (exportType == -1) return null;
        FileDialog saveDialog = this.createSaveDialog(aut, exportType);
        String path = saveDialog.open();
        if (path == null) return null;
        Utils.storeLastDirPath((String)saveDialog.getFilterPath());
        this.fillMap(omEditor, aut);
        OMExport omAssociations = new OMExport(this.m_map, saveDialog.getFileName());
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(path));){
                switch (exportType) {
                    case 0: {
                        writer.append(this.m_omClassGenerator.generate(omAssociations));
                        return null;
                    }
                    case 1: {
                        writer.append(omAssociations.createEncodedAssociations());
                        return null;
                    }
                }
                return null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            ErrorHandlingUtil.createMessageDialog((JBException)new JBException(e.getMessage(), (Throwable)e, MessageIDs.E_FILE_NO_PERMISSION));
        }
        return null;
    }

    private void fillMap(ObjectMappingMultiPageEditor omEditor, IAUTMainPO aut) {
        this.m_compMapper = omEditor.getEditorHelper().getEditSupport().getCompMapper();
        IObjectMappingPO objMap = aut.getObjMap();
        IStructuredSelection selection = (IStructuredSelection)omEditor.getTreeViewer().getSelection();
        try {
            if (selection.isEmpty()) {
                IObjectMappingCategoryPO rootCategory = objMap.getMappedCategory();
                this.writeAssociationsToMap(rootCategory);
            } else {
                for (IPersistentObject next : selection) {
                    if (next instanceof IObjectMappingCategoryPO) {
                        this.writeAssociationsToMap((IObjectMappingCategoryPO)next);
                        continue;
                    }
                    if (!(next instanceof IObjectMappingAssoziationPO)) continue;
                    this.addAssoziationToMap((IObjectMappingAssoziationPO)next);
                }
            }
        }
        catch (IOException | LogicComponentNotManagedException e) {
            ErrorHandlingUtil.createMessageDialog((JBException)new JBException(e.getMessage(), e, MessageIDs.E_EXPORT_OM_ERROR));
        }
    }

    private FileDialog createSaveDialog(IAUTMainPO aut, int exportType) {
        String fileName = "";
        String fileExtension = "";
        switch (exportType) {
            case 0: {
                fileExtension = ".java";
                fileName = "OM" + fileExtension;
                break;
            }
            case 1: {
                fileExtension = ".properties";
                fileName = "objectMapping_" + aut.getName() + fileExtension;
                break;
            }
        }
        FileDialog saveDialog = new FileDialog(this.getActiveShell(), 8192);
        saveDialog.setFileName(fileName);
        saveDialog.setFilterExtensions(new String[]{"*" + fileExtension});
        saveDialog.setOverwrite(true);
        String filterPath = Utils.getLastDirPath();
        saveDialog.setFilterPath(filterPath);
        return saveDialog;
    }

    private int determineExportType() {
        String dialogTitle = Messages.ExportObjectMappingDialogTitle;
        String dialogMessage = Messages.ExportObjectMappingDialogMessage;
        MessageDialog dialog = new MessageDialog(this.getActiveShell(), dialogTitle, null, dialogMessage, 3, new String[]{Messages.ExportObjectMappingDialogChoiceJavaClass, Messages.ExportObjectMappingDialogChoicePropertiesFile}, 0);
        return dialog.open();
    }

    private void writeAssociationsToMap(IObjectMappingCategoryPO category) throws LogicComponentNotManagedException, IOException {
        List subcategoryList = category.getUnmodifiableCategoryList();
        if (!subcategoryList.isEmpty()) {
            for (IObjectMappingCategoryPO subcategory : subcategoryList) {
                this.writeAssociationsToMap(subcategory);
            }
        }
        for (IObjectMappingAssoziationPO assoziation : category.getUnmodifiableAssociationList()) {
            this.addAssoziationToMap(assoziation);
        }
    }

    private void addAssoziationToMap(IObjectMappingAssoziationPO assoziation) throws IOException {
        for (String compUUID : assoziation.getLogicalNames()) {
            String compName = this.m_compMapper.getCompNameCache().getName(compUUID);
            ComponentIdentifier identifier = (ComponentIdentifier)ObjectMappingUtil.createCompIdentifierFromAssoziation((IObjectMappingAssoziationPO)assoziation);
            this.m_map.put(compName, OMExport.getSerialization(identifier));
        }
    }
}

