/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.model.AbstractTestResult;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.tools.internal.objects.IMonitoringValue;

public class TestResult
extends AbstractTestResult {
    private String m_monitoringId;
    private Map<String, IMonitoringValue> m_monitoringValues;
    private byte[] m_reportData;
    private boolean m_reportWritten;
    private Map<String, String> m_autConfigMap;
    private IProjectPO m_project;

    public TestResult(TestResultNode rootResultNode, Map<String, String> autConfigMap) {
        super(rootResultNode);
        this.setProject(GeneralStorage.getInstance().getProject());
        this.setAutConfigMap(autConfigMap);
    }

    @Override
    public String getAutAgentHostName() {
        return MapUtils.getString(this.getAutConfigMap(), (Object)"SERVER", (String)"");
    }

    @Override
    public String getAutArguments() {
        return MapUtils.getString(this.getAutConfigMap(), (Object)"AUT_ARGUMENTS", (String)"");
    }

    @Override
    public String getAutConfigName() {
        return MapUtils.getString(this.getAutConfigMap(), (Object)"CONFIG_NAME", (String)"autrun");
    }

    public String getAutId() {
        return MapUtils.getString(this.getAutConfigMap(), (Object)"AUT_ID", (String)"autrun");
    }

    @Override
    public Date getEndTime() {
        return ClientTest.instance().getEndTime();
    }

    @Override
    public int getExpectedNumberOfSteps() {
        return TestExecution.getInstance().getExpectedNumberOfSteps();
    }

    @Override
    public int getNumberOfEventHandlerSteps() {
        return TestExecution.getInstance().getNumberOfEventHandlerSteps() + TestExecution.getInstance().getNumberOfRetriedSteps();
    }

    @Override
    public int getNumberOfFailedSteps() {
        return TestExecution.getInstance().getNumberOfFailedSteps();
    }

    @Override
    public int getNumberOfTestedSteps() {
        return TestExecution.getInstance().getNumberOfTestedSteps();
    }

    @Override
    public String getProjectGuid() {
        return this.getProject().getGuid();
    }

    @Override
    public long getProjectId() {
        return this.getProject().getId();
    }

    @Override
    public Integer getProjectMajorVersion() {
        return this.getProject().getMajorProjectVersion();
    }

    @Override
    public Integer getProjectMinorVersion() {
        return this.getProject().getMinorProjectVersion();
    }

    @Override
    public String getProjectName() {
        return this.getProject().getName();
    }

    @Override
    public Date getStartTime() {
        return ClientTest.instance().getTestsuiteStartTime();
    }

    @Override
    public String getTestLanguage() {
        Locale testLocale = TestExecution.getInstance().getLocale();
        return testLocale != null ? testLocale.getDisplayName() : "";
    }

    public String getMonitoringId() {
        return this.m_monitoringId;
    }

    public Map<String, IMonitoringValue> getMonitoringValues() {
        return this.m_monitoringValues;
    }

    public void setMonitoringValues(Map<String, IMonitoringValue> monitoringValues) {
        this.m_monitoringValues = monitoringValues;
    }

    public void setMonitoringId(String monitoringId) {
        this.m_monitoringId = monitoringId;
    }

    public byte[] getReportData() {
        return this.m_reportData;
    }

    public void setReportData(byte[] reportData) {
        this.m_reportData = reportData;
    }

    public boolean isReportWritten() {
        return this.m_reportWritten;
    }

    public void setReportWritten(boolean reportWritten) {
        this.m_reportWritten = reportWritten;
    }

    private void setAutConfigMap(Map<String, String> autConfigMap) {
        this.m_autConfigMap = autConfigMap;
    }

    public Map<String, String> getAutConfigMap() {
        return this.m_autConfigMap;
    }

    public IProjectPO getProject() {
        return this.m_project;
    }

    private void setProject(IProjectPO project) {
        this.m_project = project;
    }

    @Override
    public Integer getProjectMicroVersion() {
        return this.m_project.getMicroProjectVersion();
    }

    @Override
    public String getProjectVersionQualifier() {
        return this.m_project.getProjectVersionQualifier();
    }
}

