/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.sourceprovider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.sourceprovider.AbstractJBSourceProvider;
import org.eclipse.jubula.tools.internal.exception.Assert;

public class ObjectMappingModeSourceProvider
extends AbstractJBSourceProvider
implements DataEventDispatcher.IOMStateListener,
DataEventDispatcher.IAutStateListener,
DataEventDispatcher.IRecordModeStateListener {
    public static final String ID = "org.eclipse.jubula.client.ui.rcp.sourceprovider.ObjectMappingModeSourceProvider";
    public static final String IS_OBJECT_MAPPING_RUNNING = "org.eclipse.jubula.client.ui.rcp.variable.isObjectMappingRunning";
    private boolean m_isOMRunning = false;

    public ObjectMappingModeSourceProvider() {
        DataEventDispatcher dispatch = DataEventDispatcher.getInstance();
        dispatch.addOMStateListener((DataEventDispatcher.IOMStateListener)this, true);
        dispatch.addAutStateListener((DataEventDispatcher.IAutStateListener)this, true);
        dispatch.addRecordModeStateListener((DataEventDispatcher.IRecordModeStateListener)this, true);
    }

    public void handleOMStateChanged(DataEventDispatcher.OMState state) {
        this.m_isOMRunning = state == DataEventDispatcher.OMState.running;
        this.fireModeChanged();
    }

    public void handleAutStateChanged(DataEventDispatcher.AutState state) {
        switch (state) {
            case running: {
                break;
            }
            case notRunning: {
                this.m_isOMRunning = false;
                break;
            }
            default: {
                Assert.notReached((String)Messages.UnhandledAutState);
            }
        }
        this.fireModeChanged();
    }

    public void handleRecordModeStateChanged(DataEventDispatcher.RecordModeState state) {
        switch (state) {
            case running: {
                this.m_isOMRunning = false;
                break;
            }
            case notRunning: {
                break;
            }
            default: {
                Assert.notReached((String)Messages.UnsupportedRecordModeState);
            }
        }
        this.fireModeChanged();
    }

    private void fireModeChanged() {
        this.gdFireSourceChanged(0, IS_OBJECT_MAPPING_RUNNING, this.isRunning());
    }

    public boolean isRunning() {
        return this.m_isOMRunning;
    }

    public void dispose() {
        DataEventDispatcher dispatch = DataEventDispatcher.getInstance();
        dispatch.removeOMStateListener((DataEventDispatcher.IOMStateListener)this);
        dispatch.removeAutStateListener((DataEventDispatcher.IAutStateListener)this);
        dispatch.removeRecordModeStateListener((DataEventDispatcher.IRecordModeStateListener)this);
    }

    public Map<String, Object> getCurrentState() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(IS_OBJECT_MAPPING_RUNNING, this.isRunning());
        return values;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{IS_OBJECT_MAPPING_RUNNING};
    }
}

