/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jubula.tools.internal.exception.Assert;

public class TDVariableStore {
    public static final String USERDEF_ENV_VAR_PREFIX = "TEST_UDV_";
    public static final String PREDEF_VAR_PREFIX = "TEST_";
    public static final String VAR_LANG = "TEST_LANGUAGE";
    public static final String VAR_TS = "TEST_TESTSUITE";
    public static final String VAR_USERNAME = "TEST_USERNAME";
    public static final String VAR_DBUSERNAME = "TEST_DBUSERNAME";
    public static final String VAR_AUTAGENT = "TEST_AUTAGENT";
    public static final String VAR_PORT = "TEST_PORTNUMBER";
    public static final String VAR_AUT = "TEST_AUT";
    public static final String VAR_AUTCONFIG = "TEST_AUTCONFIG";
    public static final String VAR_CLIENTVERSION = "TEST_CLIENTVERSION";
    private Map<String, String> m_variables = new HashMap<String, String>();

    public void store(String varName, String value) {
        this.m_variables.put(varName, value);
    }

    public String getValue(String varName) {
        return this.m_variables.get(varName);
    }

    public void clear() {
        this.m_variables.clear();
    }

    public void storeEnvironmentVariables() {
        Properties vars = System.getenv();
        this.storeEnvVars(vars);
        vars = System.getProperties();
        this.storeEnvVars(vars);
    }

    private void storeEnvVars(Map<? extends Object, ? extends Object> map) {
        Set<? extends Object> keys = map.keySet();
        for (Object object : keys) {
            Assert.verify((boolean)(object instanceof String), (String)("Key: '" + String.valueOf(object) + "' is not a String"));
            String key = (String)object;
            if (!key.startsWith(USERDEF_ENV_VAR_PREFIX)) continue;
            String value = System.getenv(key);
            if (value == null) {
                value = System.getProperty(key);
            }
            String varName = key.substring(USERDEF_ENV_VAR_PREFIX.length());
            this.store(varName, value);
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + this.m_variables.toString();
    }
}

