/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers;

import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;

public abstract class AbstractComponentNameViewerUpdater
implements DataEventDispatcher.IDataChangedListener {
    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState());
            ++n2;
        }
    }

    public final void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState) {
        if (po instanceof IComponentNamePO) {
            IComponentNamePO compName = (IComponentNamePO)po;
            switch (dataState) {
                case Deleted: {
                    this.remove(compName);
                    break;
                }
                case Renamed: {
                    this.update(compName, null);
                    break;
                }
                case Added: {
                    this.refresh();
                    break;
                }
            }
        } else if (po instanceof IObjectMappingPO) {
            switch (dataState) {
                case StructureModified: {
                    this.refresh();
                }
            }
        }
    }

    protected abstract void refresh();

    protected abstract void update(IComponentNamePO var1, String[] var2);

    protected abstract void remove(IComponentNamePO var1);
}

