/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers;

import java.net.InetAddress;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.IClientTest;
import org.eclipse.jubula.client.core.businessprocess.ITestExecutionEventListener;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.businessprocess.TestExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.commands.AUTModeChangedCommand;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.core.constants.TestExecutionConstants;
import org.eclipse.jubula.client.core.events.AUTEvent;
import org.eclipse.jubula.client.core.events.AUTServerEvent;
import org.eclipse.jubula.client.core.events.AutAgentEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.events.IAUTEventListener;
import org.eclipse.jubula.client.core.events.IAUTServerEventListener;
import org.eclipse.jubula.client.core.events.IServerEventListener;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.controllers.jobs.StartAutJob;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.OMEditorTreeLabelProvider;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.JobUtils;
import org.eclipse.jubula.tools.internal.constants.EnvConstants;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExecutionContributor
implements IAUTEventListener,
IServerEventListener,
IAUTServerEventListener,
ITestExecutionEventListener {
    private static TestExecutionContributor instance;
    private static Logger log;
    private IClientTest m_clientTest;
    private String m_server = "";
    private String m_port = "";

    static {
        log = LoggerFactory.getLogger(TestExecutionContributor.class);
    }

    private TestExecutionContributor() {
        this.setClientTest(ClientTest.instance());
        this.registerAsListener();
    }

    private void registerAsListener() {
        IClientTest clientTest = ClientTest.instance();
        clientTest.addTestEventListener((IAUTEventListener)this);
        clientTest.addAutAgentEventListener((IServerEventListener)this);
        clientTest.addAUTServerEventListener((IAUTServerEventListener)this);
        clientTest.addTestExecutionEventListener((ITestExecutionEventListener)this);
    }

    private void deregister() {
        IClientTest clientTest = ClientTest.instance();
        clientTest.removeTestEventListener((IAUTEventListener)this);
        clientTest.removeAutAgentEventListener((IServerEventListener)this);
        clientTest.removeAUTServerEventListener((IAUTServerEventListener)this);
        clientTest.removeTestExecutionEventListener((ITestExecutionEventListener)this);
    }

    public void dispose() {
        this.deregister();
        this.setClientTest(null);
    }

    public void stateChanged(AUTEvent event) {
        this.handleEvent(event);
    }

    public void stateChanged(AutAgentEvent event) {
        this.handleEvent(event);
    }

    public void stateChanged(AUTServerEvent event) {
        this.handleEvent(event);
    }

    public void stateChanged(TestExecutionEvent event) {
        this.handleEvent(event);
    }

    public IClientTest getClientTest() {
        return this.m_clientTest;
    }

    public void setClientTest(IClientTest clientTest) {
        this.m_clientTest = clientTest;
    }

    void handleEvent(AUTEvent event) {
        log.info(String.valueOf(Messages.HandleAUTEvent) + ":" + " " + event.toString());
        String message = Plugin.getStatusLineText();
        String error = null;
        int icon = Plugin.isConnectionStatusIcon();
        switch (event.getState()) {
            case 1: {
                message = Messages.TestExecutionContributorAUTStartedTesting;
                icon = 3;
                this.fireAndSetAutState(true);
                AUTModeChangedCommand.setAutMode((int)1);
                break;
            }
            case 3: {
                this.fireAndSetAutState(false);
                break;
            }
            case 2: {
                message = Messages.TestExecutionContributorAUTStopped;
                icon = 1;
                this.fireAndSetAutState(false);
                break;
            }
            case 4: {
                error = Messages.TestExecutionContributorAUTNotFound;
                icon = 1;
                this.fireAndSetAutState(false);
                break;
            }
            case 5: {
                error = Messages.TestExecutionContributorMainClassNotFound;
                icon = 1;
                this.fireAndSetAutState(false);
                break;
            }
            case 7: {
                error = Messages.TestExecutionContributorClassVersionError;
                icon = 1;
                this.fireAndSetAutState(false);
                break;
            }
            case 6: {
                error = "";
                icon = 1;
                this.fireAndSetAutState(false);
                break;
            }
            case 8: {
                this.m_clientTest.addAUTServerEventListener((IAUTServerEventListener)this);
                this.fireAndSetAutState(true);
                break;
            }
            case 9: {
                this.m_clientTest.removeAUTServerEventListener((IAUTServerEventListener)this);
                break;
            }
            default: {
                Assert.notReached((String)(String.valueOf(Messages.UnknownAUTState) + String.valueOf(event.getState())));
            }
        }
        Plugin.showStatusLine(icon, message);
        if (error != null) {
            if ("".equals(error)) {
                error = null;
            }
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_AUT_START, null, (String[])error.split("\n"));
        }
    }

    private void fireAndSetAutState(boolean isAutRunning) {
        DataEventDispatcher.AutState state = isAutRunning ? DataEventDispatcher.AutState.running : DataEventDispatcher.AutState.notRunning;
        DataEventDispatcher.getInstance().fireAutStateChanged(state);
    }

    void handleEvent(AUTServerEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(Messages.HandleAUTServerEvent) + event.toString());
        }
        int icon = Plugin.isConnectionStatusIcon();
        String message = Plugin.getStatusLineText();
        String error = null;
        switch (event.getState()) {
            case 2: {
                message = this.getConnectionMessage(message);
                message = String.valueOf(message) + " " + ":" + " " + Messages.TestExecutionContributorConnAUTServClosed;
                icon = 1;
                this.setAutNotRunningState();
                break;
            }
            case 1: {
                message = Messages.TestExecutionContributorConnectedToAUTServer;
                icon = 2;
                break;
            }
            case 11: {
                error = Messages.TestExecutionContributorServerNotInstantiated;
                icon = 1;
                this.setAutNotRunningState();
                break;
            }
            case 12: {
                error = Messages.TestExecutionContributorDotNetInstallProblem;
                icon = 1;
                this.setAutNotRunningState();
                break;
            }
            case 13: {
                error = Messages.TestExecutionContributorUnrecognizedJavaAgent;
                icon = 1;
                this.setAutNotRunningState();
                break;
            }
            case 7: {
                error = Messages.TestExecutionContributorStartingJavaFailed;
                icon = 1;
                this.setAutNotRunningState();
                break;
            }
            case 3: {
                error = Messages.TestExecutionContributorOpeningConnAUTServerFailed;
                icon = 1;
                this.setAutNotRunningState();
                break;
            }
            case 4: {
                error = Messages.TestExecutionContributorCommunicationAUTServerFailed;
                icon = 1;
                this.setAutNotRunningState();
                break;
            }
            case 6: {
                error = Messages.TestExecutionContributorInvalidJar;
                icon = 1;
                this.setAutNotRunningState();
                break;
            }
            case 5: {
                error = Messages.TestExecutionContributorNoMainInJar;
                icon = 1;
                this.setAutNotRunningState();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                this.autServerModeChanged(event);
                return;
            }
            default: {
                this.setAutNotRunningState();
                log.error(String.valueOf(Messages.UnknownAUTServerState) + event.getState());
            }
        }
        this.showError(icon, message, error);
    }

    private void showError(int icon, String message, String error) {
        Plugin.showStatusLine(icon, message);
        if (error != null) {
            if ("".equals(error)) {
                this.showError(null);
            } else {
                this.showError(error);
            }
        }
    }

    private void showError(final String errorHolder) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_AUT_START, null, (String[])errorHolder.split("\n"));
            }
        });
    }

    private String getConnectionMessage(String message) {
        String msg = message;
        InetAddress localhost = EnvConstants.LOCALHOST;
        msg = NLS.bind((String)Messages.TestExecutionContributorConnectedToAUTAgent1, (Object[])new Object[]{this.m_server, this.m_port});
        if (Messages.StartAutBPLocalhost.equals(this.m_server.toLowerCase())) {
            msg = NLS.bind((String)Messages.TestExecutionContributorConnectedToAUTAgent2, (Object[])new Object[]{this.m_server, this.m_port});
        } else if (localhost != null && (this.m_server.equals(localhost.getHostName()) || this.m_server.equals(localhost.getHostAddress()) || this.m_server.equals(localhost.getCanonicalHostName()))) {
            msg = NLS.bind((String)Messages.TestExecutionContributorConnectedToAUTAgent3, (Object[])new Object[]{this.m_server, Messages.StartAutBPLocalhost, this.m_port});
        }
        return msg;
    }

    private void setAutNotRunningState() {
        DataEventDispatcher.getInstance().fireAutStateChanged(DataEventDispatcher.AutState.notRunning);
    }

    private void autServerModeChanged(AUTServerEvent e) {
        int icon = Plugin.isConnectionStatusIcon();
        String message = Plugin.getStatusLineText();
        switch (e.getState()) {
            case 8: {
                message = Messages.TestExecutionContributorAUTStartedTesting;
                icon = 3;
                break;
            }
            case 9: {
                String strCat;
                IObjectMappingCategoryPO cat = ObjectMappingEventDispatcher.getCategoryToCreateIn();
                if (cat != null) {
                    strCat = cat.getName();
                    if (OMEditorTreeLabelProvider.getTopLevelCategoryName(strCat) != null) {
                        strCat = OMEditorTreeLabelProvider.getTopLevelCategoryName(strCat);
                    }
                } else {
                    strCat = Messages.TestExecutionContributorCatUnassigned;
                }
                message = NLS.bind((String)Messages.TestExecutionContributorAUTStartedMapping, (Object)strCat);
                icon = 5;
                break;
            }
            case 10: {
                message = Messages.TestExecutionContributorAUTStartedRecording;
                icon = 4;
                break;
            }
            case 14: {
                message = Messages.TestExecutionContributorAUTStartedRecordingCheckMode;
                icon = 7;
                break;
            }
        }
        Plugin.showStatusLine(icon, message);
    }

    void handleEvent(AutAgentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(Messages.HandleAUTAgentEvent) + ":" + " " + event.toString());
        }
        String statusLineMessage = Plugin.getStatusLineText();
        Integer messageId = MessageIDs.E_SERVER_ERROR;
        String error = null;
        int icon = Plugin.isConnectionStatusIcon();
        switch (event.getState()) {
            case 2: {
                statusLineMessage = Messages.StatusLine_NotConnected;
                icon = 0;
                DataEventDispatcher.getInstance().fireAutAgentConnectionChanged(DataEventDispatcher.ServerState.Disconnected);
                break;
            }
            case 1: {
                statusLineMessage = this.getConnectionMessage(statusLineMessage);
                icon = 1;
                DataEventDispatcher.getInstance().fireAutAgentConnectionChanged(DataEventDispatcher.ServerState.Connected);
                break;
            }
            case 3: {
                error = Messages.InfoDetailConnectToAutAgentFailed;
                statusLineMessage = Messages.StatusLine_NotConnected;
                DataEventDispatcher.getInstance().fireAutAgentConnectionChanged(DataEventDispatcher.ServerState.Disconnected);
                messageId = MessageIDs.I_SERVER_CANNOT_CONNECTED;
                break;
            }
            case 4: {
                error = Messages.ErrorMessageVERSION_ERROR;
                statusLineMessage = Messages.StatusLine_NotConnected;
                DataEventDispatcher.getInstance().fireAutAgentConnectionChanged(DataEventDispatcher.ServerState.Disconnected);
                break;
            }
            default: {
                log.error(String.valueOf(Messages.UnknownAUTAgentState) + ":" + " " + String.valueOf(event.getState()));
            }
        }
        Plugin.showStatusLine(icon, statusLineMessage);
        if (error != null) {
            if ("".equals(error)) {
                error = null;
            }
            ErrorHandlingUtil.createMessageDialog((Integer)messageId, (Object[])new String[]{this.m_server, this.m_port}, (String[])error.split("\n"));
        }
    }

    void handleEvent(TestExecutionEvent event) {
        String message = Plugin.getStatusLineText();
        String error = null;
        int icon = Plugin.isConnectionStatusIcon();
        ICapPO cap = null;
        String testCaseName = null;
        String capName = null;
        switch (event.getState()) {
            case TEST_EXEC_STOP: {
                icon = 3;
                message = Messages.TestExecutionContributorSuiteStop;
                break;
            }
            case TEST_EXEC_FAILED: {
                error = this.getTestSuiteErrorText(event);
                message = Messages.TestExecutionContributorSuiteFailed;
                break;
            }
            case TEST_EXEC_START: {
                TestExecutionContributor.setClientMinimized(true);
                icon = 3;
                message = Messages.TestExecutionContributorSuiteRun;
                this.showTestResultTreeView();
                break;
            }
            case TEST_EXEC_RESULT_TREE_READY: {
                message = Messages.TestExecutionContributorSuiteRun;
                break;
            }
            case TEST_EXEC_FINISHED: {
                message = Messages.TestExecutionContributorSuiteFinished;
                icon = 3;
                break;
            }
            case TEST_EXEC_COMPONENT_FAILED: {
                cap = TestExecution.getInstance().getActualCap();
                String componentName = cap.getComponentName();
                testCaseName = cap.getParentNode().getName();
                capName = cap.getName();
                error = NLS.bind((String)Messages.TestExecutionContributorCompFailure, (Object[])new Object[]{componentName, testCaseName, capName});
                message = Messages.TestExecutionContributorSuiteFailed;
                break;
            }
            case TEST_EXEC_PAUSED: {
                TestExecutionContributor.setClientMinimized(false);
                icon = 6;
                message = Messages.TestExecutionContributorSuitePaused;
                break;
            }
            case TEST_RUN_INCOMPLETE_TESTDATA_ERROR: {
                TestExecutionContributor.setClientMinimized(false);
                error = this.getIncompleteTestRunMessage(TestExecutionEvent.State.TEST_RUN_INCOMPLETE_TESTDATA_ERROR);
                message = Messages.TestExecutionContributorSuiteFailed;
                break;
            }
            case TEST_RUN_INCOMPLETE_OBJECTMAPPING_ERROR: {
                TestExecutionContributor.setClientMinimized(false);
                error = this.getIncompleteTestRunMessage(TestExecutionEvent.State.TEST_RUN_INCOMPLETE_OBJECTMAPPING_ERROR);
                message = Messages.TestExecutionContributorSuiteFailed;
                break;
            }
            case TEST_EXEC_RESTART: {
                icon = 3;
                message = Messages.TestExecutionContributorSuiteRun;
                break;
            }
            default: {
                log.error(Messages.UnknownTestExecutionEvent);
                this.endTestExecution();
            }
        }
        this.showErrorAndStatus(event, message, error, icon);
    }

    private void showErrorAndStatus(TestExecutionEvent event, String message, String error, int icon) {
        DataEventDispatcher.getInstance().fireTestSuiteStateChanged(event);
        Plugin.showStatusLine(icon, message);
        if (error != null) {
            String[] errorDetail = error.split("\n");
            if ("".equals(error)) {
                errorDetail = null;
            }
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_TEST_EXECUTION_ERROR, null, (String[])errorDetail);
        }
    }

    private String getIncompleteTestRunMessage(TestExecutionEvent.State testExecEventID) {
        ICapPO cap = TestExecution.getInstance().getActualCap();
        String testCaseName = cap.getParentNode().getName();
        String capName = cap.getName();
        switch (testExecEventID) {
            case TEST_RUN_INCOMPLETE_TESTDATA_ERROR: {
                return NLS.bind((String)Messages.TestExecutionContributorTEST_RUN_INCOMPLETE_TESTDATA_ERROR, (Object[])new Object[]{testCaseName, capName});
            }
            case TEST_RUN_INCOMPLETE_OBJECTMAPPING_ERROR: {
                return NLS.bind((String)Messages.TestExecutionContributorRunIncompleteOMError, (Object[])new Object[]{testCaseName, capName});
            }
        }
        log.error(Messages.UnknownTestExecutionEvent);
        this.endTestExecution();
        return "";
    }

    public static void setClientMinimized(final boolean flag) {
        if (Plugin.getDefault().getPreferenceStore().getBoolean("MINIMIZEONSUITESTART_PREF_KEY")) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    boolean foundShell;
                    Shell shell = Plugin.getActiveWorkbenchWindowShell();
                    boolean bl = foundShell = shell != null;
                    if (!foundShell) {
                        shell = Plugin.getDisplay().getActiveShell();
                        boolean bl2 = foundShell = shell != null;
                    }
                    if (!foundShell) {
                        shell = Display.getDefault().getActiveShell();
                        boolean bl3 = foundShell = shell != null;
                    }
                    if (!foundShell) {
                        shell = Plugin.getShell();
                        foundShell = shell != null;
                    }
                    shell.setMinimized(flag);
                    if (shell.getMinimized() != flag) {
                        shell.setMaximized(!flag);
                    }
                }
            });
        }
    }

    private String getTestSuiteErrorText(TestExecutionEvent event) {
        if (event.getException() != null) {
            return event.getException().getMessage();
        }
        return Messages.TestExecutionContributorSuiteFailed;
    }

    private void showTestResultTreeView() {
        if (Plugin.getDefault().getPreferenceStore().getBoolean("OPENRESULTVIEW_PREF_KEY")) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        Plugin.getActivePage().showView("org.eclipse.jubula.client.ui.rcp.views.TestResultTreeView");
                    }
                    catch (PartInitException pie) {
                        log.error(Messages.TestResultTreeViewCouldNotInitialised, (Throwable)pie);
                    }
                    catch (NullPointerException npe) {
                        log.error(Messages.WindowIsNull, (Throwable)npe);
                    }
                }
            });
        }
    }

    public void startAUTaction(IAUTMainPO aut, IAUTConfigPO conf) {
        Validate.notNull((Object)conf, (String)Messages.ConfigurationMustNotNull);
        StartAutJob job = new StartAutJob(aut, conf);
        JobUtils.executeJob((Job)job, null);
    }

    public void connectToAutAgent(String autAgentHost, String port) {
        this.m_server = autAgentHost;
        this.m_port = port;
        this.getClientTest().connectToAutAgent(autAgentHost, port);
    }

    public void disconnectFromAutAgent() {
        this.getClientTest().disconnectFromAutAgent();
        this.m_server = "";
        this.m_port = "";
    }

    public void stopAUT(AutIdentifier autId) {
        this.fireAndSetAutState(false);
        ITestSuitePO startedTestSuite = TestExecution.getInstance().getStartedTestSuite();
        if (startedTestSuite != null && startedTestSuite.isStarted()) {
            this.stopTestSuiteAction();
        }
        this.getClientTest().stopAut(autId);
    }

    public void startTestSuiteAction(ITestSuitePO ts, AutIdentifier autId, boolean autoScreenshot) {
        TimeUtil.delay((long)2000L);
        this.getClientTest().startTestSuite(ts, WorkingLanguageBP.getInstance().getWorkingLanguage(), autId, autoScreenshot, null, TestExecutionConstants.RunSteps.NORMAL.getStepValue());
    }

    public void stopTestSuiteAction() {
        this.getClientTest().stopTestExecution();
    }

    public void pauseTestSuiteAction(TestExecution.PauseMode pm) {
        this.getClientTest().pauseTestExecution(pm);
    }

    public static TestExecutionContributor getInstance() {
        if (instance == null) {
            instance = new TestExecutionContributor();
        }
        return instance;
    }

    public void endTestExecution() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project == null) {
            return;
        }
        List tsList = TestSuiteBP.getListOfTestSuites((IProjectPO)project);
        for (ITestSuitePO ts : tsList) {
            ts.setStarted(false);
        }
        if (TestExecution.getInstance().getStartedTestSuite() != null) {
            TestExecution.getInstance().getStartedTestSuite().setStarted(false);
        }
        try {
            AUTConnection.getInstance().getCommunicator().interruptAllTimeouts();
        }
        catch (ConnectionException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        TestExecutionContributor.setClientMinimized(false);
    }
}

