/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.base.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the TextInputComponent component from the base toolkit.
 */
@RealizedType(realizedType="guidancer.abstract.TextVerifiable")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2015-05-19T12:42:30.701Z")
public class TextInputComponent extends org.eclipse.jubula.toolkit.base.internal.impl.TextComponent implements org.eclipse.jubula.toolkit.base.components.TextInputComponent {
            public TextInputComponent(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEditability(
            @NonNull Boolean editable
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcVerifyEditable"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(editable, "Argument 'editable' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(editable), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP replaceText(
            @NonNull String text
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcReplaceText"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP inputText(
            @NonNull String text
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcInputText"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(false);
            messageCap.setCi(m_componentIdentifier);
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
} 