/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.eclipse.jubula.autagent.agent.AutAgent;
import org.eclipse.jubula.autagent.remote.dialogs.ChooseCheckModeDialogBP;
import org.eclipse.jubula.autagent.remote.dialogs.ObservationConsoleBP;
import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.communication.internal.IConnectionInitializer;
import org.eclipse.jubula.communication.internal.listener.ICommunicationErrorListener;
import org.eclipse.jubula.communication.internal.message.AutRegisteredMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.StartAUTServerStateMessage;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.DevNull;
import org.eclipse.jubula.tools.internal.utils.IsAliveThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutStarter {
    private static Logger log = LoggerFactory.getLogger(AutStarter.class);
    private static AutStarter instance = null;
    private Communicator m_communicator;
    private Communicator m_autCommunicator;
    private int m_stopAUTServerTimeout = 10000;
    private AutAgent m_agent;
    private CommunicationHelper m_messenger;
    private Verbosity m_verbosity;

    private AutStarter() {
        AutAgent agent = new AutAgent();
        this.m_messenger = new CommunicationHelper();
        agent.addPropertyChangeListener("auts", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Communicator clientComm = AutStarter.getInstance().getCommunicator();
                if (clientComm == null || clientComm.getConnection() == null) {
                    return;
                }
                try {
                    Object oldValue;
                    Object newValue = evt.getNewValue();
                    if (newValue instanceof AutIdentifier) {
                        clientComm.send((Message)new AutRegisteredMessage((AutIdentifier)newValue, true));
                    }
                    if ((oldValue = evt.getOldValue()) instanceof AutIdentifier) {
                        clientComm.send((Message)new AutRegisteredMessage((AutIdentifier)oldValue, false));
                    }
                }
                catch (CommunicationException ce) {
                    log.error("Error occurred while sending AUT Registration Message.", (Throwable)ce);
                }
            }
        });
        this.m_agent = agent;
    }

    public boolean watchAutServer(Process process, boolean isAgentSet) throws IllegalArgumentException {
        if (process == null) {
            throw new IllegalArgumentException("process must not be null");
        }
        new AUTServerWatcher(process, isAgentSet, this.m_messenger).start();
        return true;
    }

    public static AutStarter getInstance() {
        if (instance == null) {
            instance = new AutStarter();
        }
        return instance;
    }

    public synchronized Communicator getCommunicator() {
        return this.m_communicator;
    }

    public synchronized void setCommunicator(Communicator communicator) {
        this.m_communicator = communicator;
    }

    public synchronized Communicator getAutCommunicator() {
        return this.m_autCommunicator;
    }

    public synchronized void setAutCommunicator(Communicator communicator) {
        this.m_autCommunicator = communicator;
    }

    public int getStopAUTServerTimeout() {
        return this.m_stopAUTServerTimeout;
    }

    public void setStopAUTServerTimeout(int stopAUTServerTimeout) {
        this.m_stopAUTServerTimeout = stopAUTServerTimeout < 0 ? 0 : stopAUTServerTimeout;
    }

    public void start(int port, boolean killDuplicateAuts, Verbosity verbosity, boolean isBlocking) throws UnknownHostException, IOException, JBVersionException {
        this.m_verbosity = verbosity;
        String infoMessage = I18n.getString((String)"AUTAgent.StartErrorText");
        Thread clientSocketThread = null;
        try {
            this.getAgent().setKillDuplicateAuts(killDuplicateAuts);
            infoMessage = I18n.getString((String)"AUTAgent.StartCommErrorText", (Object[])new Object[]{"" + port});
            clientSocketThread = this.initClientConnectionSocket(port);
            this.initAutConnectionSocket();
            infoMessage = this.m_verbosity.compareTo(Verbosity.VERBOSE) >= 0 ? String.valueOf(I18n.getString((String)"AUTAgent.StartSuccessText")) + this.getCommunicator().getLocalPort() + "." : "";
        }
        finally {
            if (infoMessage.length() > 0) {
                this.showUserInfo(infoMessage);
            }
            if (isBlocking && clientSocketThread != null) {
                try {
                    clientSocketThread.join();
                }
                catch (InterruptedException e) {
                    log.warn("Primary Thread was interrupted unexpectedly while waiting for client socket Thread to finish. Resuming execution of Primary Thread.", (Throwable)e);
                }
            }
        }
    }

    private Thread initClientConnectionSocket(int port) throws IOException, JBVersionException {
        HashMap<String, IConnectionInitializer> clientTypeToInitializer = new HashMap<String, IConnectionInitializer>();
        clientTypeToInitializer.putAll(this.m_agent.getConnectionInitializers());
        clientTypeToInitializer.put("ClientType.Command.ShutDown", new IConnectionInitializer(){

            public void initConnection(Socket socket, BufferedReader reader) {
                System.out.println("Shutdown requested. Shutting down...");
                Thread.currentThread().interrupt();
            }
        });
        this.setCommunicator(new Communicator(port, this.getClass().getClassLoader(), clientTypeToInitializer));
        this.getCommunicator().addCommunicationErrorListener((ICommunicationErrorListener)new CommunicationListener());
        this.logRunning();
        this.logStartListening();
        return this.getCommunicator().run();
    }

    private void initAutConnectionSocket() throws IOException, JBVersionException {
        this.setAutCommunicator(new Communicator(0, this.getClass().getClassLoader()));
        this.getAutCommunicator().addCommunicationErrorListener((ICommunicationErrorListener)new CommunicationListener());
        this.getAutCommunicator().run();
    }

    private void showUserInfo(String infoMessage) {
        if (this.m_verbosity.compareTo(Verbosity.QUIET) <= 0) {
            System.out.println(infoMessage);
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {}
            IsAliveThread t = new IsAliveThread(){

                public void run() {
                    try {
                        3.sleep((long)10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.getRootFrame().dispose();
                        }
                    });
                }
            };
            t.start();
            JOptionPane.showMessageDialog(null, String.valueOf(infoMessage) + I18n.getString((String)"AUTAgent.dialogClose"), I18n.getString((String)"AUTAgent.failedStartDialogTitle"), 1);
        }
    }

    private void logRunning() {
        if (log.isInfoEnabled()) {
            String message = "running VM with JRE version: " + System.getProperty("java.version");
            log.info(message);
        }
    }

    private void logStartListening() {
        if (log.isInfoEnabled()) {
            String message = "listening to port " + this.getCommunicator().getLocalPort();
            log.info(message);
        }
    }

    public AutAgent getAgent() {
        return this.m_agent;
    }

    private static class AUTServerWatcher
    extends IsAliveThread {
        private final Object m_autServerLock = new Object();
        private Process m_autServerProcess;
        private int m_autExitValue;
        private String m_errorStream;
        private boolean m_isExpectingAUTServerStop;
        private boolean m_isAgentSet;
        private CommunicationHelper m_messenger;

        public AUTServerWatcher(Process autServerProcess, boolean isAgentSet, CommunicationHelper messenger) {
            super("AUTServerWatcher");
            this.m_autServerProcess = autServerProcess;
            this.m_isAgentSet = isAgentSet;
            this.m_messenger = messenger;
        }

        private void handleStoppedAUTServer() {
            if (log.isInfoEnabled()) {
                log.info("trying to send message with AUTServer exitcode '" + String.valueOf(this.m_autExitValue) + "' to client");
            }
            StartAUTServerStateMessage message = null;
            ChooseCheckModeDialogBP.getInstance().closeDialog();
            ObservationConsoleBP.getInstance().closeShell();
            switch (this.m_autExitValue) {
                case 0: {
                    log.info("regular termination of AUTServer");
                    break;
                }
                case 25: {
                    message = new StartAUTServerStateMessage(1, "Error while starting AUT!");
                    break;
                }
                case 1: {
                    if (this.m_isAgentSet && this.m_errorStream != null) {
                        message = new StartAUTServerStateMessage(14, "JDK 1.5 or higher is required to start your AUT via executable file.");
                        break;
                    }
                    message = new StartAUTServerStateMessage(11, "invalid arguments");
                    break;
                }
                case 2: {
                    message = new StartAUTServerStateMessage(11, "invalid number of arguments");
                    break;
                }
                case 10: {
                    message = new StartAUTServerStateMessage(10, "establishing communication failed: invalid client");
                    break;
                }
                case 11: {
                    message = new StartAUTServerStateMessage(10, "establishing communication failed");
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    message = new StartAUTServerStateMessage(5, "security violation");
                    break;
                }
                case 3: 
                case 4: 
                case 12: {
                    break;
                }
                case 24: {
                    message = this.m_messenger.handleAutRestart();
                    break;
                }
                default: {
                    log.error("unknown AUTServer exit code: " + this.m_autExitValue + "'");
                    message = new StartAUTServerStateMessage(1, "unknown AUTServer exit code: '" + this.m_autExitValue + "'");
                }
            }
            this.m_messenger.sendStoppedAUTServerMessage(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                DevNull dn;
                Object object = this.m_autServerLock;
                synchronized (object) {
                    dn = new DevNull(this.m_autServerProcess.getErrorStream());
                    dn.start();
                    new DevNull(this.m_autServerProcess.getInputStream()).start();
                }
                this.m_autExitValue = this.m_autServerProcess.waitFor();
                this.m_errorStream = dn.getLine();
                object = this.m_autServerLock;
                synchronized (object) {
                    this.m_autServerProcess = null;
                }
                if (log.isInfoEnabled()) {
                    log.info("VM stopped with exitValue " + String.valueOf(this.m_autExitValue));
                }
                if (!this.m_isExpectingAUTServerStop) {
                    this.handleStoppedAUTServer();
                }
                this.m_isExpectingAUTServerStop = false;
            }
            catch (InterruptedException ie) {
                log.info("thread observing autserver process interrupted", (Throwable)ie);
            }
            catch (NullPointerException npe) {
                log.debug("autserver process already terminated", (Throwable)npe);
            }
        }
    }

    private class CommunicationHelper {
        private CommunicationHelper() {
        }

        public void sendStoppedAUTServerMessage(StartAUTServerStateMessage message) {
            if (message != null) {
                try {
                    AutStarter.this.getCommunicator().send((Message)message);
                }
                catch (CommunicationException communicationException) {
                }
                catch (NullPointerException nullPointerException) {}
            }
        }

        public StartAUTServerStateMessage handleAutRestart() {
            StartAUTServerStateMessage message = null;
            AutStarter.this.getAutCommunicator().close();
            AutStarter.this.getAutCommunicator().getConnectionManager().remove(AutStarter.this.getAutCommunicator().getConnection());
            try {
                AutStarter.this.initAutConnectionSocket();
            }
            catch (JBVersionException jBVersionException) {
                message = new StartAUTServerStateMessage(10, "version exception while restart AUT");
            }
            catch (IOException iOException) {
                message = new StartAUTServerStateMessage(10, "io exception while restart AUT");
            }
            return message;
        }
    }

    private class CommunicationListener
    implements ICommunicationErrorListener {
        private CommunicationListener() {
        }

        public void connectingFailed(InetAddress inetAddress, int port) {
            log.error("connectingFailed() called although this is a server");
        }

        public void connectionGained(InetAddress inetAddress, int port) {
            if (log.isInfoEnabled()) {
                try {
                    String message = "accepted connection from " + inetAddress.getHostName() + ":" + String.valueOf(port);
                    log.info(message);
                }
                catch (SecurityException se) {
                    log.warn("security violation while getting the host name from ip address", (Throwable)se);
                }
            }
        }

        public void acceptingFailed(int port) {
            log.error("accepting failed on port: " + String.valueOf(port));
        }

        public void sendFailed(Message message) {
            log.warn("sending message failed: " + String.valueOf(message));
        }

        public void shutDown() {
            log.info("connection closed");
        }
    }

    public static enum Verbosity {
        QUIET,
        NORMAL,
        VERBOSE;

    }
}

