/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the MenuBarComponent component from the concrete toolkit.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2015-05-27T07:16:16Z")
public class MenuBarComponent implements org.eclipse.jubula.toolkit.concrete.components.MenuBarComponent {
            public MenuBarComponent() {
                super();
            }
    
    protected IComponentIdentifier getPseudoComponentIdentifier() {
        return null;
    }
    
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectMenuEntryByTextpath(
            @NonNull String menupath,
            @NonNull Operator operator
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("selectMenuItem"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(menupath, "Argument 'menupath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(menupath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP selectMenuEntryByIndexpath(
            @NonNull String indexpath
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("selectMenuItemByIndexpath"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(indexpath), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEnablementOfEntryByTextpath(
            @NonNull String menupath,
            @NonNull Operator operator,
            @NonNull Boolean enabled
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("verifyEnabled"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(menupath, "Argument 'menupath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(menupath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(enabled), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkEnablementOfEntryByIndexpath(
            @NonNull String indexpath,
            @NonNull Boolean enabled
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("verifyEnabledByIndexpath"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(indexpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(enabled), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfEntryByTextpath(
            @NonNull String menupath,
            @NonNull Operator operator,
            @NonNull Boolean exists
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("verifyExists"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(menupath, "Argument 'menupath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(menupath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(exists), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfEntryByIndexpath(
            @NonNull String indexpath,
            @NonNull Boolean exists
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("verifyExistsByIndexpath"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(indexpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(exists), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionOfEntryByTextpath(
            @NonNull String menupath,
            @NonNull Operator operator,
            @NonNull Boolean selected
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("verifySelected"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(menupath, "Argument 'menupath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(menupath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(selected), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkSelectionOfEntryByIndexpath(
            @NonNull String indexpath,
            @NonNull Boolean selected
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("verifySelectedByIndexpath"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(indexpath), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(selected), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP waitForComponent(
            @NonNull Integer timeoutInMs,
            @NonNull Integer delayAfterVisibility
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("waitForComponent"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(timeoutInMs), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(delayAfterVisibility, "Argument 'delayAfterVisibility' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(delayAfterVisibility), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
} 