/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.mobile.provider.ui;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.ui.rcp.utils.DialogStatusParameter;
import org.eclipse.jubula.client.ui.rcp.widgets.autconfig.AutConfigComponent;
import org.eclipse.jubula.toolkit.mobile.provider.i18n.Messages;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class MobileAutConfigComponent
extends AutConfigComponent {
    private Text m_autHostTextField;
    private Text m_autPortTextField;
    private WidgetModifyListener m_modifyListener;

    public MobileAutConfigComponent(Composite parent, int style, Map<String, String> autConfig, String autName, String platform) {
        super(parent, style, autConfig, autName, false);
    }

    protected void populateBasicArea(Map<String, String> data) {
        super.populateBasicArea(data);
        if (!this.isDataNew(data)) {
            this.m_autHostTextField.setText(StringUtils.defaultString((String)data.get("AUT_HOST")));
            this.m_autPortTextField.setText(StringUtils.defaultString((String)data.get("AUT_HOST_PORT")));
        }
    }

    private WidgetModifyListener getModifyListener() {
        if (this.m_modifyListener == null) {
            this.m_modifyListener = new WidgetModifyListener();
        }
        return this.m_modifyListener;
    }

    protected void installListeners() {
        super.installListeners();
        WidgetModifyListener modifyListener = this.getModifyListener();
        this.getAUTAgentHostNameCombo().addModifyListener((ModifyListener)modifyListener);
        this.m_autHostTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_autPortTextField.addModifyListener((ModifyListener)modifyListener);
    }

    protected void deinstallListeners() {
        super.deinstallListeners();
        WidgetModifyListener modifyListener = this.getModifyListener();
        this.getAUTAgentHostNameCombo().removeModifyListener((ModifyListener)modifyListener);
        this.m_autHostTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_autPortTextField.removeModifyListener((ModifyListener)modifyListener);
    }

    protected void checkAll(List<DialogStatusParameter> paramList) {
        super.checkAll(paramList);
        this.addError(paramList, this.modifyAUTHostTextField());
        this.addError(paramList, this.modifyAUTPortTextField());
    }

    DialogStatusParameter modifyAUTHostTextField() {
        DialogStatusParameter error = null;
        String autHostname = this.m_autHostTextField.getText();
        if (autHostname.length() == 0) {
            error = this.createErrorStatus("The " + Messages.emptyHostname);
        } else {
            this.putConfigValue("AUT_HOST", autHostname);
        }
        return error;
    }

    DialogStatusParameter modifyAUTPortTextField() {
        DialogStatusParameter error = null;
        String autPortname = this.m_autPortTextField.getText();
        if (autPortname.length() == 0) {
            error = this.createErrorStatus("The " + Messages.emptyPort);
        } else {
            this.putConfigValue("AUT_HOST_PORT", autPortname);
        }
        return error;
    }

    protected void populateExpertArea(Map<String, String> data) {
    }

    protected void populateAdvancedArea(Map<String, String> data) {
    }

    protected void setAutHostTextField(Text autHostTextField) {
        this.m_autHostTextField = autHostTextField;
    }

    protected void setAutPortTextField(Text autPortTextField) {
        this.m_autPortTextField = autPortTextField;
    }

    private class WidgetModifyListener
    implements ModifyListener {
        private WidgetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            boolean checked = false;
            if (source.equals(MobileAutConfigComponent.this.m_autHostTextField)) {
                checked = true;
            } else if (source.equals(MobileAutConfigComponent.this.m_autPortTextField)) {
                checked = true;
            } else if (source.equals(MobileAutConfigComponent.this.getAUTAgentHostNameCombo())) {
                MobileAutConfigComponent.this.checkLocalhostServer();
                checked = true;
            }
            if (checked) {
                MobileAutConfigComponent.this.checkAll();
                return;
            }
            Assert.notReached((String)"Event activated by unknown widget.");
        }
    }
}

