/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.gen.parser.parameter.lexer.LexerException;
import org.eclipse.jubula.client.core.gen.parser.parameter.parser.Parser;
import org.eclipse.jubula.client.core.gen.parser.parameter.parser.ParserException;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.parser.parameter.JubulaParameterLexer;
import org.eclipse.jubula.client.core.utils.ExecObject;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;
import org.eclipse.jubula.client.core.utils.ParsedParameter;
import org.eclipse.jubula.client.core.utils.SemanticParsingException;
import org.eclipse.jubula.client.core.utils.TokenError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStringConverter
extends ParamValueConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleStringConverter.class);
    private ParamValueConverter.ConvValidationState m_actualState;

    public SimpleStringConverter(String guiString) {
        this.init(guiString);
    }

    public ParamValueConverter.ConvValidationState getState() {
        return this.m_actualState;
    }

    protected void init(String guiString) {
        this.setGuiString(guiString);
        this.createTokens();
    }

    @Override
    void createTokens() {
        Parser parser = new Parser(new JubulaParameterLexer(new PushbackReader(new StringReader(StringUtils.defaultString((String)this.getGuiString())))));
        ParsedParameter parsedParam = new ParsedParameter(true, null, null);
        try {
            parser.parse().apply(parsedParam);
            List<IParamValueToken> liste = parsedParam.getTokens();
            this.setTokens(liste);
        }
        catch (LexerException e) {
            this.createErrors(e, this.getGuiString());
        }
        catch (ParserException e) {
            this.createErrors(e, this.getGuiString());
        }
        catch (IOException e) {
            LOG.error(Messages.ParameterParsingErrorOccurred, (Throwable)e);
            this.createErrors(e, this.getGuiString());
        }
        catch (SemanticParsingException e) {
            this.createErrors(e, this.getGuiString());
        }
    }

    public ParamValueConverter.ConvValidationState getErrorStatus() {
        ParamValueConverter.ConvValidationState val = ParamValueConverter.ConvValidationState.valid;
        List<TokenError> errors = this.getErrors();
        if (errors.isEmpty()) {
            return val;
        }
        for (TokenError error : errors) {
            if (error.getValidationState() == ParamValueConverter.ConvValidationState.invalid) {
                return ParamValueConverter.ConvValidationState.invalid;
            }
            if (error.getValidationState() != ParamValueConverter.ConvValidationState.undecided) continue;
            val = ParamValueConverter.ConvValidationState.undecided;
        }
        return val;
    }

    @Override
    public void validateSingleTokens() {
    }

    @Override
    public String getExecutionString(List<ExecObject> stack, Locale locale) {
        return null;
    }
}

