/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.inspector.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.inspector.ui.commands.ActivateInspectorResponseCommand;
import org.eclipse.jubula.client.inspector.ui.i18n.Messages;
import org.eclipse.jubula.client.internal.BaseConnection;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.JobUtils;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.ActivateInspectorMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;

public class ActivateInspectorHandler
extends AbstractHandler {
    public static final String AUT_ID = "org.eclipse.jubula.client.inspector.ui.commands.parameter.activateInspector.autId";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final AutIdentifier autId = (AutIdentifier)event.getObjectParameterForExecution(AUT_ID);
        final String jobName = Messages.UIJobActivateInspector;
        Job activateInspectorJob = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(jobName, -1);
                ActivateInspectorMessage message = new ActivateInspectorMessage();
                try {
                    AUTConnection.getInstance().connectToAut(autId, (IProgressMonitor)new NullProgressMonitor());
                    AUTConnection.getInstance().request((Message)message, (ICommand)new ActivateInspectorResponseCommand(), 5000);
                }
                catch (BaseConnection.NotConnectedException notConnectedException) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_NO_AUT_CONNECTION_ERROR);
                }
                catch (ConnectionException ce) {
                    ErrorHandlingUtil.createMessageDialog((JBException)ce, null, null);
                }
                catch (CommunicationException ce) {
                    ErrorHandlingUtil.createMessageDialog((JBException)ce, null, null);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        activateInspectorJob.setSystem(true);
        JobUtils.executeJob((Job)activateInspectorJob, null);
        return null;
    }
}

