/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the Application component from the concrete toolkit.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ClassGenerator", 
           date =  "2015-06-02T12:49:26.749Z")
public class Application implements org.eclipse.jubula.toolkit.concrete.components.Application {
            public Application() {
                super();
            }
    
    protected IComponentIdentifier getPseudoComponentIdentifier() {
        return null;
    }
    
        /**
         * Performs arbitrary clicks into the currently active AUT window
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP clickInActiveWindow(
            @NonNull Integer numberOfClicks,
            @NonNull InteractionMode mouseButton,
            @NonNull Integer xPosition,
            @NonNull Unit xUnits,
            @NonNull Integer yPosition,
            @NonNull Unit yUnits
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcClickDirect"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(numberOfClicks), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(mouseButton.rcValue(), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(xPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(xUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(yPosition), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(yUnits.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param activationMethod 
         *        the AUT activation method to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP activate(
            @NonNull AUTActivationMethod activationMethod
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcActivate"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(activationMethod, "Argument 'activationMethod' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(activationMethod.rcValue(), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP inputText(
            @NonNull String text
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcInputText"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param modifierKeys 
         *        the modifier keys
         * @param baseKey 
         *        the base key to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP keyCombination(
            @NonNull Modifier[] modifierKeys,
            @NonNull String baseKey
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcKeyStroke"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(baseKey, "Argument 'baseKey' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(baseKey), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param key 
         *        the toggle key
         * @param activateKey 
         *        the activate key
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP setToggleKey(
            @NonNull Integer key,
            @NonNull Boolean activateKey
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcToggle"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(key, "Argument 'key' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(key), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(activateKey, "Argument 'activateKey' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(activateKey), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param millisecs 
         *        the amount of milliseconds
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP delay(
            @NonNull Integer millisecs
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcWait"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(millisecs, "Argument 'millisecs' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(millisecs), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        @NonNull public CAP pauseTestExecution(
        )  {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcPause"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            return messageCap;
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP waitForWindow(
            @NonNull String title,
            @NonNull Operator operator,
            @NonNull Integer timeoutInMs,
            @NonNull Integer delayAfterVisibility
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcWaitForWindow"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(title), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(timeoutInMs), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(delayAfterVisibility, "Argument 'delayAfterVisibility' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(delayAfterVisibility), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP waitForWindowActivation(
            @NonNull String title,
            @NonNull Operator operator,
            @NonNull Integer timeoutInMs,
            @NonNull Integer delayAfterVisibility
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcWaitForWindowActivation"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(title), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(timeoutInMs), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(delayAfterVisibility, "Argument 'delayAfterVisibility' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(delayAfterVisibility), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterClosure 
         *        the static delay after closure
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP waitForWindowToClose(
            @NonNull String title,
            @NonNull Operator operator,
            @NonNull Integer timeoutInMs,
            @NonNull Integer delayAfterClosure
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcWaitForWindowToClose"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(title), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(timeoutInMs), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(delayAfterClosure, "Argument 'delayAfterClosure' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(delayAfterClosure), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param destination 
         *        the destination to use
         * @param delay 
         *        the static delay
         * @param fileAccess 
         *        the file access type
         * @param scalingFactor 
         *        the scaling factor
         * @param createDirectories 
         *        whether to implicitly create directories
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP takeScreenshot(
            @NonNull String destination,
            @NonNull Integer delay,
            @NonNull String fileAccess,
            @NonNull Integer scalingFactor,
            @NonNull Boolean createDirectories
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcTakeScreenshot"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(destination, "Argument 'destination' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(destination), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(delay, "Argument 'delay' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(delay), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(fileAccess, "Argument 'fileAccess' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(fileAccess), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(scalingFactor, "Argument 'scalingFactor' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(scalingFactor), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(createDirectories, "Argument 'createDirectories' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(createDirectories), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param modifierKeys 
         *        the modifier keys
         * @param baseKey 
         *        the base key to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP externalKeyCombination(
            @NonNull Modifier[] modifierKeys,
            @NonNull String baseKey
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcNativeKeyStroke"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(baseKey, "Argument 'baseKey' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(baseKey), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP externalInputText(
            @NonNull String text
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcNativeInputText"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP copyTextToClipboard(
            @NonNull String text
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcCopyToClipboard"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(text), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param value1 
         *        the first value
         * @param comparisonMethod 
         *        the comparison method
         * @param value2 
         *        the second value
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkNumericValues(
            @NonNull String value1,
            @NonNull String comparisonMethod,
            @NonNull String value2
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcCheckValues"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(value1, "Argument 'value1' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(value1), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(comparisonMethod, "Argument 'comparisonMethod' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(comparisonMethod), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(value2, "Argument 'value2' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(value2), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param destination 
         *        the destination to use
         * @param delay 
         *        the static delay
         * @param fileAccess 
         *        the file access type
         * @param scalingFactor 
         *        the scaling factor
         * @param createDirectories 
         *        whether to implicitly create directories
         * @param marginTop 
         *        the top margin
         * @param marginRight 
         *        the right margin
         * @param marginBottom 
         *        the bottom margin
         * @param marginLeft 
         *        the left margin
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP takeScreenshotOfActiveWindow(
            @NonNull String destination,
            @NonNull Integer delay,
            @NonNull String fileAccess,
            @NonNull Integer scalingFactor,
            @NonNull Boolean createDirectories,
            @NonNull Integer marginTop,
            @NonNull Integer marginRight,
            @NonNull Integer marginBottom,
            @NonNull Integer marginLeft
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcTakeScreenshotOfActiveWindow"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(destination, "Argument 'destination' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(destination), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(delay, "Argument 'delay' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(delay), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(fileAccess, "Argument 'fileAccess' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(fileAccess), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(scalingFactor, "Argument 'scalingFactor' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(scalingFactor), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(createDirectories, "Argument 'createDirectories' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(createDirectories), "java.lang.Boolean")); //$NON-NLS-1$
            Validate.notNull(marginTop, "Argument 'marginTop' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(marginTop), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(marginRight, "Argument 'marginRight' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(marginRight), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(marginBottom, "Argument 'marginBottom' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(marginBottom), "java.lang.Integer")); //$NON-NLS-1$
            Validate.notNull(marginLeft, "Argument 'marginLeft' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(marginLeft), "java.lang.Integer")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param value1 
         *        the first value
         * @param value2Operator 
         *        the operator used for comparison with value 2
         * @param value2 
         *        the second value
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkStringValues(
            @NonNull String value1,
            @NonNull String value2Operator,
            @NonNull String value2
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcCheckStringValues"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(value1, "Argument 'value1' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(value1), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(value2Operator, "Argument 'value2Operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(value2Operator), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(value2, "Argument 'value2' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(value2), "java.lang.String")); //$NON-NLS-1$
            return messageCap;
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         */
        @NonNull public CAP checkExistenceOfWindow(
            @NonNull String title,
            @NonNull Operator operator,
            @NonNull Boolean exists
        ) throws IllegalArgumentException {
            MessageCap messageCap = new MessageCap();
            messageCap.setMethod("rcCheckExistenceOfWindow"); //$NON-NLS-1$
            messageCap.sethasDefaultMapping(true);
            messageCap.setCi(getPseudoComponentIdentifier());
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(title), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(operator.rcValue(), "java.lang.String")); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            messageCap.addMessageParam(new MessageParam(String.valueOf(exists), "java.lang.Boolean")); //$NON-NLS-1$
            return messageCap;
        }
        
} 