/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ProjectVersion;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;

@Entity
@Table(name="REUSED_PROJECTS", uniqueConstraints={@UniqueConstraint(columnNames={"PARENT_PROJ", "REUSED_PROJ_GUID"})})
class ReusedProjectPO
implements IReusedProjectPO,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
PersistenceWeavedRest {
    private transient Long m_id;
    private Integer m_majorNumber;
    private Integer m_minorNumber;
    private Integer m_microNumber;
    private String m_versionQualifier;
    private Integer m_version;
    private String m_projectGuid;
    private Long m_parentProjectId;
    static final long serialVersionUID = -2983481015823134443L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;

    private ReusedProjectPO() {
        this.m_id = null;
        this.m_majorNumber = null;
        this.m_minorNumber = null;
        this.m_microNumber = null;
        this.m_versionQualifier = null;
        this.m_version = null;
        this.m_projectGuid = null;
        this.m_parentProjectId = null;
    }

    ReusedProjectPO(String projectGuid, Integer majorNumber, Integer minorNumber, Integer microNumber, String versionQualifier) {
        this.m_id = null;
        this.m_majorNumber = null;
        this.m_minorNumber = null;
        this.m_microNumber = null;
        this.m_versionQualifier = null;
        this.m_version = null;
        this.m_projectGuid = null;
        this.m_parentProjectId = null;
        this.setProjectGuid(projectGuid);
        this.setMajorNumber(majorNumber);
        this.setMinorNumber(minorNumber);
        this.setMicroNumber(microNumber);
        this.setVersionQualifier(versionQualifier);
    }

    @Override
    @Transient
    public String getProjectName() {
        return ProjectNameBP.getInstance().getName(this.getProjectGuid());
    }

    @Override
    @Basic
    @Column(name="MAJOR_VERS_NUMBER")
    public Integer getMajorNumber() {
        return this.m_majorNumber;
    }

    private void setMajorNumber(Integer majorNumber) {
        this.m_majorNumber = majorNumber;
    }

    @Override
    @Basic
    @Column(name="MINOR_VERS_NUMBER")
    public Integer getMinorNumber() {
        return this.m_minorNumber;
    }

    private void setMinorNumber(Integer minorNumber) {
        this.m_minorNumber = minorNumber;
    }

    @Override
    @Basic
    @Column(name="MICRO_VERS_NUMBER")
    public Integer getMicroNumber() {
        return this.m_microNumber;
    }

    private void setMicroNumber(Integer microNumber) {
        this.m_microNumber = microNumber;
    }

    @Override
    @Basic
    @Column(name="VERSION_QUALIFIER")
    public String getVersionQualifier() {
        return this.m_versionQualifier;
    }

    private void setVersionQualifier(String versionQualifier) {
        this.m_versionQualifier = versionQualifier;
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    void setId(Long id) {
        this.m_id = id;
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return this.getHbmParentProjectId();
    }

    @Override
    public void setParentProjectId(Long projectId) {
        this.setHbmParentProjectId(projectId);
    }

    @Basic
    @Column(name="PARENT_PROJ")
    Long getHbmParentProjectId() {
        return this.m_parentProjectId;
    }

    void setHbmParentProjectId(Long projectId) {
        this.m_parentProjectId = projectId;
    }

    @Override
    @Transient
    public String getName() {
        return this.getProjectName() != null ? this.getProjectName() : this.getProjectGuid();
    }

    @Override
    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    @Basic
    @Column(name="REUSED_PROJ_GUID")
    public String getProjectGuid() {
        return this.m_projectGuid;
    }

    private void setProjectGuid(String projectGuid) {
        this.m_projectGuid = projectGuid;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IReusedProjectPO) {
            IReusedProjectPO reused = (IReusedProjectPO)obj;
            return new EqualsBuilder().append((Object)this.getMajorNumber(), (Object)reused.getMajorNumber()).append((Object)this.getMinorNumber(), (Object)reused.getMinorNumber()).append((Object)this.getMicroNumber(), (Object)reused.getMicroNumber()).append((Object)this.getVersionQualifier(), (Object)reused.getVersionQualifier()).append((Object)this.getParentProjectId(), (Object)reused.getParentProjectId()).append((Object)this.getProjectGuid(), (Object)reused.getProjectGuid()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getMajorNumber()).append((Object)this.getMinorNumber()).append((Object)this.getMicroNumber()).append((Object)this.getVersionQualifier()).append((Object)this.getParentProjectId()).append((Object)this.getProjectGuid()).toHashCode();
    }

    @Override
    public int compareTo(IReusedProjectPO otherReused) {
        int retVal = this.getName().compareTo(otherReused.getName());
        if (retVal == 0) {
            retVal = this.getVersionString().compareTo(otherReused.getVersionString());
        }
        return retVal;
    }

    @Override
    @Transient
    public String getVersionString() {
        return this.getProjectVersion().toString();
    }

    @Override
    @Transient
    public ProjectVersion getProjectVersion() {
        return new ProjectVersion(this.getMajorNumber(), this.getMinorNumber(), this.getMicroNumber(), this.getVersionQualifier());
    }

    public Object _persistence_post_clone() {
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ReusedProjectPO(persistenceObject);
    }

    public ReusedProjectPO(PersistenceObject persistenceObject) {
    }

    public Object _persistence_get(String string) {
        if (string == "microNumber") {
            return this.microNumber;
        }
        if (string == "majorNumber") {
            return this.majorNumber;
        }
        if (string == "versionQualifier") {
            return this.versionQualifier;
        }
        if (string == "minorNumber") {
            return this.minorNumber;
        }
        if (string == "projectGuid") {
            return this.projectGuid;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "version") {
            return this.version;
        }
        if (string == "hbmParentProjectId") {
            return this.hbmParentProjectId;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "microNumber") {
            this.microNumber = (Integer)object;
            return;
        }
        if (string == "majorNumber") {
            this.majorNumber = (Integer)object;
            return;
        }
        if (string == "versionQualifier") {
            this.versionQualifier = (String)object;
            return;
        }
        if (string == "minorNumber") {
            this.minorNumber = (Integer)object;
            return;
        }
        if (string == "projectGuid") {
            this.projectGuid = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
        if (string == "hbmParentProjectId") {
            this.hbmParentProjectId = (Long)object;
            return;
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }
}

