/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.AbstractParamInterfaceBP;
import org.eclipse.jubula.client.core.businessprocess.ParameterInterfaceBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.dialogs.AbstractEditParametersDialog;
import org.eclipse.jubula.client.ui.rcp.dialogs.EditParametersTDMDialog;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractEditParametersHandler;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.ui.handlers.HandlerUtil;

public class EditTDMParametersHandler
extends AbstractEditParametersHandler {
    protected final ITestDataCubePO getSelectedTestDataManager(ExecutionEvent event) {
        IStructuredSelection structuredSelection;
        Object selectedObject;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (selectedObject = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof ITestDataCubePO) {
            return (ITestDataCubePO)selectedObject;
        }
        return null;
    }

    public Object executeImpl(ExecutionEvent event) {
        final ITestDataCubePO tdc = this.getSelectedTestDataManager(event);
        if (tdc != null) {
            final IJBEditor editor = this.getEditor(event);
            editor.getEditorHelper().doEditorOperation(new IEditorOperation(){

                @Override
                public void run(IPersistentObject workingPo) {
                    EditParametersTDMDialog dialog = new EditParametersTDMDialog(EditTDMParametersHandler.this.getActiveShell(), (IParameterInterfacePO)tdc);
                    dialog.create();
                    DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
                    if (dialog.open() == 0) {
                        EditTDMParametersHandler.this.performChanges(editor, tdc, dialog);
                    }
                }
            });
        }
        return null;
    }

    private void performChanges(IJBEditor editor, ITestDataCubePO tdc, AbstractEditParametersDialog dialog) {
        List<AbstractEditParametersDialog.Parameter> parameters = dialog.getParameters();
        boolean isModified = EditTDMParametersHandler.editParameters(tdc, parameters, editor.getEditorHelper().getEditSupport().getParamMapper(), (AbstractParamInterfaceBP<ITestDataCubePO>)new ParameterInterfaceBP());
        if (isModified) {
            editor.getEditorHelper().setDirty(true);
            DataEventDispatcher ded = DataEventDispatcher.getInstance();
            ded.fireParamChangedListener();
            ded.firePropertyChanged(false);
            ded.fireDataChangedListener((IPersistentObject)tdc, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        }
    }
}

